/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.threading;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.roguelogix.phosphophyllite.threading.Event;

public class WorkQueue {
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
    private final ArrayList<DequeueThread> dequeueThreads = new ArrayList();

    public WorkQueue() {
        this.dequeueThreads.forEach(DequeueThread::finish);
    }

    public WorkQueue addProcessingThread() {
        return this.addProcessingThreads(1, null);
    }

    public WorkQueue addProcessingThreads(int threads) {
        return this.addProcessingThreads(threads, null);
    }

    public WorkQueue addProcessingThreads(int threads, String name) {
        for (int i = 0; i < threads; ++i) {
            this.dequeueThreads.add(new DequeueThread(this.queue, name == null ? null : name + i));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        this.dequeueThreads.forEach(DequeueThread::finish);
        Queue<Runnable> queue = this.queue;
        synchronized (queue) {
            this.queue.notifyAll();
        }
    }

    protected void finalize() {
        this.finish();
    }

    public Event enqueue(Runnable runnable, Set<Event> events) {
        return this.enqueue(runnable, (Event[])events.toArray());
    }

    public Event enqueue(Runnable runnable, List<Event> events) {
        return this.enqueue(runnable, (Event[])events.toArray());
    }

    public Event enqueue(Runnable runnable, Event ... events) {
        WorkItem item = new WorkItem(this.queue, runnable, events);
        return item.waitEvent;
    }

    public void runOne() {
        if (!this.dequeueThreads.isEmpty()) {
            return;
        }
        Runnable toRun = this.queue.poll();
        if (toRun != null) {
            toRun.run();
        }
    }

    public void runAll() {
        Runnable toRun;
        if (!this.dequeueThreads.isEmpty()) {
            return;
        }
        while ((toRun = this.queue.poll()) != null) {
            toRun.run();
        }
    }

    private static class WorkItem
    implements Runnable {
        final Event waitEvent = new Event();
        final Event readyEvent = new Event();
        final Runnable work;
        final AtomicLong unTriggeredWaitEvents = new AtomicLong(Long.MAX_VALUE);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WorkItem(Queue<Runnable> queue, Runnable work, Event[] waitEvents) {
            this.work = work;
            if (waitEvents.length == 0) {
                queue.add(this);
                Queue<Runnable> queue2 = queue;
                synchronized (queue2) {
                    queue.notify();
                }
                return;
            }
            this.unTriggeredWaitEvents.set(waitEvents.length);
            for (Event event : waitEvents) {
                if (event == null) {
                    Event event2 = this.readyEvent;
                    synchronized (event2) {
                        if (this.unTriggeredWaitEvents.decrementAndGet() == 0L) {
                            this.readyEvent.trigger();
                        }
                    }
                }
                assert (event != null);
                event.registerCallback(() -> {
                    Event event = this.readyEvent;
                    synchronized (event) {
                        if (this.unTriggeredWaitEvents.decrementAndGet() == 0L) {
                            this.readyEvent.trigger();
                        }
                    }
                });
            }
            this.readyEvent.registerCallback(() -> {
                queue.add(this);
                Queue queue2 = queue;
                synchronized (queue2) {
                    queue.notify();
                }
            });
        }

        @Override
        public void run() {
            try {
                this.work.run();
            }
            finally {
                this.waitEvent.trigger();
            }
        }
    }

    private static class DequeueThread
    implements Runnable {
        private final WeakReference<Queue<Runnable>> queue;
        private final AtomicBoolean stop = new AtomicBoolean(false);

        public DequeueThread(Queue<Runnable> queue, String name) {
            this.queue = new WeakReference<Queue<Runnable>>(queue);
            Thread thread = new Thread(this);
            if (name != null) {
                thread.setName(name);
            }
            thread.setDaemon(true);
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop.get()) {
                Queue queue = (Queue)this.queue.get();
                if (queue == null) {
                    return;
                }
                Runnable nextItem = (Runnable)queue.poll();
                if (nextItem == null) {
                    Queue queue2 = queue;
                    synchronized (queue2) {
                        try {
                            queue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                try {
                    nextItem.run();
                }
                catch (Throwable throwable) {}
            }
        }

        public void finish() {
            this.stop.set(true);
        }
    }
}

