/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.threading;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class Event {
    private final ArrayList<Runnable> callbacks = new ArrayList();
    private final AtomicBoolean wasTriggered = new AtomicBoolean(false);

    public boolean ready() {
        return this.wasTriggered.get();
    }

    public synchronized void join() {
        if (this.wasTriggered.get()) {
            return;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized boolean join(int timeout) {
        if (this.wasTriggered.get()) {
            return true;
        }
        try {
            this.wait(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.wasTriggered.get();
    }

    public synchronized void trigger() {
        if (this.wasTriggered.get()) {
            return;
        }
        this.wasTriggered.set(true);
        this.callbacks.forEach(Runnable::run);
        this.notifyAll();
    }

    public synchronized void registerCallback(Runnable runnable) {
        if (this.wasTriggered.get()) {
            runnable.run();
            return;
        }
        this.callbacks.add(runnable);
    }

    protected void finalize() {
        this.trigger();
    }
}

