/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import exopandora.worldhandler.builder.impl.BuilderExecute;
import exopandora.worldhandler.builder.impl.BuilderFill;
import exopandora.worldhandler.builder.impl.BuilderSetBlock;
import exopandora.worldhandler.builder.types.BlockResourceLocation;
import exopandora.worldhandler.builder.types.Coordinate;
import exopandora.worldhandler.builder.types.CoordinateInt;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.util.CommandHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CUpdateCommandBlockPacket;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public class BlockHelper {
    private static BlockPos pos1 = BlockPos.field_177992_a;
    private static BlockPos pos2 = BlockPos.field_177992_a;
    private static final List<Consumer<BlockPos>> POS_1_OBSERVERS = new ArrayList<Consumer<BlockPos>>();
    private static final List<Consumer<BlockPos>> POS_2_OBSERVERS = new ArrayList<Consumer<BlockPos>>();
    private static final Block[] BLACKLIST = new Block[]{Blocks.field_150350_a, Blocks.field_150355_j, Blocks.field_150353_l};

    @Nonnull
    public static BlockPos getFocusedBlockPos() {
        BlockRayTraceResult blockResult;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        RayTraceResult result = Minecraft.func_71410_x().field_71476_x;
        if (result != null && RayTraceResult.Type.BLOCK.equals((Object)result.func_216346_c()) && world != null && !ArrayUtils.contains((Object[])BLACKLIST, (Object)world.func_180495_p((blockResult = (BlockRayTraceResult)result).func_216350_a()).func_177230_c())) {
            return blockResult.func_216350_a();
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            return player.func_233580_cy_();
        }
        return BlockPos.field_177992_a;
    }

    @Nonnull
    public static Block getFocusedBlock() {
        return BlockHelper.getBlock(BlockHelper.getFocusedBlockPos());
    }

    @Nonnull
    public static Block getBlock(BlockPos pos) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            return world.func_180495_p(pos).func_177230_c();
        }
        return Blocks.field_150350_a;
    }

    public static BlockPos setX(BlockPos pos, double x) {
        return new BlockPos(x, (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static BlockPos setY(BlockPos pos, double y) {
        return new BlockPos((double)pos.func_177958_n(), y, (double)pos.func_177952_p());
    }

    public static BlockPos setZ(BlockPos pos, double z) {
        return new BlockPos((double)pos.func_177958_n(), (double)pos.func_177956_o(), z);
    }

    @Nonnull
    public static BlockPos getPos1() {
        return pos1;
    }

    public static void setPos1(BlockPos pos) {
        if (pos != null && !pos1.equals((Object)pos)) {
            pos1 = pos;
            for (Consumer<BlockPos> observer : POS_1_OBSERVERS) {
                observer.accept(pos1);
            }
        }
    }

    @Nonnull
    public static BlockPos getPos2() {
        return pos2;
    }

    public static void setPos2(BlockPos pos) {
        if (pos != null && !pos2.equals((Object)pos)) {
            pos2 = pos;
            for (Consumer<BlockPos> observer : POS_2_OBSERVERS) {
                observer.accept(pos2);
            }
        }
    }

    public static <T> T addPositionObservers(T observer, Function<T, Consumer<BlockPos>> pos1generator, Function<T, Consumer<BlockPos>> pos2generator) {
        BlockHelper.addPos1Observer(pos1generator.apply(observer));
        BlockHelper.addPos2Observer(pos2generator.apply(observer));
        return observer;
    }

    public static void addPos1Observer(Consumer<BlockPos> observer) {
        POS_1_OBSERVERS.add(observer);
    }

    public static void removePos1Observer(Consumer<BlockPos> observer) {
        POS_1_OBSERVERS.remove(observer);
    }

    public static void addPos2Observer(Consumer<BlockPos> observer) {
        POS_2_OBSERVERS.add(observer);
    }

    public static void removePos2Observer(Consumer<BlockPos> observer) {
        POS_2_OBSERVERS.add(observer);
    }

    public static boolean setCommandBlockNearPlayer(String player, String command) {
        if (CommandHelper.canPlayerIssueCommand() && Minecraft.func_71410_x().func_147114_u() != null) {
            BlockPos pos = Minecraft.func_71410_x().field_71439_g.func_233580_cy_().func_177982_a(0, 3, 0);
            BuilderFill placeFill = new BuilderFill();
            placeFill.setPosition1(pos);
            placeFill.setPosition2(pos.func_177984_a());
            placeFill.setBlock1(new BlockResourceLocation(Blocks.field_150483_bI.getRegistryName()));
            BuilderFill removeFill = new BuilderFill();
            removeFill.setX1(new CoordinateInt(0, Coordinate.EnumType.GLOBAL));
            removeFill.setY1(new CoordinateInt(-1, Coordinate.EnumType.GLOBAL));
            removeFill.setZ1(new CoordinateInt(0, Coordinate.EnumType.GLOBAL));
            removeFill.setX2(new CoordinateInt(0, Coordinate.EnumType.GLOBAL));
            removeFill.setY2(new CoordinateInt(0, Coordinate.EnumType.GLOBAL));
            removeFill.setZ2(new CoordinateInt(0, Coordinate.EnumType.GLOBAL));
            removeFill.setBlock1(new BlockResourceLocation(Blocks.field_150350_a.getRegistryName()));
            Minecraft.func_71410_x().field_71439_g.func_71165_d(placeFill.toActualCommand());
            BuilderExecute wrapped = new BuilderExecute();
            wrapped.setMode1(BuilderExecute.EnumMode.AT);
            wrapped.setTarget(player);
            wrapped.setMode2(BuilderExecute.EnumMode.RUN);
            wrapped.setCommand(command);
            Minecraft.func_71410_x().func_147114_u().func_147297_a((IPacket)new CUpdateCommandBlockPacket(pos, wrapped.toActualCommand(), CommandBlockTileEntity.Mode.REDSTONE, true, false, true));
            Minecraft.func_71410_x().func_147114_u().func_147297_a((IPacket)new CUpdateCommandBlockPacket(pos.func_177984_a(), removeFill.toActualCommand(), CommandBlockTileEntity.Mode.REDSTONE, true, false, true));
            return true;
        }
        return false;
    }

    public static void setBlockNearPlayer(String player, Block block) {
        BuilderSetBlock builder = new BuilderSetBlock(new CoordinateInt(Coordinate.EnumType.LOCAL), new CoordinateInt(Coordinate.EnumType.LOCAL), new CoordinateInt(2, Coordinate.EnumType.LOCAL), block.getRegistryName(), Config.getSettings().getBlockPlacingMode());
        if (Minecraft.func_71410_x().field_71439_g != null) {
            builder.setState(BlockStateProperties.field_208157_J, Minecraft.func_71410_x().field_71439_g.func_174811_aO().func_176734_d());
        }
        CommandHelper.sendCommand(player, builder);
    }
}

