/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import exopandora.worldhandler.config.Config;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.widget.IContainerWidget;
import exopandora.worldhandler.gui.widget.button.GuiButtonTab;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.RenderUtils;
import exopandora.worldhandler.util.TextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WidgetTabRenderer
implements IContainerWidget {
    private static final int SPACING = 2;
    private static final int WEDGE_HEIGHT = 10;

    @Override
    public void initGui(Container container, int x, int y) {
        Content content = container.getContent();
        Category category = content.getCategory();
        int xPos = container.getBackgroundX();
        int yPos = container.getBackgroundY() - 20;
        int size = category.getSize();
        for (int index = 0; index < size; ++index) {
            Content tab = category.getContent(index);
            if (tab.equals(content.getActiveContent())) continue;
            int width = WidgetTabRenderer.width(container, index, size);
            int offset = WidgetTabRenderer.offset(container, index, size);
            container.addWidget((Widget)new GuiButtonTab(xPos + offset, yPos, width, 21, (ITextComponent)tab.getTabTitle(), () -> ActionHelper.open(tab)));
        }
    }

    @Override
    public void drawScreen(MatrixStack matrix, Container container, int x, int y, int mouseX, int mouseY, float partialTicks) {
        Content content = container.getContent();
        Category category = content.getCategory();
        int xPos = container.getBackgroundX();
        int yPos = container.getBackgroundY();
        int size = category.getSize();
        container.func_230926_e_(0);
        for (int index = 0; index < size; ++index) {
            int width = WidgetTabRenderer.width(container, index, size);
            int offset = WidgetTabRenderer.offset(container, index, size);
            Content tab = category.getContent(index);
            IFormattableTextComponent title = TextUtils.stripText(tab.getTabTitle().func_240699_a_(TextFormatting.UNDERLINE), width, Minecraft.func_71410_x().field_71466_p);
            if (content.getActiveContent().equals(tab)) {
                int height = Config.getSkin().getBackgroundAlphaInt() == 255 ? 25 : 22;
                this.drawActiveTab(matrix, container, index, size, xPos + offset, yPos - 22, width, height, (ITextComponent)title);
                continue;
            }
            this.drawInactiveTab(matrix, container, index, size, xPos + offset, yPos - 20, width, 20, (ITextComponent)title);
        }
        RenderUtils.colorDefaultBackground();
    }

    private void drawActiveTab(MatrixStack matrix, Container container, int index, int size, int x, int y, int width, int height, ITextComponent title) {
        RenderUtils.colorDefaultBackground();
        this.drawTabBackground(matrix, container, x, y, width, height);
        if (!Config.getSkin().sharpEdges()) {
            RenderSystem.enableBlend();
            if (Config.getSkin().getBackgroundAlphaInt() == 255) {
                if (index > 0) {
                    RenderUtils.drawTexturedTriangleBL(matrix, (AbstractGui)container, x, y + height - 2, x - container.getBackgroundX(), 1, 2);
                }
                if (index < size - 1 || size == 1) {
                    RenderUtils.drawTexturedTriangleBR(matrix, (AbstractGui)container, x + width - 2, y + height - 2, x - container.getBackgroundX() + width, 1, 2);
                }
                if (index == 0) {
                    RenderUtils.drawTexturedWedgeGradientTL(matrix, (AbstractGui)container, x, y + height, 0, height, width, 10);
                }
                if (index == size - 1 && size > 1) {
                    RenderUtils.drawTexturedWedgeGradientTR(matrix, (AbstractGui)container, x, y + height, x - container.getBackgroundX(), height, width, 10);
                }
            } else {
                this.drawTabBackgroundMerge(matrix, container, index, size, x, y, width, height);
            }
            RenderSystem.disableBlend();
        }
        this.drawTabTitle(matrix, (AbstractGui)container, title, x + width / 2, y + 9, 0xFFFFFF);
    }

    private void drawInactiveTab(MatrixStack matrix, Container container, int index, int size, int x, int y, int width, int height, ITextComponent title) {
        RenderUtils.colorDarkBackground();
        this.drawTabBackground(matrix, container, x, y, width, 20);
        if (!Config.getSkin().sharpEdges()) {
            RenderSystem.enableBlend();
            this.drawTabBackgroundMerge(matrix, container, index, size, x, y, width, height);
            RenderSystem.disableBlend();
        }
        this.drawTabTitle(matrix, (AbstractGui)container, title, x + width / 2, y + 7, 0xE0E0E0);
    }

    private void drawTabBackgroundMerge(MatrixStack matrix, Container container, int index, int size, int x, int y, int width, int height) {
        if (index == 0) {
            RenderUtils.drawTexturedTriangleTL(matrix, (AbstractGui)container, x, y + height, 0, height, 2);
        }
        if (index == size - 1) {
            RenderUtils.drawTexturedTriangleTR(matrix, (AbstractGui)container, x + width - 3, y + height, container.getBackgroundWidth() - 3, height, 3);
        }
    }

    private void drawTabBackground(MatrixStack matrix, Container container, int x, int y, int width, int height) {
        container.bindBackground();
        container.func_230926_e_(-1);
        int left = MathHelper.func_76143_f((double)((double)width / 2.0));
        int right = MathHelper.func_76128_c((double)((double)width / 2.0));
        RenderSystem.enableBlend();
        container.func_238474_b_(matrix, x, y, 0, 0, left, height);
        container.func_238474_b_(matrix, x + left, y, container.getBackgroundWidth() - right, 0, right, height);
        RenderSystem.disableBlend();
    }

    private void drawTabTitle(MatrixStack matrix, AbstractGui gui, ITextComponent title, int x, int y, int color) {
        gui.func_230926_e_(0);
        AbstractGui.func_238472_a_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)title, (int)x, (int)y, (int)color);
    }

    @Override
    public IContainerWidget.EnumLayer getLayer() {
        return IContainerWidget.EnumLayer.BACKGROUND;
    }

    private static int width(Container container, int index, int size) {
        int width = Math.round((container.getBackgroundWidth() - Math.max(size - 1, 1) * 2) / Math.max(size, 2));
        if (index == 1 && size == 3) {
            return width + 1;
        }
        return width;
    }

    private static int offset(Container container, int index, int size) {
        return (int)Math.round((double)index * (double)(container.getBackgroundWidth() + 2) / (double)size);
    }
}

