/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.gui.content.impl;

import exopandora.worldhandler.builder.ICommandBuilder;
import exopandora.worldhandler.builder.impl.BuilderAdvancement;
import exopandora.worldhandler.gui.category.Categories;
import exopandora.worldhandler.gui.category.Category;
import exopandora.worldhandler.gui.container.Container;
import exopandora.worldhandler.gui.content.Content;
import exopandora.worldhandler.gui.content.Contents;
import exopandora.worldhandler.gui.menu.impl.ILogicMapped;
import exopandora.worldhandler.gui.menu.impl.ILogicPageList;
import exopandora.worldhandler.gui.menu.impl.MenuPageList;
import exopandora.worldhandler.gui.widget.button.GuiButtonBase;
import exopandora.worldhandler.gui.widget.button.GuiButtonList;
import exopandora.worldhandler.gui.widget.button.GuiButtonTooltip;
import exopandora.worldhandler.util.ActionHandler;
import exopandora.worldhandler.util.ActionHelper;
import exopandora.worldhandler.util.AdvancementHelper;
import exopandora.worldhandler.util.CommandHelper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContentAdvancements
extends Content {
    private final BuilderAdvancement builderAdvancement = new BuilderAdvancement(BuilderAdvancement.EnumMode.values()[0]);
    private final List<BuilderAdvancement.EnumMode> modes = Arrays.stream(BuilderAdvancement.EnumMode.values()).filter(mode -> !mode.equals((Object)BuilderAdvancement.EnumMode.EVERYTHING)).collect(Collectors.toList());

    @Override
    public ICommandBuilder getCommandBuilder() {
        return this.builderAdvancement;
    }

    @Override
    public void initGui(final Container container, int x, int y) {
        List advancements = AdvancementHelper.getInstance().getAdvancements().stream().filter(advancement -> advancement.func_192068_c() != null).collect(Collectors.toList());
        MenuPageList<Advancement> list = new MenuPageList<Advancement>(x, y, advancements, 114, 20, 3, container, new ILogicPageList<Advancement>(){

            @Override
            public IFormattableTextComponent translate(Advancement item) {
                return (IFormattableTextComponent)item.func_192068_c().func_192297_a();
            }

            @Override
            public IFormattableTextComponent toTooltip(Advancement item) {
                return new StringTextComponent(item.func_192067_g().toString());
            }

            @Override
            public void onClick(Advancement item) {
                ContentAdvancements.this.builderAdvancement.setAdvancement(item.func_192067_g());
                container.initButtons();
            }

            @Override
            public GuiButtonBase onRegister(int x, int y, int width, int height, IFormattableTextComponent text, Advancement item, ActionHandler actionHandler) {
                return new GuiButtonTooltip(x, y, width, height, (ITextComponent)text, (ITextComponent)this.toTooltip(item), actionHandler);
            }

            @Override
            public String getId() {
                return "advancement";
            }
        });
        container.add(list);
    }

    @Override
    public void initButtons(Container container, int x, int y) {
        container.add(new GuiButtonBase(x, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.back"), () -> ActionHelper.back(this)));
        container.add(new GuiButtonBase(x + 118, y + 96, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.generic.backToGame"), ActionHelper::backToGame));
        container.add(new GuiButtonList<BuilderAdvancement.EnumMode>(x + 118, y, this.modes, 114, 20, container, new ILogicMapped<BuilderAdvancement.EnumMode>(){

            @Override
            public IFormattableTextComponent translate(BuilderAdvancement.EnumMode item) {
                return new TranslationTextComponent("gui.worldhandler.advancements." + item.toString());
            }

            @Override
            public IFormattableTextComponent toTooltip(BuilderAdvancement.EnumMode item) {
                return new StringTextComponent(item.toString());
            }

            @Override
            public void onClick(BuilderAdvancement.EnumMode item) {
                ContentAdvancements.this.builderAdvancement.setMode(item);
            }

            @Override
            public String getId() {
                return "mode";
            }
        }));
        container.add(new GuiButtonBase(x + 118, y + 24, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.advancements.grant"), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderAdvancement.build(BuilderAdvancement.EnumActionType.GRANT))));
        container.add(new GuiButtonBase(x + 118, y + 48, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.advancements.revoke"), () -> CommandHelper.sendCommand(container.getPlayer(), this.builderAdvancement.build(BuilderAdvancement.EnumActionType.REVOKE))));
        container.add(new GuiButtonBase(x + 118, y + 72, 114, 20, (ITextComponent)new TranslationTextComponent("gui.worldhandler.actions.reset").func_240699_a_(TextFormatting.RED), () -> ActionHelper.open(Contents.CONTINUE.withBuilder(this.builderAdvancement.build(BuilderAdvancement.EnumActionType.REVOKE, BuilderAdvancement.EnumMode.EVERYTHING)))));
    }

    @Override
    public Category getCategory() {
        return Categories.PLAYER;
    }

    @Override
    public IFormattableTextComponent getTitle() {
        return new TranslationTextComponent("gui.worldhandler.title.player.advancements");
    }

    @Override
    public IFormattableTextComponent getTabTitle() {
        return new TranslationTextComponent("gui.worldhandler.tab.player.advancements");
    }

    @Override
    public Content getActiveContent() {
        return Contents.ADVANCEMENTS;
    }

    @Override
    public void onPlayerNameChanged(String username) {
        this.builderAdvancement.setPlayer(username);
    }
}

