/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.types;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import exopandora.worldhandler.builder.types.ItemResourceLocation;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class BlockResourceLocation
extends ItemResourceLocation {
    private BlockState state;

    public BlockResourceLocation() {
        this(null);
    }

    public BlockResourceLocation(ResourceLocation resource) {
        this(resource, null, null);
    }

    public BlockResourceLocation(ResourceLocation resource, BlockState state, CompoundNBT nbt) {
        super(resource, nbt);
        this.state = this.findState(state, resource);
    }

    private BlockState findState(BlockState state, ResourceLocation resource) {
        boolean matchNew;
        boolean matchOld = this.state != null && this.state.func_177230_c().getRegistryName().equals((Object)resource);
        boolean bl = matchNew = state != null && state.func_177230_c().getRegistryName().equals((Object)resource);
        if (matchNew) {
            return state;
        }
        if (matchOld) {
            return this.state;
        }
        if (resource != null && ForgeRegistries.BLOCKS.containsKey(resource)) {
            return ((Block)ForgeRegistries.BLOCKS.getValue(resource)).func_176223_P();
        }
        return null;
    }

    @Override
    public void setResourceLocation(ResourceLocation resource) {
        super.setResourceLocation(resource);
        this.state = this.findState(null, resource);
    }

    @Nullable
    public BlockState getState() {
        return this.state;
    }

    public <T extends Comparable<T>> void setProperty(Property<T> property, T value) {
        if (this.state != null && this.state.func_235901_b_(property)) {
            this.state = (BlockState)this.state.func_206870_a(property, value);
        }
    }

    @Nullable
    public static BlockResourceLocation valueOf(String input) {
        if (input != null) {
            BlockStateParser parser = new BlockStateParser(new StringReader(input), false);
            try {
                parser.func_197243_a(true);
            }
            catch (CommandSyntaxException e) {
                return null;
            }
            BlockState state = parser.func_197249_b();
            if (state != null) {
                return new BlockResourceLocation(state.func_177230_c().getRegistryName(), state, parser.func_197241_c());
            }
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.resource != null && this.state != null) {
            StringBuilder builder = new StringBuilder(this.state.toString());
            String block = this.state.func_177230_c().toString();
            builder.replace(0, block.length(), this.resource.toString());
            if (this.nbt != null) {
                builder.append(this.nbt.toString());
            }
            return builder.toString();
        }
        return null;
    }
}

