/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.builder.impl;

import exopandora.worldhandler.builder.CommandBuilder;
import exopandora.worldhandler.builder.CommandSyntax;
import exopandora.worldhandler.builder.types.ArgumentType;
import exopandora.worldhandler.builder.types.TargetSelector;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BuilderButcher
extends CommandBuilder {
    private final TargetSelector targetSelector = new TargetSelector();

    public BuilderButcher() {
        this("<entity_name>", 0);
    }

    public BuilderButcher(ResourceLocation entity, int distance) {
        this(entity.toString(), distance);
    }

    private BuilderButcher(String entity, int distance) {
        this.setEntity(entity);
        this.setDistance(distance);
    }

    public void setDistance(int distance) {
        this.targetSelector.set("distance", "0.." + distance);
        this.setNode(0, this.targetSelector);
    }

    public int getDistance() {
        return Integer.parseInt(((String)this.targetSelector.get("distance")).substring(3));
    }

    private void setEntity(String entity) {
        if (entity != null) {
            this.targetSelector.set("type", entity);
        }
        this.setNode(0, this.targetSelector);
    }

    public void setEntity(ResourceLocation entity) {
        this.setEntity(entity.toString());
    }

    @Nonnull
    public ResourceLocation getEntity() {
        return (ResourceLocation)this.targetSelector.get("type");
    }

    @Override
    public String getCommandName() {
        return "kill";
    }

    @Override
    public CommandSyntax getSyntax() {
        CommandSyntax syntax = new CommandSyntax();
        syntax.addRequired("entity_name", ArgumentType.TARGET_SELECTOR);
        return syntax;
    }
}

