/*
 * Decompiled with CFR 0.152.
 */
package exopandora.worldhandler.util;

import com.google.common.base.Predicates;
import exopandora.worldhandler.util.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@OnlyIn(value=Dist.CLIENT)
public class ScoreboardHelper {
    private final Node objectives = new Node();
    private final Node slots = new Node();
    private final Node options = new Node();

    public ScoreboardHelper() {
        this.init();
    }

    private void init() {
        List<Node> colors = this.createList(TextFormatting.values(), TextFormatting::func_96297_d, TextFormatting::func_96302_c);
        List<Node> visibility = this.createList(Team.Visible.values(), value -> value.field_178830_e);
        List<Node> collision = this.createList(Team.CollisionRule.values(), value -> value.field_186693_e);
        List<Node> bool = this.createList(new Boolean[]{true, false}, String::valueOf);
        for (String scoreCriteria : ScoreCriteria.field_96643_a.keySet()) {
            this.objectives.insertNode(scoreCriteria.split("[.:]"));
        }
        this.objectives.merge("minecraft", (parent, child) -> parent + "." + child);
        for (StatType type : ForgeRegistries.STAT_TYPES) {
            if (type.equals(Stats.field_199092_j)) continue;
            ArrayList<Node> entries = new ArrayList<Node>();
            for (ResourceLocation key : type.func_199080_a().func_148742_b()) {
                entries.add(new Node(this.buildKey(key)));
            }
            this.objectives.addNode(this.buildKey(ForgeRegistries.STAT_TYPES.getKey((IForgeRegistryEntry)type)), entries);
        }
        this.objectives.sort();
        this.slots.addNode("belowName");
        this.slots.addNode("list");
        this.slots.addNode("sidebar");
        this.slots.addNode("sidebar.team", colors);
        this.slots.sort();
        this.options.addNode("color", colors);
        this.options.addNode("nametagVisibility", visibility);
        this.options.addNode("deathMessageVisibility", visibility);
        this.options.addNode("friendlyFire", bool);
        this.options.addNode("seeFriendlyInvisibles", bool);
        this.options.addNode("collisionRule", collision);
        this.options.sort();
    }

    private String buildKey(ResourceLocation key) {
        return key.toString().replace(":", ".");
    }

    private <T> List<Node> createList(T[] array, Function<T, String> mapper) {
        return this.createList(array, mapper, (Predicate<T>)Predicates.alwaysTrue());
    }

    private <T> List<Node> createList(T[] array, Function<T, String> mapper, Predicate<T> predicate) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (T index : array) {
            if (!predicate.test(index)) continue;
            list.add(new Node(mapper.apply(index)));
        }
        return list;
    }

    public List<Node> getObjectives() {
        if (this.objectives != null) {
            return this.objectives.getEntries();
        }
        return null;
    }

    public List<Node> getSlots() {
        if (this.slots != null) {
            return this.slots.getEntries();
        }
        return null;
    }

    public List<Node> getOptions() {
        if (this.options != null) {
            return this.options.getEntries();
        }
        return null;
    }
}

