/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.init;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import quphoria.compactvoidminers.init.ModBlocks;
import quphoria.compactvoidminers.init.Registration;
import quphoria.compactvoidminers.items.FilterItem;

@Mod.EventBusSubscriber(modid="compactvoidminers", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModItems {
    public static final String[] filter_prefixes = new String[]{"storage_block", "seed", "plastic", "plate", "dye", "gem", "nugget", "ore", "ingot", "glass", "misc", "rod", "logs", "crop", "dust", "stone"};
    public static final ItemGroup tabCompactVoidMiners = new ItemGroup("tabCompactVoidMiners"){
        private ItemSorter itemSorter = new ItemSorter();

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModBlocks.voidMinerBlock.get());
        }

        public void func_78018_a(NonNullList<ItemStack> items) {
            super.func_78018_a(items);
            Collections.sort(items, this.itemSorter);
        }

        class ItemSorter
        implements Comparator<ItemStack> {
            ItemSorter() {
            }

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                Item item1 = o1.func_77973_b();
                Item item2 = o2.func_77973_b();
                if (item1 instanceof BlockItem && !(item2 instanceof BlockItem)) {
                    return -1;
                }
                if (item2 instanceof BlockItem && !(item1 instanceof BlockItem)) {
                    return 1;
                }
                if (item1 instanceof Item && !(item2 instanceof Item)) {
                    return -1;
                }
                if (item2 instanceof Item && !(item1 instanceof Item)) {
                    return 1;
                }
                if (item1 instanceof FilterItem && item2 instanceof FilterItem) {
                    return ((FilterItem)item1).getPrefixIndex(o1) < ((FilterItem)item2).getPrefixIndex(o2) ? -1 : 1;
                }
                String displayName1 = o1.func_151000_E().getString();
                String displayName2 = o2.func_151000_E().getString();
                int result = displayName1.compareToIgnoreCase(displayName2);
                return result;
            }
        }
    };
    public static final RegistryObject<Item> blank_filter = Registration.ITEMS.register("blank_filter", () -> new Item(new Item.Properties().func_200917_a(8).func_200916_a(tabCompactVoidMiners)));
    public static List<RegistryObject<Item>> tag_filters = new ArrayList<RegistryObject<Item>>();

    public static void register() {
        int i = 0;
        for (String prefix : filter_prefixes) {
            int id = i++;
            tag_filters.add((RegistryObject<Item>)Registration.ITEMS.register("tag_filter_" + prefix, () -> new FilterItem(new Item.Properties().func_200917_a(8).func_200916_a(tabCompactVoidMiners), id)));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerItemColors(ColorHandlerEvent.Item event) {
        IItemColor item_filter_color = new IItemColor(){

            public int getColor(ItemStack stack, int tintIndex) {
                if (tintIndex > 0) {
                    return -1;
                }
                return ((FilterItem)stack.func_77973_b()).getColor(stack);
            }
        };
        for (RegistryObject<Item> tag_filter : tag_filters) {
            event.getItemColors().func_199877_a(item_filter_color, new IItemProvider[]{(IItemProvider)tag_filter.get()});
        }
    }
}

