/*
 * Decompiled with CFR 0.152.
 */
package quphoria.compactvoidminers.energy;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.energy.EnergyStorage;

public class MachineEnergyStorage
extends EnergyStorage {
    public MachineEnergyStorage(int capacity, int maxReceive, int energy) {
        super(capacity, maxReceive, 0, energy);
        this.maxReceive = maxReceive;
    }

    public int getMaxEnergyReceive() {
        return this.maxReceive;
    }

    public int extractInternalEnergy(int maxExtract, boolean simulate) {
        if (this.capacity <= 0) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public double getEnergyFraction() {
        if (this.energy == 0 || this.capacity == 0) {
            return 0.0;
        }
        return Math.min(Math.max((double)this.energy / (double)this.capacity, 0.0), 1.0);
    }

    public void save(PacketBuffer buf) {
        buf.writeInt(this.energy);
    }

    public void load(PacketBuffer buf) {
        this.energy = buf.readInt();
    }

    public CompoundNBT save(CompoundNBT compound) {
        compound.func_74768_a("energyLevel", this.energy);
        return compound;
    }

    public void load(CompoundNBT compound) {
        this.energy = compound.func_74762_e("energyLevel");
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        this.energy = Math.min(this.energy, capacity);
    }
}

