/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.entity;

import de.maxhenkel.easyvillagers.Main;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class EasyVillagerEntity
extends VillagerEntity {
    public EasyVillagerEntity(EntityType<? extends VillagerEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public EasyVillagerEntity(EntityType<? extends VillagerEntity> type, World worldIn, VillagerType villagerType) {
        super(type, worldIn, villagerType);
    }

    public int func_223107_f(PlayerEntity player) {
        if (((Boolean)Main.SERVER_CONFIG.universalReputation.get()).booleanValue()) {
            return EasyVillagerEntity.getUniversalReputation(this);
        }
        return super.func_223107_f(player);
    }

    public static int getReputation(VillagerEntity villager) {
        if (((Boolean)Main.SERVER_CONFIG.universalReputation.get()).booleanValue()) {
            return EasyVillagerEntity.getUniversalReputation(villager);
        }
        return 0;
    }

    public static int getUniversalReputation(VillagerEntity villager) {
        return villager.func_223722_es().field_220928_a.keySet().stream().map(uuid -> villager.func_223722_es().func_220921_a(uuid, gossipType -> true)).reduce(0, Integer::sum);
    }

    public void recalculateOffers() {
        EasyVillagerEntity.resetOffers(this);
        EasyVillagerEntity.calculateOffers(this);
    }

    public int func_70874_b() {
        if (this.field_70170_p.field_72995_K) {
            return super.func_70874_b() < 0 ? -24000 : 1;
        }
        return this.field_175504_a;
    }

    public static void recalculateOffers(VillagerEntity villager) {
        EasyVillagerEntity.resetOffers(villager);
        EasyVillagerEntity.calculateOffers(villager);
    }

    private static void resetOffers(VillagerEntity villager) {
        for (MerchantOffer merchantoffer : villager.func_213706_dY()) {
            merchantoffer.func_222220_k();
        }
    }

    private static void calculateOffers(VillagerEntity villager) {
        int i = EasyVillagerEntity.getReputation(villager);
        if (i != 0) {
            for (MerchantOffer merchantoffer : villager.func_213706_dY()) {
                merchantoffer.func_222207_a(-MathHelper.func_76141_d((float)((float)i * merchantoffer.func_222211_m())));
            }
        }
    }

    public ITextComponent getAdvancedName() {
        VillagerData villagerData = this.func_213700_eh();
        VillagerProfession profession = villagerData.func_221130_b();
        if (profession.equals(VillagerProfession.field_221151_a) || profession.equals(VillagerProfession.field_221162_l)) {
            return this.func_200200_C_().func_230532_e_().func_240699_a_(TextFormatting.GRAY);
        }
        return new TranslationTextComponent("tooltip.easy_villagers.villager_profession", new Object[]{this.func_200200_C_().func_230532_e_(), new TranslationTextComponent("merchant.level." + villagerData.func_221132_c())}).func_240699_a_(TextFormatting.GRAY);
    }
}

