/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.elementary;

import com.jozufozu.flywheel.util.VirtualEmptyModelData;
import com.simibubi.create.content.contraptions.relays.elementary.BracketedTileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class BracketedKineticBlockModel
extends BakedModelWrapper<IBakedModel> {
    private static final ModelProperty<BracketedModelData> BRACKET_PROPERTY = new ModelProperty();

    public BracketedKineticBlockModel(IBakedModel template) {
        super(template);
    }

    public IModelData getModelData(IBlockDisplayReader world, BlockPos pos, BlockState state, IModelData tileData) {
        if (tileData == VirtualEmptyModelData.INSTANCE) {
            return tileData;
        }
        BracketedModelData data = new BracketedModelData();
        BracketedTileEntityBehaviour attachmentBehaviour = TileEntityBehaviour.get((IBlockReader)world, pos, BracketedTileEntityBehaviour.TYPE);
        if (attachmentBehaviour != null) {
            data.putBracket(attachmentBehaviour.getBracket());
        }
        return new ModelDataMap.Builder().withInitial(BRACKET_PROPERTY, (Object)data).build();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData data) {
        if (data instanceof ModelDataMap) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            ModelDataMap modelDataMap = (ModelDataMap)data;
            if (modelDataMap.hasProperty(BRACKET_PROPERTY)) {
                quads = new ArrayList<BakedQuad>(quads);
                this.addQuads(quads, state, side, rand, (IModelData)modelDataMap, (BracketedModelData)modelDataMap.getData(BRACKET_PROPERTY));
            }
            return quads;
        }
        return super.getQuads(state, side, rand, data);
    }

    private void addQuads(List<BakedQuad> quads, BlockState state, Direction side, Random rand, IModelData data, BracketedModelData pipeData) {
        IBakedModel bracket = pipeData.getBracket();
        if (bracket == null) {
            return;
        }
        quads.addAll(bracket.getQuads(state, side, rand, data));
    }

    private class BracketedModelData {
        IBakedModel bracket;

        private BracketedModelData() {
        }

        public void putBracket(BlockState state) {
            this.bracket = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        }

        public IBakedModel getBracket() {
            return this.bracket;
        }
    }
}

