/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.networking.IGridNode;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IPart;
import appeng.api.parts.LayerFlags;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.helpers.AEMultiTile;
import appeng.hooks.ticking.TickHandler;
import appeng.parts.CableBusContainer;
import appeng.tile.AEBaseTileEntity;
import appeng.util.Platform;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class CableBusTileEntity
extends AEBaseTileEntity
implements AEMultiTile {
    private CableBusContainer cb = new CableBusContainer(this);
    private int oldLV = -1;

    public CableBusTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT data) {
        super.func_230337_a_(blockState, data);
        this.getCableBus().readFromNBT(data);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        this.getCableBus().writeToNBT(data);
        return data;
    }

    @Override
    protected boolean readFromStream(PacketBuffer data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean ret = this.getCableBus().readFromStream(data);
        int newLV = this.getCableBus().getLightValue();
        if (newLV != this.oldLV) {
            this.oldLV = newLV;
            this.field_145850_b.func_225524_e_().func_215568_a(this.field_174879_c);
            ret = true;
        }
        this.updateTileSetting();
        return ret || c;
    }

    @Override
    protected void writeToStream(PacketBuffer data) throws IOException {
        super.writeToStream(data);
        this.getCableBus().writeToStream(data);
    }

    protected void updateTileSetting() {
    }

    public double func_145833_n() {
        return 900.0;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.getCableBus().removeFromWorld();
    }

    public void func_145829_t() {
        super.func_145829_t();
        TickHandler.instance().addInit(this);
    }

    @Override
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getCableBus().getGridNode(dir);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation side) {
        return this.getCableBus().getCableConnectionType(side);
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return this.getCableBus().getCableConnectionLength(cable);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.getCableBus().removeFromWorld();
    }

    @Override
    public void markForUpdate() {
        if (this.field_145850_b == null) {
            return;
        }
        int newLV = this.getCableBus().getLightValue();
        if (newLV != this.oldLV) {
            this.oldLV = newLV;
            this.field_145850_b.func_225524_e_().func_215568_a(this.field_174879_c);
        }
        super.markForUpdate();
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    public void getDrops(World w, BlockPos pos, List drops) {
        this.getCableBus().getDrops(drops);
    }

    @Override
    public void getNoDrops(World w, BlockPos pos, List<ItemStack> drops) {
        this.getCableBus().getNoDrops(drops);
    }

    @Override
    public void onReady() {
        super.onReady();
        if (this.getCableBus().isEmpty()) {
            if (this.field_145850_b.func_175625_s(this.field_174879_c) == this) {
                this.field_145850_b.func_175655_b(this.field_174879_c, true);
            }
        } else {
            this.getCableBus().addToWorld();
        }
    }

    @Override
    public IFacadeContainer getFacadeContainer() {
        return this.getCableBus().getFacadeContainer();
    }

    @Override
    public boolean canAddPart(ItemStack is, AEPartLocation side) {
        return this.getCableBus().canAddPart(is, side);
    }

    @Override
    public AEPartLocation addPart(ItemStack is, AEPartLocation side, PlayerEntity player, Hand hand) {
        return this.getCableBus().addPart(is, side, player, hand);
    }

    @Override
    public IPart getPart(AEPartLocation side) {
        return this.cb.getPart(side);
    }

    @Override
    public IPart getPart(Direction side) {
        return this.getCableBus().getPart(side);
    }

    @Override
    public void removePart(AEPartLocation side, boolean suppressUpdate) {
        this.getCableBus().removePart(side, suppressUpdate);
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public AEColor getColor() {
        return this.getCableBus().getColor();
    }

    @Override
    public void clearContainer() {
        this.setCableBus(new CableBusContainer(this));
    }

    @Override
    public boolean isBlocked(Direction side) {
        return false;
    }

    @Override
    public SelectedPart selectPart(Vector3d pos) {
        return this.getCableBus().selectPart(pos);
    }

    @Override
    public void markForSave() {
        this.saveChanges();
    }

    @Override
    public void partChanged() {
        this.notifyNeighbors();
    }

    @Override
    public boolean hasRedstone(AEPartLocation side) {
        return this.getCableBus().hasRedstone(side);
    }

    @Override
    public boolean isEmpty() {
        return this.getCableBus().isEmpty();
    }

    @Override
    public Set<LayerFlags> getLayerFlags() {
        return this.getCableBus().getLayerFlags();
    }

    @Override
    public void cleanup() {
        this.func_145831_w().func_217377_a(this.field_174879_c, false);
    }

    @Override
    public void notifyNeighbors() {
        if (this.field_145850_b != null && this.field_145850_b.func_175667_e(this.field_174879_c) && !CableBusContainer.isLoading()) {
            Platform.notifyBlocksOfNeighbors(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public boolean isInWorld() {
        return this.getCableBus().isInWorld();
    }

    @Override
    public boolean recolourBlock(Direction side, AEColor colour, PlayerEntity who) {
        return this.getCableBus().recolourBlock(side, colour, who);
    }

    public CableBusContainer getCableBus() {
        return this.cb;
    }

    private void setCableBus(CableBusContainer cb) {
        this.cb = cb;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capabilityClass, @Nullable Direction fromSide) {
        LazyOptional<T> result;
        AEPartLocation partLocation = AEPartLocation.fromFacing(fromSide);
        IPart part = this.getPart(partLocation);
        LazyOptional<T> lazyOptional = result = part == null ? LazyOptional.empty() : part.getCapability(capabilityClass);
        if (result.isPresent()) {
            return result;
        }
        return super.getCapability(capabilityClass, fromSide);
    }

    @Override
    @Nonnull
    public IModelData getModelData() {
        World world = this.func_145831_w();
        if (world == null) {
            return EmptyModelData.INSTANCE;
        }
        CableBusRenderState renderState = this.cb.getRenderState();
        renderState.setWorld((IBlockDisplayReader)world);
        renderState.setPos(this.field_174879_c);
        return new ModelDataMap.Builder().withInitial(CableBusRenderState.PROPERTY, (Object)renderState).build();
    }
}

