/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.core.AELog;
import appeng.spatial.SpatialStoragePlot;
import appeng.spatial.TransitionInfo;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.WorldSavedData;

public class SpatialStorageWorldData
extends WorldSavedData {
    public static final String ID = "ae2_spatial_storage";
    private static final int CURRENT_FORMAT = 2;
    private static final String TAG_FORMAT = "format";
    private static final String TAG_PLOTS = "plots";
    private final Int2ObjectOpenHashMap<SpatialStoragePlot> plots = new Int2ObjectOpenHashMap();

    public SpatialStorageWorldData() {
        super(ID);
    }

    public SpatialStoragePlot getPlotById(int id) {
        return (SpatialStoragePlot)this.plots.get(id);
    }

    public List<SpatialStoragePlot> getPlots() {
        return ImmutableList.copyOf((Collection)this.plots.values());
    }

    public SpatialStoragePlot allocatePlot(BlockPos size, int owner) {
        int nextId = 1;
        IntIterator intIterator = this.plots.keySet().iterator();
        while (intIterator.hasNext()) {
            int id = (Integer)intIterator.next();
            if (id < nextId) continue;
            nextId = id + 1;
        }
        SpatialStoragePlot plot = new SpatialStoragePlot(nextId, size, owner);
        this.plots.put(nextId, (Object)plot);
        this.func_76185_a();
        return plot;
    }

    public void removePlot(int plotId) {
        this.plots.remove(plotId);
        this.func_76185_a();
    }

    public void setLastTransition(int plotId, TransitionInfo info) {
        SpatialStoragePlot plot = (SpatialStoragePlot)this.plots.get(plotId);
        if (plot != null) {
            plot.setLastTransition(info);
        }
        this.func_76185_a();
    }

    public void func_76184_a(CompoundNBT tag) {
        int version = tag.func_74762_e(TAG_FORMAT);
        if (version != 2) {
            throw new IllegalStateException("Invalid AE2 spatial info version: " + version);
        }
        ListNBT plotsTag = tag.func_150295_c(TAG_PLOTS, 10);
        for (INBT plotTag : plotsTag) {
            SpatialStoragePlot plot = SpatialStoragePlot.fromTag((CompoundNBT)plotTag);
            if (this.plots.containsKey(plot.getId())) {
                AELog.warn("Overwriting duplicate plot id %s", plot.getId());
            }
            this.plots.put(plot.getId(), (Object)plot);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT tag) {
        tag.func_74768_a(TAG_FORMAT, 2);
        ListNBT plotTags = new ListNBT();
        for (SpatialStoragePlot plot : this.plots.values()) {
            plotTags.add((Object)plot.toTag());
        }
        tag.func_218657_a(TAG_PLOTS, (INBT)plotTags);
        return tag;
    }
}

