/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.me.items;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.crafting.ICraftingHelper;
import appeng.api.definitions.IDefinitions;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerNull;
import appeng.container.SlotSemantic;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerTypeBuilder;
import appeng.container.me.items.ItemTerminalContainer;
import appeng.container.slot.FakeCraftingMatrixSlot;
import appeng.container.slot.FakeSlot;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalFakeSlot;
import appeng.container.slot.PatternOutputsSlot;
import appeng.container.slot.PatternTermSlot;
import appeng.container.slot.RestrictedInputSlot;
import appeng.core.Api;
import appeng.core.sync.packets.PatternSlotPacket;
import appeng.helpers.IContainerCraftingPacket;
import appeng.items.storage.ViewCellItem;
import appeng.me.helpers.MachineSource;
import appeng.parts.reporting.PatternTerminalPart;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.WrapperCursorItemHandler;
import appeng.util.item.AEItemStack;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public class PatternTermContainer
extends ItemTerminalContainer
implements IOptionalSlotHost,
IContainerCraftingPacket {
    public static ContainerType<PatternTermContainer> TYPE = ContainerTypeBuilder.create(PatternTermContainer::new, ITerminalHost.class).requirePermission(SecurityPermissions.CRAFT).build("patternterm");
    private final PatternTerminalPart patternTerminal;
    private final IItemHandler craftingGridInv;
    private final FakeCraftingMatrixSlot[] craftingGridSlots = new FakeCraftingMatrixSlot[9];
    private final OptionalFakeSlot[] processingOutputSlots = new OptionalFakeSlot[3];
    private final PatternTermSlot craftOutputSlot;
    private final RestrictedInputSlot blankPatternSlot;
    private final RestrictedInputSlot encodedPatternSlot;
    private final ICraftingHelper craftingHelper = Api.INSTANCE.crafting();
    private ICraftingRecipe currentRecipe;
    private boolean currentRecipeCraftingMode;
    @GuiSync(value=97)
    public boolean craftingMode = true;
    @GuiSync(value=96)
    public boolean substitute = false;

    public PatternTermContainer(int id, PlayerInventory ip, ITerminalHost monitorable) {
        super(TYPE, id, ip, monitorable, false);
        int i;
        this.patternTerminal = (PatternTerminalPart)monitorable;
        IItemHandler patternInv = this.getPatternTerminal().getInventoryByName("pattern");
        IItemHandler output = this.getPatternTerminal().getInventoryByName("output");
        this.craftingGridInv = this.getPatternTerminal().getInventoryByName("crafting");
        for (i = 0; i < 9; ++i) {
            this.craftingGridSlots[i] = new FakeCraftingMatrixSlot(this.craftingGridInv, i);
            this.addSlot(this.craftingGridSlots[i], SlotSemantic.CRAFTING_GRID);
        }
        this.craftOutputSlot = new PatternTermSlot(ip.field_70458_d, this.getActionSource(), this.powerSource, monitorable, this.craftingGridInv, patternInv, this, 2, this);
        this.addSlot(this.craftOutputSlot, SlotSemantic.CRAFTING_RESULT);
        this.craftOutputSlot.setIcon(null);
        for (i = 0; i < 3; ++i) {
            this.processingOutputSlots[i] = new PatternOutputsSlot(output, this, i, 1);
            this.addSlot(this.processingOutputSlots[i], SlotSemantic.PROCESSING_RESULT);
            this.processingOutputSlots[i].setRenderDisabled(false);
            this.processingOutputSlots[i].setIcon(null);
        }
        this.blankPatternSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BLANK_PATTERN, patternInv, 0);
        this.addSlot(this.blankPatternSlot, SlotSemantic.BLANK_PATTERN);
        this.encodedPatternSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, patternInv, 1);
        this.addSlot(this.encodedPatternSlot, SlotSemantic.ENCODED_PATTERN);
        this.encodedPatternSlot.setStackLimit(1);
        this.createPlayerInventorySlots(ip);
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        super.func_75141_a(slotID, stack);
        this.getAndUpdateOutput();
    }

    private ItemStack getAndUpdateOutput() {
        World world = this.getPlayerInventory().field_70458_d.field_70170_p;
        CraftingInventory ic = new CraftingInventory((Container)this, 3, 3);
        for (int x = 0; x < ic.func_70302_i_(); ++x) {
            ic.func_70299_a(x, this.craftingGridInv.getStackInSlot(x));
        }
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a((IInventory)ic, world)) {
            this.currentRecipe = world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)ic, world).orElse(null);
            this.currentRecipeCraftingMode = this.craftingMode;
        }
        ItemStack is = this.currentRecipe == null ? ItemStack.field_190927_a : this.currentRecipe.func_77572_b((IInventory)ic);
        this.craftOutputSlot.setDisplayedCraftingOutput(is);
        return is;
    }

    public void encode() {
        ItemStack output = this.encodedPatternSlot.func_75211_c();
        ItemStack[] in = this.getInputs();
        ItemStack[] out = this.getOutputs();
        if (in == null || out == null || this.isCraftingMode() && this.currentRecipe == null) {
            return;
        }
        if (!output.func_190926_b() && !this.craftingHelper.isEncodedPattern(output)) {
            return;
        }
        if (output.func_190926_b()) {
            output = this.blankPatternSlot.func_75211_c();
            if (output.func_190926_b() || !this.isPattern(output)) {
                return;
            }
            output.func_190920_e(output.func_190916_E() - 1);
            if (output.func_190916_E() == 0) {
                this.blankPatternSlot.func_75215_d(ItemStack.field_190927_a);
            }
            output = null;
        }
        output = this.isCraftingMode() ? this.craftingHelper.encodeCraftingPattern(output, this.currentRecipe, in, out[0], this.isSubstitute()) : this.craftingHelper.encodeProcessingPattern(output, in, out);
        this.encodedPatternSlot.func_75215_d(output);
    }

    private ItemStack[] getInputs() {
        ItemStack[] input = new ItemStack[9];
        boolean hasValue = false;
        for (int x = 0; x < this.craftingGridSlots.length; ++x) {
            input[x] = this.craftingGridSlots[x].func_75211_c();
            if (input[x].func_190926_b()) continue;
            hasValue = true;
        }
        if (hasValue) {
            return input;
        }
        return null;
    }

    private ItemStack[] getOutputs() {
        if (this.isCraftingMode()) {
            ItemStack out = this.getAndUpdateOutput();
            if (!out.func_190926_b() && out.func_190916_E() > 0) {
                return new ItemStack[]{out};
            }
        } else {
            boolean hasValue = false;
            ItemStack[] list = new ItemStack[3];
            for (int i = 0; i < this.processingOutputSlots.length; ++i) {
                ItemStack out;
                list[i] = out = this.processingOutputSlots[i].func_75211_c();
                if (out.func_190926_b()) continue;
                hasValue = true;
            }
            if (hasValue) {
                return list;
            }
        }
        return null;
    }

    private boolean isPattern(ItemStack output) {
        if (output.func_190926_b()) {
            return false;
        }
        IDefinitions definitions = Api.instance().definitions();
        return definitions.materials().blankPattern().isSameAs(output);
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        if (idx == 1) {
            return this.isServer() ? !this.getPatternTerminal().isCraftingRecipe() : !this.isCraftingMode();
        }
        if (idx == 2) {
            return this.isServer() ? this.getPatternTerminal().isCraftingRecipe() : this.isCraftingMode();
        }
        return false;
    }

    public void craftOrGetItem(PatternSlotPacket packetPatternSlot) {
        if (packetPatternSlot.slotItem != null && this.monitor != null) {
            IAEItemStack out = packetPatternSlot.slotItem.copy();
            InventoryAdaptor inv = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(this.getPlayerInventory().field_70458_d.field_71071_by));
            InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor(this.getPlayerInventory().field_70458_d);
            if (packetPatternSlot.shift) {
                inv = playerInv;
            }
            if (!inv.simulateAdd(out.createItemStack()).func_190926_b()) {
                return;
            }
            IAEItemStack extracted = Platform.poweredExtraction(this.powerSource, this.monitor, out, this.getActionSource());
            PlayerEntity p = this.getPlayerInventory().field_70458_d;
            if (extracted != null) {
                inv.addItems(extracted.createItemStack());
                if (p instanceof ServerPlayerEntity) {
                    this.updateHeld((ServerPlayerEntity)p);
                }
                this.func_75142_b();
                return;
            }
            CraftingInventory ic = new CraftingInventory((Container)new ContainerNull(), 3, 3);
            CraftingInventory real = new CraftingInventory((Container)new ContainerNull(), 3, 3);
            for (int x = 0; x < 9; ++x) {
                ic.func_70299_a(x, packetPatternSlot.pattern[x] == null ? ItemStack.field_190927_a : packetPatternSlot.pattern[x].createItemStack());
            }
            IRecipe r = p.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)ic, p.field_70170_p).orElse(null);
            if (r == null) {
                return;
            }
            IMEMonitor<IAEItemStack> storage = this.getPatternTerminal().getInventory(Api.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IItemList<IAEItemStack> all = storage.getStorageList();
            ItemStack is = r.func_77572_b((IInventory)ic);
            for (int x = 0; x < ic.func_70302_i_(); ++x) {
                if (ic.func_70301_a(x).func_190926_b()) continue;
                ItemStack pulled = Platform.extractItemsByRecipe(this.powerSource, this.getActionSource(), storage, p.field_70170_p, (IRecipe<CraftingInventory>)r, is, ic, ic.func_70301_a(x), x, all, Actionable.MODULATE, ViewCellItem.createFilter(this.getViewCells()));
                real.func_70299_a(x, pulled);
            }
            IRecipe rr = p.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)real, p.field_70170_p).orElse(null);
            if (rr == r && Platform.itemComparisons().isSameItem(rr.func_77572_b((IInventory)real), is)) {
                CraftResultInventory craftingResult = new CraftResultInventory();
                craftingResult.func_193056_a(rr);
                CraftingResultSlot sc = new CraftingResultSlot(p, real, (IInventory)craftingResult, 0, 0, 0);
                sc.func_190901_a(p, is);
                for (int x = 0; x < real.func_70302_i_(); ++x) {
                    ItemStack failed = playerInv.addItems(real.func_70301_a(x));
                    if (failed.func_190926_b()) continue;
                    p.func_71019_a(failed, false);
                }
                inv.addItems(is);
                if (p instanceof ServerPlayerEntity) {
                    this.updateHeld((ServerPlayerEntity)p);
                }
                this.func_75142_b();
            } else {
                for (int x = 0; x < real.func_70302_i_(); ++x) {
                    ItemStack failed = real.func_70301_a(x);
                    if (failed.func_190926_b()) continue;
                    this.monitor.injectItems(AEItemStack.fromItemStack(failed), Actionable.MODULATE, new MachineSource(this.getPatternTerminal()));
                }
            }
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (this.isServer()) {
            if (this.isCraftingMode() != this.getPatternTerminal().isCraftingRecipe()) {
                this.setCraftingMode(this.getPatternTerminal().isCraftingRecipe());
            }
            this.substitute = this.patternTerminal.isSubstitution();
        }
    }

    @Override
    public void onServerDataSync() {
        super.onServerDataSync();
        if (this.currentRecipeCraftingMode != this.craftingMode) {
            this.getAndUpdateOutput();
        }
    }

    @Override
    public void onSlotChange(Slot s) {
        if (s == this.encodedPatternSlot && this.isServer()) {
            for (IContainerListener listener : this.field_75149_d) {
                for (Slot slot : this.field_75151_b) {
                    if (!(slot instanceof OptionalFakeSlot) && !(slot instanceof FakeCraftingMatrixSlot)) continue;
                    listener.func_71111_a((Container)this, slot.field_75222_d, slot.func_75211_c());
                }
                if (!(listener instanceof ServerPlayerEntity)) continue;
                ((ServerPlayerEntity)listener).field_71137_h = false;
            }
            this.func_75142_b();
        }
        if (s == this.craftOutputSlot && this.isClient()) {
            this.getAndUpdateOutput();
        }
    }

    public void clear() {
        for (FakeCraftingMatrixSlot fakeCraftingMatrixSlot : this.craftingGridSlots) {
            fakeCraftingMatrixSlot.func_75215_d(ItemStack.field_190927_a);
        }
        for (FakeSlot fakeSlot : this.processingOutputSlots) {
            fakeSlot.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
        this.getAndUpdateOutput();
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("player")) {
            return new PlayerInvWrapper(this.getPlayerInventory());
        }
        return this.getPatternTerminal().getInventoryByName(name);
    }

    @Override
    public boolean useRealItems() {
        return false;
    }

    public boolean isCraftingMode() {
        return this.craftingMode;
    }

    private void setCraftingMode(boolean craftingMode) {
        this.craftingMode = craftingMode;
    }

    public PatternTerminalPart getPatternTerminal() {
        return this.patternTerminal;
    }

    private boolean isSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(boolean substitute) {
        this.substitute = substitute;
    }

    public FakeCraftingMatrixSlot[] getCraftingGridSlots() {
        return this.craftingGridSlots;
    }

    public OptionalFakeSlot[] getProcessingOutputSlots() {
        return this.processingOutputSlots;
    }

    public PatternTermSlot getCraftOutputSlot() {
        return this.craftOutputSlot;
    }
}

