/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.effects;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LightningFX
extends SpriteTexturedParticle {
    private static final Random RANDOM_GENERATOR = new Random();
    private static final int STEPS = 5;
    private static final int BRIGHTNESS = 208;
    private final double[][] precomputedSteps;
    private final double[] vertices = new double[3];
    private final double[] verticesWithUV = new double[3];
    private boolean hasData = false;

    private LightningFX(ClientWorld w, double x, double y, double z, double r, double g, double b) {
        this(w, x, y, z, r, g, b, 6);
        this.regen();
    }

    protected LightningFX(ClientWorld w, double x, double y, double z, double r, double g, double b, int maxAge) {
        super(w, x, y, z, r, g, b);
        this.precomputedSteps = new double[5][3];
        this.field_187129_i = 0.0;
        this.field_187130_j = 0.0;
        this.field_187131_k = 0.0;
        this.field_70547_e = maxAge;
    }

    protected void regen() {
        double lastDirectionX = (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9;
        double lastDirectionY = (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9;
        double lastDirectionZ = (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9;
        for (int s = 0; s < 5; ++s) {
            this.precomputedSteps[s][0] = lastDirectionX = (lastDirectionX + (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9) / 2.0;
            this.precomputedSteps[s][1] = lastDirectionY = (lastDirectionY + (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9) / 2.0;
            this.precomputedSteps[s][2] = lastDirectionZ = (lastDirectionZ + (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9) / 2.0;
        }
    }

    protected int getSteps() {
        return 5;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187130_j -= 0.04 * (double)this.field_70545_g;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= (double)0.98f;
        this.field_187130_j *= (double)0.98f;
        this.field_187131_k *= (double)0.98f;
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        Vector3d Vector3d2 = renderInfo.func_216785_c();
        float centerX = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - Vector3d2.func_82615_a());
        float centerY = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - Vector3d2.func_82617_b());
        float centerZ = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - Vector3d2.func_82616_c());
        float j = 1.0f;
        float red = this.field_70552_h * 1.0f * 0.9f;
        float green = this.field_70553_i * 1.0f * 0.95f;
        float blue = this.field_70551_j * 1.0f;
        float alpha = this.field_82339_as;
        if (this.field_70546_d == 3) {
            this.regen();
        }
        float u = this.func_217563_c() + (this.func_217564_d() - this.func_217563_c()) / 2.0f;
        float v = this.func_217562_e() + (this.func_217560_f() - this.func_217562_e()) / 2.0f;
        double scale = 0.02;
        double[] a = new double[3];
        double[] b = new double[3];
        double ox = 0.0;
        double oy = 0.0;
        double oz = 0.0;
        ClientPlayerEntity p = Minecraft.func_71410_x().field_71439_g;
        for (int layer = 0; layer < 2; ++layer) {
            if (layer == 0) {
                scale = 0.04;
                red = this.field_70552_h * 1.0f * 0.4f;
                green = this.field_70553_i * 1.0f * 0.25f;
                blue = this.field_70551_j * 1.0f * 0.45f;
            } else {
                scale = 0.02;
                red = this.field_70552_h * 1.0f * 0.9f;
                green = this.field_70553_i * 1.0f * 0.65f;
                blue = this.field_70551_j * 1.0f * 0.85f;
            }
            for (int cycle = 0; cycle < 3; ++cycle) {
                this.clear();
                double x = centerX;
                double y = centerY;
                double z = centerZ;
                for (int s = 0; s < 5; ++s) {
                    double xN = x + this.precomputedSteps[s][0];
                    double yN = y + this.precomputedSteps[s][1];
                    double zN = z + this.precomputedSteps[s][2];
                    double xD = xN - x;
                    double yD = yN - y;
                    double zD = zN - z;
                    if (cycle == 0) {
                        ox = yD * 0.0 - 1.0 * zD;
                        oy = zD * 0.0 - 0.0 * xD;
                        oz = xD * 1.0 - 0.0 * yD;
                    }
                    if (cycle == 1) {
                        ox = yD * 1.0 - 0.0 * zD;
                        oy = zD * 0.0 - 1.0 * xD;
                        oz = xD * 0.0 - 0.0 * yD;
                    }
                    if (cycle == 2) {
                        ox = yD * 0.0 - 0.0 * zD;
                        oy = zD * 1.0 - 0.0 * xD;
                        oz = xD * 0.0 - 1.0 * yD;
                    }
                    double ss = Math.sqrt(ox * ox + oy * oy + oz * oz) / ((5.0 - (double)s) / 5.0 * scale);
                    a[0] = x + (ox /= ss);
                    a[1] = y + (oy /= ss);
                    a[2] = z + (oz /= ss);
                    b[0] = x;
                    b[1] = y;
                    b[2] = z;
                    this.draw(red, green, blue, buffer, a, b, u, v);
                    x = xN;
                    y = yN;
                    z = zN;
                }
            }
        }
    }

    private void clear() {
        this.hasData = false;
    }

    private void draw(float red, float green, float blue, IVertexBuilder tess, double[] a, double[] b, float u, float v) {
        if (this.hasData) {
            tess.func_225582_a_(a[0], a[1], a[2]).func_225583_a_(u, v).func_227885_a_(red, green, blue, this.field_82339_as).func_225587_b_(208, 208).func_181675_d();
            tess.func_225582_a_(this.vertices[0], this.vertices[1], this.vertices[2]).func_225583_a_(u, v).func_227885_a_(red, green, blue, this.field_82339_as).func_225587_b_(208, 208).func_181675_d();
            tess.func_225582_a_(this.verticesWithUV[0], this.verticesWithUV[1], this.verticesWithUV[2]).func_225583_a_(u, v).func_227885_a_(red, green, blue, this.field_82339_as).func_225587_b_(208, 208).func_181675_d();
            tess.func_225582_a_(b[0], b[1], b[2]).func_225583_a_(u, v).func_227885_a_(red, green, blue, this.field_82339_as).func_225587_b_(208, 208).func_181675_d();
        }
        this.hasData = true;
        for (int x = 0; x < 3; ++x) {
            this.vertices[x] = a[x];
            this.verticesWithUV[x] = b[x];
        }
    }

    protected double[][] getPrecomputedSteps() {
        return this.precomputedSteps;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LightningFX lightningFX = new LightningFX(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            lightningFX.func_217568_a(this.spriteSet);
            return lightningFX;
        }
    }
}

