/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;

public class VerticalButtonBar
implements ICompositeWidget {
    private static final int VERTICAL_SPACING = 4;
    private static final int MARGIN = 2;
    private final List<Button> buttons = new ArrayList<Button>();
    private Point screenOrigin = Point.ZERO;
    private Rectangle2d bounds = new Rectangle2d(0, 0, 0, 0);
    private Point position;

    public void add(Button button) {
        this.buttons.add(button);
    }

    @Override
    public void setPosition(Point position) {
        this.position = position;
    }

    @Override
    public void setSize(int width, int height) {
    }

    @Override
    public Rectangle2d getBounds() {
        return this.bounds;
    }

    @Override
    public void updateBeforeRender() {
        int currentY = this.position.getY() + 2;
        int maxWidth = 0;
        for (Button button : this.buttons) {
            if (!button.field_230694_p_) continue;
            button.field_230690_l_ = this.screenOrigin.getX() + this.position.getX() - 2 - button.func_230998_h_();
            button.field_230691_m_ = this.screenOrigin.getY() + currentY;
            currentY += button.func_238483_d_() + 4;
            maxWidth = Math.max(button.func_230998_h_(), maxWidth);
        }
        if (maxWidth == 0) {
            this.bounds = new Rectangle2d(0, 0, 0, 0);
        } else {
            int boundX = this.position.getX() - maxWidth - 4;
            int boundY = this.position.getY();
            this.bounds = new Rectangle2d(boundX, boundY, maxWidth + 4, currentY - boundY);
        }
    }

    @Override
    public void populateScreen(Consumer<Widget> addWidget, Rectangle2d bounds, AEBaseScreen<?> screen) {
        this.screenOrigin = Point.fromTopLeft(bounds);
        this.buttons.forEach(addWidget);
    }
}

