/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.items;

import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.util.Platform;
import java.util.Comparator;

final class ItemSorters {
    public static final Comparator<IAEItemStack> NAME_ASC = Comparator.comparing(is -> Platform.getItemDisplayName(is).getString(), String::compareToIgnoreCase);
    public static final Comparator<IAEItemStack> NAME_DESC = NAME_ASC.reversed();
    public static final Comparator<IAEItemStack> MOD_ASC = Comparator.comparing(fs -> Platform.getModId(fs), String::compareToIgnoreCase).thenComparing(NAME_ASC);
    public static final Comparator<IAEItemStack> MOD_DESC = MOD_ASC.reversed();
    public static final Comparator<IAEItemStack> SIZE_ASC = Comparator.comparingLong(IAEStack::getStackSize);
    public static final Comparator<IAEItemStack> SIZE_DESC = SIZE_ASC.reversed();

    private ItemSorters() {
    }

    public static Comparator<IAEItemStack> getComparator(SortOrder order, SortDir dir) {
        switch (order) {
            default: {
                return dir == SortDir.ASCENDING ? NAME_ASC : NAME_DESC;
            }
            case AMOUNT: {
                return dir == SortDir.ASCENDING ? SIZE_ASC : SIZE_DESC;
            }
            case MOD: 
        }
        return dir == SortDir.ASCENDING ? MOD_ASC : MOD_DESC;
    }
}

