/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.SortOrder;
import appeng.client.gui.Icon;
import appeng.client.gui.me.items.ItemTerminalScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ToggleButton;
import appeng.container.implementations.SecurityStationContainer;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class SecurityStationScreen
extends ItemTerminalScreen<SecurityStationContainer> {
    private final ToggleButton inject;
    private final ToggleButton extract;
    private final ToggleButton craft;
    private final ToggleButton build;
    private final ToggleButton security;
    private final Blitter encodingBg;

    public SecurityStationScreen(SecurityStationContainer container, PlayerInventory playerInventory, ITextComponent title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        this.encodingBg = style.getImage("encoding");
        this.inject = new ToggleButton(Icon.PERMISSION_INJECT, Icon.PERMISSION_INJECT_DISABLED, SecurityPermissions.INJECT.getDisplayName(), SecurityPermissions.INJECT.getDisplayHint(), btn -> this.toggleOption(SecurityPermissions.INJECT));
        this.extract = new ToggleButton(Icon.PERMISSION_EXTRACT, Icon.PERMISSION_EXTRACT_DISABLED, SecurityPermissions.EXTRACT.getDisplayName(), SecurityPermissions.EXTRACT.getDisplayHint(), btn -> this.toggleOption(SecurityPermissions.EXTRACT));
        this.craft = new ToggleButton(Icon.PERMISSION_CRAFT, Icon.PERMISSION_CRAFT_DISABLED, SecurityPermissions.CRAFT.getDisplayName(), SecurityPermissions.CRAFT.getDisplayHint(), btn -> this.toggleOption(SecurityPermissions.CRAFT));
        this.build = new ToggleButton(Icon.PERMISSION_BUILD, Icon.PERMISSION_BUILD_DISABLED, SecurityPermissions.BUILD.getDisplayName(), SecurityPermissions.BUILD.getDisplayHint(), btn -> this.toggleOption(SecurityPermissions.BUILD));
        this.security = new ToggleButton(Icon.PERMISSION_SECURITY, Icon.PERMISSION_SECURITY_DISABLED, SecurityPermissions.SECURITY.getDisplayName(), SecurityPermissions.SECURITY.getDisplayHint(), btn -> this.toggleOption(SecurityPermissions.SECURITY));
        this.widgets.add("permissionInject", (Widget)this.inject);
        this.widgets.add("permissionExtract", (Widget)this.extract);
        this.widgets.add("permissionCraft", (Widget)this.craft);
        this.widgets.add("permissionBuild", (Widget)this.build);
        this.widgets.add("permissionSecurity", (Widget)this.security);
    }

    private void toggleOption(SecurityPermissions permission) {
        NetworkHandler.instance().sendToServer(new ConfigValuePacket("TileSecurityStation.ToggleOption", permission.name()));
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.inject.setState((((SecurityStationContainer)this.field_147002_h).getPermissionMode() & 1 << SecurityPermissions.INJECT.ordinal()) > 0);
        this.extract.setState((((SecurityStationContainer)this.field_147002_h).getPermissionMode() & 1 << SecurityPermissions.EXTRACT.ordinal()) > 0);
        this.craft.setState((((SecurityStationContainer)this.field_147002_h).getPermissionMode() & 1 << SecurityPermissions.CRAFT.ordinal()) > 0);
        this.build.setState((((SecurityStationContainer)this.field_147002_h).getPermissionMode() & 1 << SecurityPermissions.BUILD.ordinal()) > 0);
        this.security.setState((((SecurityStationContainer)this.field_147002_h).getPermissionMode() & 1 << SecurityPermissions.SECURITY.ordinal()) > 0);
    }

    @Override
    public void drawBG(MatrixStack matrixStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(matrixStack, offsetX, offsetY, mouseX, mouseY, partialTicks);
        this.encodingBg.dest(offsetX + this.field_146999_f + 3, offsetY).blit(matrixStack, this.func_230927_p_());
    }

    @Override
    public SortOrder getSortBy() {
        return SortOrder.NAME;
    }

    @Override
    public List<Rectangle2d> getExclusionZones() {
        List<Rectangle2d> result = super.getExclusionZones();
        result.add(new Rectangle2d(this.field_147003_i + this.field_146999_f + 3, this.field_147009_r, this.encodingBg.getSrcWidth(), this.encodingBg.getSrcHeight()));
        return result;
    }
}

