/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.fullbody;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.animations.PoseOverwrite;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class LadderAnimation
extends BasicAnimation
implements PoseOverwrite {
    final Set<Class<? extends Block>> ladderLikeBlocks = new HashSet<Class>(Arrays.asList(LadderBlock.class, TrapDoorBlock.class));
    final BodyPart[] parts = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.RIGHT_ARM, BodyPart.BODY, BodyPart.LEFT_LEG, BodyPart.RIGHT_LEG};
    final BodyPart[] partsSneakingRight = new BodyPart[]{BodyPart.RIGHT_ARM, BodyPart.BODY, BodyPart.LEFT_LEG, BodyPart.RIGHT_LEG};
    final BodyPart[] partsSneakingLeft = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.BODY, BodyPart.LEFT_LEG, BodyPart.RIGHT_LEG};

    @Override
    public boolean isEnabled() {
        return NEABaseMod.config.enableLadderAnimation;
    }

    @Override
    public boolean isValid(AbstractClientPlayerEntity entity, PlayerData data) {
        if (entity.func_70617_f_() && !entity.func_233570_aj_() && entity.func_233644_dn_().isPresent()) {
            for (Class<? extends Block> blocktype : this.ladderLikeBlocks) {
                if (!blocktype.isAssignableFrom(entity.field_70170_p.func_180495_p((BlockPos)entity.func_233644_dn_().get()).func_177230_c().getClass())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayerEntity entity, PlayerData data) {
        if (entity.func_213453_ef() && entity.func_213322_ci().field_72448_b == -0.0784000015258789) {
            if (entity.func_184591_cq() == HandSide.RIGHT) {
                return this.partsSneakingLeft;
            }
            return this.partsSneakingRight;
        }
        return this.parts;
    }

    @Override
    public int getPriority(AbstractClientPlayerEntity entity, PlayerData data) {
        return 1400;
    }

    @Override
    public void apply(AbstractClientPlayerEntity entity, PlayerData data, PlayerModel<AbstractClientPlayerEntity> model, BodyPart part, float delta, float tickCounter) {
        if (part == BodyPart.BODY && NEABaseMod.config.enableRotateToLadder) {
            BlockState blockState = entity.func_213339_cH();
            if (blockState.func_235901_b_((Property)HorizontalBlock.field_185512_D)) {
                Direction dir = (Direction)blockState.func_177229_b((Property)HorizontalBlock.field_185512_D);
                data.disableBodyRotation(true);
                switch (dir) {
                    case NORTH: {
                        entity.func_181013_g(0.0f);
                        entity.field_70760_ar = 0.0f;
                        break;
                    }
                    case EAST: {
                        entity.func_181013_g(90.0f);
                        entity.field_70760_ar = 90.0f;
                        break;
                    }
                    case SOUTH: {
                        entity.func_181013_g(180.0f);
                        entity.field_70760_ar = 180.0f;
                        break;
                    }
                    case WEST: {
                        entity.func_181013_g(270.0f);
                        entity.field_70760_ar = 270.0f;
                        break;
                    }
                }
                AnimationUtil.minMaxHeadRotation((PlayerEntity)entity, model);
            }
            return;
        }
        if (part == BodyPart.LEFT_LEG || part == BodyPart.RIGHT_LEG) {
            float rotation = -MathHelper.func_76134_b((float)((float)(entity.func_226278_cu_() * (double)NEABaseMod.config.ladderAnimationArmSpeed)));
            rotation *= NEABaseMod.config.ladderAnimationAmplifier;
            if (part == BodyPart.LEFT_LEG) {
                rotation *= -1.0f;
            }
            AnimationUtil.applyTransforms(model, part, -1.0f - rotation, -0.2f, 0.3f);
            return;
        }
        float rotation = -MathHelper.func_76134_b((float)((float)(entity.func_226278_cu_() * (double)NEABaseMod.config.ladderAnimationArmSpeed)));
        rotation *= NEABaseMod.config.ladderAnimationAmplifier;
        if (part == BodyPart.LEFT_ARM) {
            rotation *= -1.0f;
        }
        AnimationUtil.applyTransforms(model, part, -NEABaseMod.config.ladderAnimationArmHeight - rotation, -0.2f, 0.3f);
    }

    @Override
    public void updateState(AbstractClientPlayerEntity entity, PlayerData data, PlayerModel<AbstractClientPlayerEntity> playerModel) {
        if (entity.func_213453_ef() && this.isValid(entity, data)) {
            data.setPoseOverwrite(entity.func_213283_Z());
            entity.func_213301_b(Pose.STANDING);
            playerModel.field_228270_o_ = false;
        }
    }
}

