/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.fullbody;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import dev.tr7zw.notenoughanimations.versionless.animations.DataHolder;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.util.math.MathHelper;

public class FallingAnimation
extends BasicAnimation
implements DataHolder<FallingData> {
    @Override
    public boolean isEnabled() {
        return NEABaseMod.config.fallingAnimation;
    }

    @Override
    public boolean isValid(AbstractClientPlayerEntity entity, PlayerData data) {
        if (!(entity.func_184613_cA() || entity.func_233570_aj_() || entity.func_70617_f_() || entity.field_71075_bZ.field_75100_b || entity.func_203007_ba())) {
            FallingData fallData = data.getData(this, () -> new FallingData(entity.func_226278_cu_()));
            if (entity instanceof ClientPlayerEntity) {
                fallData.fallingSpeed = (float)(entity.func_213322_ci().func_189985_c() / 11.0);
                return entity.field_70143_R > 3.0f;
            }
            if (entity.func_226278_cu_() == fallData.lastY) {
                return fallData.fallingSpeed > 0.14285715f;
            }
            fallData.fallingSpeed = (float)(fallData.lastY - entity.func_226278_cu_()) / 3.5f;
            fallData.lastY = entity.func_226278_cu_();
            return fallData.fallingSpeed > 0.14285715f;
        }
        return false;
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayerEntity entity, PlayerData data) {
        return BodyPart.values();
    }

    @Override
    public int getPriority(AbstractClientPlayerEntity entity, PlayerData data) {
        return 400;
    }

    @Override
    public void apply(AbstractClientPlayerEntity entity, PlayerData data, PlayerModel<AbstractClientPlayerEntity> model, BodyPart part, float delta, float tickCounter) {
        FallingData fallData = data.getData(this, () -> new FallingData(entity.func_226278_cu_()));
        float moveSqrt = fallData.fallingSpeed;
        float armsMove = Math.min(1.0f, moveSqrt * 2.0f);
        moveSqrt = Math.min(1.0f, moveSqrt);
        float moveOutArms = 1.9f * armsMove;
        float moveOutLegs = 0.6f * moveSqrt;
        float movement = (float)entity.field_70173_aa + delta;
        if (part == BodyPart.LEFT_ARM) {
            model.field_178724_i.field_78795_f = MathHelper.func_76134_b((float)(movement * 0.6662f)) * moveSqrt;
            model.field_178724_i.field_78808_h = -moveOutArms;
        }
        if (part == BodyPart.RIGHT_ARM) {
            model.field_178723_h.field_78795_f = MathHelper.func_76134_b((float)(movement * 0.6662f + (float)Math.PI)) * moveSqrt;
            model.field_178723_h.field_78808_h = moveOutArms;
        }
        if (part == BodyPart.LEFT_LEG) {
            model.field_178722_k.field_78795_f = MathHelper.func_76134_b((float)(movement * 0.6662f + (float)Math.PI)) * 1.4f * moveSqrt;
            model.field_178722_k.field_78808_h = -moveOutLegs;
        }
        if (part == BodyPart.RIGHT_LEG) {
            model.field_178721_j.field_78795_f = MathHelper.func_76134_b((float)(movement * 0.6662f)) * 1.4f * moveSqrt;
            model.field_178721_j.field_78808_h = moveOutLegs;
        }
    }

    public static class FallingData {
        public double lastY = 0.0;
        public float fallingSpeed = 0.0f;

        public FallingData(double y) {
            this.lastY = y;
        }
    }
}

