/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core.recipe;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class AddUpgradeRecipe
extends SpecialRecipe {
    public AddUpgradeRecipe(ResourceLocation name) {
        super(name);
    }

    public boolean matches(CraftingInventory inv, World world) {
        return this.findContext(inv) != null;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        Context ctx = this.findContext(inv);
        if (ctx == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = ctx.drawer.func_77946_l();
        ret.func_196082_o().func_218657_a("tile", (INBT)ctx.data.write(ret.func_196082_o().func_74775_l("tile")));
        return ret;
    }

    @Nullable
    private Context findContext(CraftingInventory inv) {
        Context ret = new Context();
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack stack = inv.func_70301_a(x);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemDrawers) {
                if (!ret.drawer.func_190926_b()) {
                    return null;
                }
                ret.drawer = stack;
                continue;
            }
            if (stack.func_77973_b() instanceof ItemUpgrade) {
                ret.upgrades.add(stack);
                continue;
            }
            return null;
        }
        if (ret.drawer.func_190926_b() || ret.upgrades.isEmpty()) {
            return null;
        }
        ret.data = new UpgradeData(7){

            @Override
            public boolean setUpgrade(int slot, @Nonnull ItemStack upgrade) {
                if (upgrade.func_190926_b()) {
                    return false;
                }
                upgrade = upgrade.func_77946_l();
                upgrade.func_190920_e(1);
                this.upgrades[slot] = upgrade;
                return true;
            }
        };
        if (ret.drawer.func_77942_o() && ret.drawer.func_77978_p().func_74764_b("tile")) {
            ret.data.read(ret.drawer.func_77978_p().func_74775_l("tile"));
        }
        for (ItemStack upgrade : ret.upgrades) {
            if (upgrade.func_77973_b() == ModItems.ONE_STACK_UPGRADE) {
                return null;
            }
            if (!ret.data.hasEmptySlot() || !ret.data.canAddUpgrade(upgrade)) {
                return null;
            }
            ret.data.addUpgrade(upgrade);
        }
        return ret;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)StorageDrawers.UPGRADE_RECIPE_SERIALIZER.get();
    }

    private static class Context {
        ItemStack drawer = ItemStack.field_190927_a;
        List<ItemStack> upgrades = new ArrayList<ItemStack>();
        UpgradeData data = null;

        private Context() {
        }
    }
}

