/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.util;

public class HeatBody {
    private boolean isInfinite = false;
    private double rfPerKelvin = 0.0;
    private double temperature = 0.0;

    public void setInfinite(boolean infinite) {
        this.isInfinite = infinite;
    }

    public boolean isInfinite() {
        return this.isInfinite;
    }

    public void setRfPerKelvin(double rfPerKelvin) {
        this.rfPerKelvin = rfPerKelvin;
    }

    public double rfPerKelvin() {
        return this.rfPerKelvin;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public double temperature() {
        return this.temperature;
    }

    public double transferWith(HeatBody other, double rfkt) {
        double rfTransferred;
        if (this.isInfinite && other.isInfinite()) {
            return 0.0;
        }
        if (!this.isInfinite && other.isInfinite()) {
            return -other.transferWith(this, rfkt);
        }
        if (!this.isInfinite) {
            double targetTemperature = this.rfPerKelvin * (this.temperature - other.temperature()) / (this.rfPerKelvin + other.rfPerKelvin());
            double denominator = rfkt * (this.rfPerKelvin + other.rfPerKelvin());
            denominator /= this.rfPerKelvin * other.rfPerKelvin();
            denominator = Math.exp(-denominator);
            double thisNewTemp = this.temperature - (targetTemperature += other.temperature);
            thisNewTemp *= denominator;
            double otherNewTemp = other.temperature() - targetTemperature;
            otherNewTemp *= denominator;
            rfTransferred = ((otherNewTemp += targetTemperature) - other.temperature()) * other.rfPerKelvin();
            this.temperature = thisNewTemp += targetTemperature;
            other.setTemperature(otherNewTemp);
        } else {
            double newTemp = other.temperature() - this.temperature;
            newTemp *= Math.exp(-rfkt / other.rfPerKelvin());
            rfTransferred = ((newTemp += this.temperature) - other.temperature()) * other.rfPerKelvin();
            other.setTemperature(newTemp);
        }
        return rfTransferred;
    }

    public double additionalRFForTemperature(double targetTemperature) {
        double currentRF = this.rfFromTemperature(this.temperature);
        double targetRF = this.rfFromTemperature(targetTemperature);
        return targetRF - currentRF;
    }

    public double temperatureWithAdditionalRF(double rf) {
        return this.temperature + (this.isInfinite ? 0.0 : rf / this.rfPerKelvin);
    }

    public double absorbRF(double rf) {
        this.temperature = this.temperatureWithAdditionalRF(rf);
        return rf;
    }

    public double rfFromTemperature(double temperature) {
        return temperature * this.rfPerKelvin;
    }

    public double rf() {
        return this.rfFromTemperature(this.temperature);
    }

    public double tempFromRF(double rf) {
        return rf / this.rfPerKelvin;
    }
}

