/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.repack.org.joml;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.roguelogix.phosphophyllite.repack.org.joml.Runtime;
import sun.misc.Unsafe;

public class Random {
    private final Xorshiro128 rnd;
    private static long seedHalf = 8020463840L;
    private static final Unsafe UNSAFE = Random.getUnsafeInstance();
    private static final long seedHalf_offset = Random.seedHalfOffset();

    private static long seedHalfOffset() {
        try {
            return UNSAFE.staticFieldOffset(Random.class.getDeclaredField("seedHalf"));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException();
        }
    }

    private static Unsafe getUnsafeInstance() throws SecurityException {
        Field[] fields = Unsafe.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            int modifiers;
            Field field = fields[i];
            if (!field.getType().equals(Unsafe.class) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
            field.setAccessible(true);
            try {
                return (Unsafe)field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                break;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static long newSeed() {
        long newSeedHalf;
        long oldSeedHalf;
        while (!UNSAFE.compareAndSwapLong(Random.class, seedHalf_offset, oldSeedHalf = seedHalf, newSeedHalf = oldSeedHalf * 3512401965023503517L)) {
        }
        return newSeedHalf;
    }

    public Random() {
        this(Random.newSeed() ^ System.nanoTime());
    }

    public Random(long seed) {
        this.rnd = new Xorshiro128(seed);
    }

    public float nextFloat() {
        return this.rnd.nextFloat();
    }

    public int nextInt(int n) {
        return this.rnd.nextInt(n);
    }

    private static final class Xorshiro128 {
        private static final float INT_TO_FLOAT = Float.intBitsToFloat(0x33800000);
        private long _s0;
        private long _s1;
        private long state;

        Xorshiro128(long seed) {
            this.state = seed;
            this._s0 = this.nextSplitMix64();
            this._s1 = this.nextSplitMix64();
        }

        private long nextSplitMix64() {
            long z = this.state += -7046029254386353131L;
            z = (z ^ z >>> 30) * -4658895280553007687L;
            z = (z ^ z >>> 27) * -7723592293110705685L;
            return z ^ z >>> 31;
        }

        final float nextFloat() {
            return (float)(this.nextInt() >>> 8) * INT_TO_FLOAT;
        }

        private int nextInt() {
            long s0 = this._s0;
            long s1 = this._s1;
            long result = s0 + s1;
            this.rotateLeft(s0, s1 ^= s0);
            return (int)(result & 0xFFFFFFFFFFFFFFFFL);
        }

        private static long rotl_JDK4(long x, int k) {
            return x << k | x >>> 64 - k;
        }

        private static long rotl_JDK5(long x, int k) {
            return Long.rotateLeft(x, k);
        }

        private static long rotl(long x, int k) {
            if (Runtime.HAS_Long_rotateLeft) {
                return Xorshiro128.rotl_JDK5(x, k);
            }
            return Xorshiro128.rotl_JDK4(x, k);
        }

        private void rotateLeft(long s0, long s1) {
            this._s0 = Xorshiro128.rotl(s0, 55) ^ s1 ^ s1 << 14;
            this._s1 = Xorshiro128.rotl(s1, 36);
        }

        final int nextInt(int n) {
            long r = this.nextInt() >>> 1;
            r = r * (long)n >> 31;
            return (int)r;
        }
    }
}

