/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar.tracker;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.radar.tracker.PlayerTrackerIconRenderer;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElement;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementCollector;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementReader;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementRenderContext;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementRenderProvider;
import xaero.common.minimap.render.MinimapRendererHelper;

public final class PlayerTrackerMinimapElementRenderer
extends MinimapElementRenderer<PlayerTrackerMinimapElement<?>, PlayerTrackerMinimapElementRenderContext> {
    private final PlayerTrackerMinimapElementCollector elementCollector;
    private final PlayerTrackerIconRenderer playerTrackerIconRenderer;
    private final IXaeroMinimap modMain;

    private PlayerTrackerMinimapElementRenderer(PlayerTrackerMinimapElementCollector elementCollector, IXaeroMinimap modMain, PlayerTrackerMinimapElementRenderContext context, PlayerTrackerMinimapElementRenderProvider<PlayerTrackerMinimapElementRenderContext> provider, PlayerTrackerMinimapElementReader reader, PlayerTrackerIconRenderer playerTrackerIconRenderer) {
        super(reader, provider, context);
        this.elementCollector = elementCollector;
        this.modMain = modMain;
        this.playerTrackerIconRenderer = playerTrackerIconRenderer;
    }

    public ResourceLocation getPlayerSkin(PlayerEntity player, NetworkPlayerInfo info) {
        ResourceLocation skinTextureLocation;
        ResourceLocation resourceLocation = skinTextureLocation = player instanceof AbstractClientPlayerEntity ? ((AbstractClientPlayerEntity)player).func_110306_p() : info.func_178837_g();
        if (skinTextureLocation == null) {
            skinTextureLocation = DefaultPlayerSkin.func_177334_a((UUID)player.func_110124_au());
        }
        return skinTextureLocation;
    }

    @Override
    public void preRender(int location, Entity renderEntity, PlayerEntity player, double renderX, double renderY, double renderZ, IXaeroMinimap modMain, IRenderTypeBuffer.Impl renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider) {
        ((PlayerTrackerMinimapElementRenderContext)this.context).outlineConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
        ((PlayerTrackerMinimapElementRenderContext)this.context).uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_NEAREST);
        if (modMain.getSupportMods().worldmap()) {
            ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimId = modMain.getSupportMods().worldmapSupport.getMapDimension();
            ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimDiv = modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().getLastPlayerDimDiv();
        } else {
            ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimId = Minecraft.func_71410_x().field_71441_e.func_234923_W_();
            ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimDiv = 1.0;
        }
    }

    @Override
    public void postRender(int location, Entity renderEntity, PlayerEntity player, double renderX, double renderY, double renderZ, IXaeroMinimap modMain, IRenderTypeBuffer.Impl renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider) {
        rendererProvider.draw(((PlayerTrackerMinimapElementRenderContext)this.context).uniqueTextureUIObjectRenderer);
        renderTypeBuffers.func_228461_a_();
        this.elementCollector.resetRenderedOnRadarFlags();
    }

    @Override
    public boolean renderElement(int location, boolean highlit, boolean outOfBounds, MatrixStack matrixStack, IRenderTypeBuffer.Impl renderTypeBuffers, FontRenderer font, Framebuffer framebuffer, MinimapRendererHelper helper, Entity renderEntity, PlayerEntity player, double renderX, double renderY, double renderZ, int elementIndex, double optionalDepth, float optionalScale, PlayerTrackerMinimapElement<?> e, double partialX, double partialY, boolean cave, float partialTicks) {
        if (!outOfBounds && e.wasRenderedOnRadar()) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        NetworkPlayerInfo info = mc.func_147114_u().func_175102_a(e.getPlayerId());
        if (info != null) {
            PlayerEntity clientPlayer = mc.field_71441_e.func_217371_b(e.getPlayerId());
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, optionalDepth);
            matrixStack.func_227862_a_(optionalScale, optionalScale, 1.0f);
            helper.addColoredRectToExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), ((PlayerTrackerMinimapElementRenderContext)this.context).outlineConsumer, -5.0f, -5.0f, 10, 10, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.func_227861_a_(0.0, 0.0, 0.01);
            this.playerTrackerIconRenderer.renderIcon(mc, ((PlayerTrackerMinimapElementRenderContext)this.context).uniqueTextureUIObjectRenderer, helper, matrixStack, clientPlayer, this.getPlayerSkin(clientPlayer, info));
            matrixStack.func_227865_b_();
        }
        return false;
    }

    @Override
    public boolean shouldRender(int location) {
        return this.modMain.getSettings().displayTrackedPlayers;
    }

    @Override
    public int getOrder() {
        return 100;
    }

    public PlayerTrackerMinimapElementCollector getCollector() {
        return this.elementCollector;
    }

    public static final class Builder {
        private final IXaeroMinimap modMain;

        private Builder(IXaeroMinimap modMain) {
            this.modMain = modMain;
        }

        private Builder setDefault() {
            return this;
        }

        public PlayerTrackerMinimapElementRenderer build() {
            PlayerTrackerMinimapElementCollector collector = new PlayerTrackerMinimapElementCollector(this.modMain.getPlayerTrackerSystemManager());
            return new PlayerTrackerMinimapElementRenderer(collector, this.modMain, new PlayerTrackerMinimapElementRenderContext(), new PlayerTrackerMinimapElementRenderProvider(collector), new PlayerTrackerMinimapElementReader(), new PlayerTrackerIconRenderer());
        }

        public static Builder begin(IXaeroMinimap modMain) {
            return new Builder(modMain).setDefault();
        }
    }
}

