/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.message;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageDragonSetBurnBlock {
    public int dragonId;
    public boolean breathingFire;
    public int posX;
    public int posY;
    public int posZ;

    public MessageDragonSetBurnBlock(int dragonId, boolean breathingFire, BlockPos pos) {
        this.dragonId = dragonId;
        this.breathingFire = breathingFire;
        this.posX = pos.func_177958_n();
        this.posY = pos.func_177956_o();
        this.posZ = pos.func_177952_p();
    }

    public MessageDragonSetBurnBlock() {
    }

    public static MessageDragonSetBurnBlock read(PacketBuffer buf) {
        return new MessageDragonSetBurnBlock(buf.readInt(), buf.readBoolean(), new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()));
    }

    public static void write(MessageDragonSetBurnBlock message, PacketBuffer buf) {
        buf.writeInt(message.dragonId);
        buf.writeBoolean(message.breathingFire);
        buf.writeInt(message.posX);
        buf.writeInt(message.posY);
        buf.writeInt(message.posZ);
    }

    public static class Handler {
        public static void handle(MessageDragonSetBurnBlock message, Supplier<NetworkEvent.Context> context) {
            Entity entity;
            context.get().setPacketHandled(true);
            ServerPlayerEntity player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = IceAndFire.PROXY.getClientSidePlayer();
            }
            if (player != null && player.field_70170_p != null && player.field_70170_p != null && (entity = player.field_70170_p.func_73045_a(message.dragonId)) != null && entity instanceof EntityDragonBase) {
                EntityDragonBase dragon = (EntityDragonBase)entity;
                dragon.setBreathingFire(message.breathingFire);
                dragon.burningTarget = new BlockPos(message.posX, message.posY, message.posZ);
            }
        }
    }
}

