/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.props;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;

public class MiscProperties {
    private static final String MISC_DATA = "MiscDataIaf";
    private static final String DISMOUNTED_DRAGON = "HasDismounted";
    private static final String IN_LOVE_TIME = "TicksInLove";
    private static final String LUNGE_TICKS = "LungeTicks";
    private static final String PREV_LUNGE_TICKS = "PrevLungeTicks";
    private static final String TARGETED_BY_SCEPTER_HOLDERS = "ScepterHolders";
    private static final String TARGETING_ENTITIES_WITH_SCEPTER = "ScepterTargets";
    private static final String SCEPTER_ENTITY_ID = "ScepterEntityId";
    private static final Random rand = new Random();

    private static CompoundNBT getOrCreateMiscData(LivingEntity entity) {
        return MiscProperties.getOrCreateMiscData(CitadelEntityData.getCitadelTag((LivingEntity)entity));
    }

    private static CompoundNBT getOrCreateMiscData(CompoundNBT entityData) {
        if (entityData.func_150297_b(MISC_DATA, 10)) {
            return (CompoundNBT)entityData.func_74781_a(MISC_DATA);
        }
        return MiscProperties.createDefaultData();
    }

    private static ListNBT getOrCreateScepterTargetedBy(LivingEntity entity) {
        return MiscProperties.getOrCreateScepterTargetedBy(CitadelEntityData.getCitadelTag((LivingEntity)entity));
    }

    private static ListNBT getOrCreateScepterTargetedBy(CompoundNBT entityData) {
        CompoundNBT miscData = MiscProperties.getOrCreateMiscData(entityData);
        if (miscData.func_150297_b(TARGETED_BY_SCEPTER_HOLDERS, 9)) {
            return miscData.func_150295_c(TARGETED_BY_SCEPTER_HOLDERS, 10);
        }
        return new ListNBT();
    }

    private static ListNBT getOrCreateScepterTargets(CompoundNBT entityData) {
        CompoundNBT miscData = MiscProperties.getOrCreateMiscData(entityData);
        if (miscData.func_150297_b(TARGETING_ENTITIES_WITH_SCEPTER, 9)) {
            return miscData.func_150295_c(TARGETING_ENTITIES_WITH_SCEPTER, 10);
        }
        return new ListNBT();
    }

    private static CompoundNBT createDefaultData() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a(IN_LOVE_TIME, 0);
        nbt.func_74757_a(DISMOUNTED_DRAGON, false);
        ListNBT scepterHolders = new ListNBT();
        nbt.func_218657_a(TARGETED_BY_SCEPTER_HOLDERS, (INBT)scepterHolders);
        ListNBT scepterTargets = new ListNBT();
        nbt.func_218657_a(TARGETING_ENTITIES_WITH_SCEPTER, (INBT)scepterTargets);
        return nbt;
    }

    public static boolean hasDismounted(LivingEntity entity) {
        CompoundNBT nbt = MiscProperties.getOrCreateMiscData(entity);
        if (nbt.func_74764_b(DISMOUNTED_DRAGON)) {
            return nbt.func_74767_n(DISMOUNTED_DRAGON);
        }
        return false;
    }

    public static int getLoveTicks(LivingEntity entity) {
        CompoundNBT nbt = MiscProperties.getOrCreateMiscData(entity);
        if (nbt.func_74764_b(IN_LOVE_TIME)) {
            return nbt.func_74762_e(IN_LOVE_TIME);
        }
        return 0;
    }

    public static int getLungeTicks(LivingEntity entity) {
        CompoundNBT nbt = MiscProperties.getOrCreateMiscData(entity);
        if (nbt.func_74764_b(LUNGE_TICKS)) {
            return nbt.func_74762_e(LUNGE_TICKS);
        }
        return 0;
    }

    public static void setLoveTicks(LivingEntity entity, int duration) {
        CompoundNBT entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        CompoundNBT miscData = MiscProperties.getOrCreateMiscData(entityData);
        miscData.func_74768_a(IN_LOVE_TIME, duration);
        entityData.func_218657_a(MISC_DATA, (INBT)miscData);
        MiscProperties.updateData(entity, entityData);
    }

    public static void setDismountedDragon(LivingEntity entity, boolean bool) {
        CompoundNBT entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        CompoundNBT miscData = MiscProperties.getOrCreateMiscData(entityData);
        miscData.func_74757_a(DISMOUNTED_DRAGON, bool);
        entityData.func_218657_a(MISC_DATA, (INBT)miscData);
        MiscProperties.updateData(entity, entityData);
    }

    public static void setLungeTicks(LivingEntity entity, int ticks) {
        CompoundNBT entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        CompoundNBT miscData = MiscProperties.getOrCreateMiscData(entityData);
        miscData.func_74768_a(LUNGE_TICKS, ticks);
        entityData.func_218657_a(MISC_DATA, (INBT)miscData);
        MiscProperties.updateData(entity, entityData);
    }

    public static void addScepterTargetData(LivingEntity caster, LivingEntity target) {
        if (MiscProperties.isTargetedBy(caster, target) || MiscProperties.isTargeting(caster, target)) {
            return;
        }
        MiscProperties.addTargetedBy(caster, target);
        MiscProperties.addTargeting(caster, target);
    }

    public static void addTargetedBy(LivingEntity caster, LivingEntity target) {
        if (MiscProperties.isTargetedBy(caster, target)) {
            return;
        }
        CompoundNBT targetData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)target);
        CompoundNBT miscData = MiscProperties.getOrCreateMiscData(targetData);
        ListNBT scepterTargetData = MiscProperties.getOrCreateScepterTargetedBy(targetData);
        CompoundNBT targetCasterData = new CompoundNBT();
        targetCasterData.func_74768_a(SCEPTER_ENTITY_ID, caster.func_145782_y());
        scepterTargetData.add((Object)targetCasterData);
        miscData.func_218657_a(TARGETED_BY_SCEPTER_HOLDERS, (INBT)scepterTargetData);
        targetData.func_218657_a(MISC_DATA, (INBT)miscData);
        MiscProperties.updateData(target, targetData);
    }

    public static void addTargeting(LivingEntity caster, LivingEntity target) {
        if (MiscProperties.isTargeting(caster, target)) {
            return;
        }
        CompoundNBT casterData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)caster);
        CompoundNBT miscData = MiscProperties.getOrCreateMiscData(casterData);
        ListNBT scepterCasterData = MiscProperties.getOrCreateScepterTargets(casterData);
        CompoundNBT casterTargetData = new CompoundNBT();
        casterTargetData.func_74768_a(SCEPTER_ENTITY_ID, target.func_145782_y());
        scepterCasterData.add((Object)casterTargetData);
        miscData.func_218657_a(TARGETING_ENTITIES_WITH_SCEPTER, (INBT)scepterCasterData);
        casterData.func_218657_a(MISC_DATA, (INBT)miscData);
        MiscProperties.updateData(caster, casterData);
    }

    public static boolean isTargetedBy(LivingEntity caster, LivingEntity target) {
        CompoundNBT targetData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)target);
        ListNBT scepterData = MiscProperties.getOrCreateScepterTargetedBy(targetData);
        int entityId = caster.func_145782_y();
        for (INBT scepterDatum : scepterData) {
            int targetedById;
            CompoundNBT targetedBy = (CompoundNBT)scepterDatum;
            if (!targetedBy.func_74764_b(SCEPTER_ENTITY_ID) || entityId != (targetedById = targetedBy.func_74762_e(SCEPTER_ENTITY_ID))) continue;
            return true;
        }
        return false;
    }

    public static boolean isTargeting(LivingEntity caster, LivingEntity target) {
        CompoundNBT casterData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)caster);
        ListNBT scepterData = MiscProperties.getOrCreateScepterTargets(casterData);
        int entityId = target.func_145782_y();
        for (INBT scepterDatum : scepterData) {
            int targetedById;
            CompoundNBT targetedBy = (CompoundNBT)scepterDatum;
            if (!targetedBy.func_74764_b(SCEPTER_ENTITY_ID) || entityId != (targetedById = targetedBy.func_74762_e(SCEPTER_ENTITY_ID))) continue;
            return true;
        }
        return false;
    }

    public static List<LivingEntity> getTargetedBy(LivingEntity target) {
        CompoundNBT targetData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)target);
        ListNBT scepterData = MiscProperties.getOrCreateScepterTargetedBy(targetData);
        ArrayList<LivingEntity> targetedByEntities = new ArrayList<LivingEntity>();
        for (INBT scepterDatum : scepterData) {
            int targetedById;
            Entity entity;
            CompoundNBT targetedBy = (CompoundNBT)scepterDatum;
            if (!targetedBy.func_74764_b(SCEPTER_ENTITY_ID) || !((entity = target.field_70170_p.func_73045_a(targetedById = targetedBy.func_74762_e(SCEPTER_ENTITY_ID))) instanceof LivingEntity)) continue;
            targetedByEntities.add((LivingEntity)entity);
        }
        return targetedByEntities;
    }

    public static List<LivingEntity> getTargeting(LivingEntity caster) {
        CompoundNBT casterData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)caster);
        ListNBT scepterData = MiscProperties.getOrCreateScepterTargets(casterData);
        ArrayList<LivingEntity> targetingEntities = new ArrayList<LivingEntity>();
        for (INBT scepterDatum : scepterData) {
            int targetedById;
            Entity entity;
            CompoundNBT targetedBy = (CompoundNBT)scepterDatum;
            if (!targetedBy.func_74764_b(SCEPTER_ENTITY_ID) || !((entity = caster.field_70170_p.func_73045_a(targetedById = targetedBy.func_74762_e(SCEPTER_ENTITY_ID))) instanceof LivingEntity)) continue;
            targetingEntities.add((LivingEntity)entity);
        }
        return targetingEntities;
    }

    public static void removeTargetedBy(LivingEntity caster, LivingEntity target) {
        CompoundNBT targetData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)target);
        CompoundNBT miscData = MiscProperties.getOrCreateMiscData(targetData);
        ListNBT scepterData = MiscProperties.getOrCreateScepterTargetedBy(targetData);
        ListNBT updatedScepterData = new ListNBT();
        int entityId = caster.func_145782_y();
        for (INBT scepterDatum : scepterData) {
            int targetedById;
            CompoundNBT targetedBy = (CompoundNBT)scepterDatum;
            if (!targetedBy.func_74764_b(SCEPTER_ENTITY_ID) || entityId == (targetedById = targetedBy.func_74762_e(SCEPTER_ENTITY_ID))) continue;
            updatedScepterData.add((Object)targetedBy);
        }
        miscData.func_218657_a(TARGETED_BY_SCEPTER_HOLDERS, (INBT)updatedScepterData);
        targetData.func_218657_a(MISC_DATA, (INBT)miscData);
        MiscProperties.updateData(target, targetData);
    }

    public static void removeTargets(LivingEntity caster) {
        CompoundNBT casterData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)caster);
        CompoundNBT miscData = MiscProperties.getOrCreateMiscData(casterData);
        miscData.func_218657_a(TARGETED_BY_SCEPTER_HOLDERS, (INBT)new ListNBT());
        casterData.func_218657_a(MISC_DATA, (INBT)miscData);
        MiscProperties.updateData(caster, casterData);
    }

    public static void removeTarget(LivingEntity caster, LivingEntity target) {
        CompoundNBT casterData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)caster);
        CompoundNBT miscData = MiscProperties.getOrCreateMiscData(casterData);
        ListNBT scepterData = MiscProperties.getOrCreateScepterTargets(casterData);
        ListNBT updatedScepterData = new ListNBT();
        int entityId = target.func_145782_y();
        for (INBT scepterDatum : scepterData) {
            int targetedById;
            CompoundNBT targetedBy = (CompoundNBT)scepterDatum;
            if (!targetedBy.func_74764_b(SCEPTER_ENTITY_ID) || (targetedById = targetedBy.func_74762_e(SCEPTER_ENTITY_ID)) == entityId) continue;
            updatedScepterData.add((Object)targetedBy);
        }
        miscData.func_218657_a(TARGETING_ENTITIES_WITH_SCEPTER, (INBT)updatedScepterData);
        casterData.func_218657_a(MISC_DATA, (INBT)miscData);
        MiscProperties.updateData(caster, casterData);
    }

    public static void updateData(LivingEntity entity) {
        MiscProperties.updateData(entity, CitadelEntityData.getCitadelTag((LivingEntity)entity));
    }

    private static void updateData(LivingEntity entity, CompoundNBT nbt) {
        CitadelEntityData.setCitadelTag((LivingEntity)entity, (CompoundNBT)nbt);
        if (!entity.field_70170_p.func_201670_d()) {
            Citadel.sendMSGToAll((Object)new PropertiesMessage("CitadelPatreonConfig", nbt, entity.func_145782_y()));
        }
    }

    private static void createLoveParticles(LivingEntity entity) {
        if (rand.nextInt(7) == 0) {
            for (int i = 0; i < 5; ++i) {
                entity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, entity.func_226277_ct_() + (rand.nextDouble() - 0.5) * 3.0, entity.func_226278_cu_() + (rand.nextDouble() - 0.5) * 3.0, entity.func_226281_cx_() + (rand.nextDouble() - 0.5) * 3.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void tickLove(LivingEntity entity) {
        MiscProperties.setLoveTicks(entity, MiscProperties.getLoveTicks(entity) - 1);
        if (entity instanceof MobEntity) {
            ((MobEntity)entity).func_70624_b(null);
        }
        MiscProperties.createLoveParticles(entity);
    }
}

