/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client;

import com.github.alexthe666.iceandfire.CommonProxy;
import com.github.alexthe666.iceandfire.client.IafKeybindRegistry;
import com.github.alexthe666.iceandfire.client.gui.GuiMyrmexAddRoom;
import com.github.alexthe666.iceandfire.client.gui.GuiMyrmexStaff;
import com.github.alexthe666.iceandfire.client.gui.bestiary.GuiBestiary;
import com.github.alexthe666.iceandfire.client.model.ModelCopperArmor;
import com.github.alexthe666.iceandfire.client.model.ModelDeathWormArmor;
import com.github.alexthe666.iceandfire.client.model.ModelDragonsteelFireArmor;
import com.github.alexthe666.iceandfire.client.model.ModelDragonsteelIceArmor;
import com.github.alexthe666.iceandfire.client.model.ModelDragonsteelLightningArmor;
import com.github.alexthe666.iceandfire.client.model.ModelFireDragonArmor;
import com.github.alexthe666.iceandfire.client.model.ModelIceDragonArmor;
import com.github.alexthe666.iceandfire.client.model.ModelLightningDragonArmor;
import com.github.alexthe666.iceandfire.client.model.ModelSeaSerpentArmor;
import com.github.alexthe666.iceandfire.client.model.ModelSilverArmor;
import com.github.alexthe666.iceandfire.client.model.ModelTrollArmor;
import com.github.alexthe666.iceandfire.client.particle.ParticleBlood;
import com.github.alexthe666.iceandfire.client.particle.ParticleDragonFlame;
import com.github.alexthe666.iceandfire.client.particle.ParticleDragonFrost;
import com.github.alexthe666.iceandfire.client.particle.ParticleDreadPortal;
import com.github.alexthe666.iceandfire.client.particle.ParticleDreadTorch;
import com.github.alexthe666.iceandfire.client.particle.ParticleGhostAppearance;
import com.github.alexthe666.iceandfire.client.particle.ParticleHydraBreath;
import com.github.alexthe666.iceandfire.client.particle.ParticlePixieDust;
import com.github.alexthe666.iceandfire.client.particle.ParticleSerpentBubble;
import com.github.alexthe666.iceandfire.client.particle.ParticleSirenAppearance;
import com.github.alexthe666.iceandfire.client.particle.ParticleSirenMusic;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerDragonArmor;
import com.github.alexthe666.iceandfire.client.render.tile.IceAndFireTEISR;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.util.MyrmexHive;
import com.github.alexthe666.iceandfire.enums.EnumParticles;
import com.github.alexthe666.iceandfire.event.ClientEvents;
import com.github.alexthe666.iceandfire.event.PlayerRenderEvents;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="iceandfire", value={Dist.CLIENT})
public class ClientProxy
extends CommonProxy {
    private static final ModelFireDragonArmor FIRE_DRAGON_SCALE_ARMOR_MODEL = new ModelFireDragonArmor(0.5f, false);
    private static final ModelFireDragonArmor FIRE_DRAGON_SCALE_ARMOR_MODEL_LEGS = new ModelFireDragonArmor(0.2f, true);
    private static final ModelIceDragonArmor ICE_DRAGON_SCALE_ARMOR_MODEL = new ModelIceDragonArmor(0.5f, false);
    private static final ModelIceDragonArmor ICE_DRAGON_SCALE_ARMOR_MODEL_LEGS = new ModelIceDragonArmor(0.2f, true);
    private static final ModelLightningDragonArmor LIGHTNING_DRAGON_SCALE_ARMOR_MODEL = new ModelLightningDragonArmor(0.5f, false);
    private static final ModelLightningDragonArmor LIGHTNING_DRAGON_SCALE_ARMOR_MODEL_LEGS = new ModelLightningDragonArmor(0.2f, true);
    private static final ModelDeathWormArmor DEATHWORM_ARMOR_MODEL = new ModelDeathWormArmor(0.5f);
    private static final ModelDeathWormArmor DEATHWORM_ARMOR_MODEL_LEGS = new ModelDeathWormArmor(0.2f);
    private static final ModelTrollArmor TROLL_ARMOR_MODEL = new ModelTrollArmor(0.75f);
    private static final ModelTrollArmor TROLL_ARMOR_MODEL_LEGS = new ModelTrollArmor(0.35f);
    private static final ModelSeaSerpentArmor TIDE_ARMOR_MODEL = new ModelSeaSerpentArmor(0.4f);
    private static final ModelSeaSerpentArmor TIDE_ARMOR_MODEL_LEGS = new ModelSeaSerpentArmor(0.2f);
    private static final ModelDragonsteelFireArmor DRAGONSTEEL_FIRE_ARMOR_MODEL = new ModelDragonsteelFireArmor(0.4f);
    private static final ModelDragonsteelFireArmor DRAGONSTEEL_FIRE_ARMOR_MODEL_LEGS = new ModelDragonsteelFireArmor(0.2f);
    private static final ModelDragonsteelIceArmor DRAGONSTEEL_ICE_ARMOR_MODEL = new ModelDragonsteelIceArmor(0.4f);
    private static final ModelDragonsteelIceArmor DRAGONSTEEL_ICE_ARMOR_MODEL_LEGS = new ModelDragonsteelIceArmor(0.2f);
    private static final ModelDragonsteelLightningArmor DRAGONSTEEL_LIGHTNING_ARMOR_MODEL = new ModelDragonsteelLightningArmor(0.4f);
    private static final ModelDragonsteelLightningArmor DRAGONSTEEL_LIGHTNING_ARMOR_MODEL_LEGS = new ModelDragonsteelLightningArmor(0.2f);
    private static final ModelSilverArmor SILVER_ARMOR_MODEL = new ModelSilverArmor(0.5f);
    private static final ModelSilverArmor SILVER_ARMOR_MODEL_LEGS = new ModelSilverArmor(0.2f);
    private static final ModelCopperArmor COPPER_ARMOR_MODEL = new ModelCopperArmor(0.5f);
    private static final ModelCopperArmor COPPER_ARMOR_MODEL_LEGS = new ModelCopperArmor(0.2f);
    public static Set<UUID> currentDragonRiders = new HashSet<UUID>();
    private static MyrmexHive referedClientHive = null;
    private int previousViewType = 0;
    private int thirdPersonViewDragon = 0;
    private Entity referencedMob = null;
    private TileEntity referencedTE = null;

    public static MyrmexHive getReferedClientHive() {
        return referedClientHive;
    }

    private static Callable<ItemStackTileEntityRenderer> getTEISR() {
        return IceAndFireTEISR::new;
    }

    @Override
    public void setReferencedHive(MyrmexHive hive) {
        referedClientHive = hive;
    }

    @Override
    public void init() {
        IafKeybindRegistry.init();
        MinecraftForge.EVENT_BUS.register((Object)new PlayerRenderEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        this.renderEntities();
    }

    @Override
    public void postInit() {
    }

    private void renderEntities() {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnDragonParticle(EnumParticles name, double x, double y, double z, double motX, double motY, double motZ, EntityDragonBase entityDragonBase) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        SpriteTexturedParticle particle = null;
        if (name == EnumParticles.DragonFire) {
            particle = new ParticleDragonFlame(world, x, y, z, motX, motY, motZ, entityDragonBase, 0);
        } else if (name == EnumParticles.DragonIce) {
            particle = new ParticleDragonFrost(world, x, y, z, motX, motY, motZ, entityDragonBase, 0);
        }
        if (particle != null) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticle(EnumParticles name, double x, double y, double z, double motX, double motY, double motZ, float size) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        Object particle = null;
        switch (name) {
            case DragonFire: {
                particle = new ParticleDragonFlame(world, x, y, z, motX, motY, motZ, size);
                break;
            }
            case DragonIce: {
                particle = new ParticleDragonFrost(world, x, y, z, motX, motY, motZ, size);
                break;
            }
            case Dread_Torch: {
                particle = new ParticleDreadTorch(world, x, y, z, motX, motY, motZ, size);
                break;
            }
            case Dread_Portal: {
                particle = new ParticleDreadPortal(world, x, y, z, motX, motY, motZ, size);
                break;
            }
            case Blood: {
                particle = new ParticleBlood(world, x, y, z);
                break;
            }
            case If_Pixie: {
                particle = new ParticlePixieDust(world, x, y, z, (float)motX, (float)motY, (float)motZ);
                break;
            }
            case Siren_Appearance: {
                particle = new ParticleSirenAppearance(world, x, y, z, (int)motX);
                break;
            }
            case Ghost_Appearance: {
                particle = new ParticleGhostAppearance(world, x, y, z, (int)motX);
                break;
            }
            case Siren_Music: {
                particle = new ParticleSirenMusic(world, x, y, z, motX, motY, motZ, 1.0f);
                break;
            }
            case Serpent_Bubble: {
                particle = new ParticleSerpentBubble(world, x, y, z, motX, motY, motZ, 1.0f);
                break;
            }
            case Hydra: {
                particle = new ParticleHydraBreath(world, x, y, z, (float)motX, (float)motY, (float)motZ);
                break;
            }
        }
        if (particle != null) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openBestiaryGui(ItemStack book) {
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiBestiary(book));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openMyrmexStaffGui(ItemStack staff) {
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiMyrmexStaff(staff));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openMyrmexAddRoomGui(ItemStack staff, BlockPos pos, Direction facing) {
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiMyrmexAddRoom(staff, pos, facing));
    }

    @Override
    public Object getArmorModel(int armorId) {
        switch (armorId) {
            case 0: {
                return FIRE_DRAGON_SCALE_ARMOR_MODEL;
            }
            case 1: {
                return FIRE_DRAGON_SCALE_ARMOR_MODEL_LEGS;
            }
            case 2: {
                return ICE_DRAGON_SCALE_ARMOR_MODEL;
            }
            case 3: {
                return ICE_DRAGON_SCALE_ARMOR_MODEL_LEGS;
            }
            case 4: {
                return DEATHWORM_ARMOR_MODEL;
            }
            case 5: {
                return DEATHWORM_ARMOR_MODEL_LEGS;
            }
            case 6: {
                return TROLL_ARMOR_MODEL;
            }
            case 7: {
                return TROLL_ARMOR_MODEL_LEGS;
            }
            case 8: {
                return TIDE_ARMOR_MODEL;
            }
            case 9: {
                return TIDE_ARMOR_MODEL_LEGS;
            }
            case 10: {
                return DRAGONSTEEL_FIRE_ARMOR_MODEL;
            }
            case 11: {
                return DRAGONSTEEL_FIRE_ARMOR_MODEL_LEGS;
            }
            case 12: {
                return DRAGONSTEEL_ICE_ARMOR_MODEL;
            }
            case 13: {
                return DRAGONSTEEL_ICE_ARMOR_MODEL_LEGS;
            }
            case 14: {
                return SILVER_ARMOR_MODEL;
            }
            case 15: {
                return SILVER_ARMOR_MODEL_LEGS;
            }
            case 16: {
                return COPPER_ARMOR_MODEL;
            }
            case 17: {
                return COPPER_ARMOR_MODEL_LEGS;
            }
            case 18: {
                return LIGHTNING_DRAGON_SCALE_ARMOR_MODEL;
            }
            case 19: {
                return LIGHTNING_DRAGON_SCALE_ARMOR_MODEL_LEGS;
            }
            case 20: {
                return DRAGONSTEEL_LIGHTNING_ARMOR_MODEL;
            }
            case 21: {
                return DRAGONSTEEL_LIGHTNING_ARMOR_MODEL_LEGS;
            }
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Object getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    @Override
    public int getDragon3rdPersonView() {
        return this.thirdPersonViewDragon;
    }

    @Override
    public void setDragon3rdPersonView(int view) {
        this.thirdPersonViewDragon = view;
    }

    @Override
    public Object getDreadlandsRender(int i) {
        return null;
    }

    @Override
    public int getPreviousViewType() {
        return this.previousViewType;
    }

    @Override
    public void setPreviousViewType(int view) {
        this.previousViewType = view;
    }

    @Override
    public void updateDragonArmorRender(String clear) {
        LayerDragonArmor.clearCache(clear);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldSeeBestiaryContents() {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344);
    }

    @Override
    public Entity getReferencedMob() {
        return this.referencedMob;
    }

    @Override
    public void setReferencedMob(Entity dragonBase) {
        this.referencedMob = dragonBase;
    }

    @Override
    public TileEntity getRefrencedTE() {
        return this.referencedTE;
    }

    @Override
    public void setRefrencedTE(TileEntity tileEntity) {
        this.referencedTE = tileEntity;
    }

    @Override
    public Item.Properties setupISTER(Item.Properties group) {
        return group.setISTER(ClientProxy::getTEISR);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public PlayerEntity getClientSidePlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

