/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.recipe.modificationtable;

import java.util.Objects;
import mod.chiselsandbits.api.item.multistate.IMultiStateItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.item.pattern.IMultiUsePatternItem;
import mod.chiselsandbits.api.item.pattern.IPatternItem;
import mod.chiselsandbits.api.modification.operation.IModificationOperation;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.multistate.snapshot.EmptySnapshot;
import mod.chiselsandbits.registrars.ModRecipeSerializers;
import mod.chiselsandbits.registrars.ModRecipeTypes;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ModificationTableRecipe
implements IRecipe<IInventory> {
    private final IModificationOperation operation;

    public ModificationTableRecipe(IModificationOperation operation) {
        this.operation = operation;
    }

    public IModificationOperation getOperation() {
        return this.operation;
    }

    public boolean func_77569_a(IInventory inv, @NotNull World worldIn) {
        return inv.func_70301_a(0).func_77973_b() instanceof IPatternItem && !(inv.func_70301_a(0).func_77973_b() instanceof IMultiUsePatternItem);
    }

    @NotNull
    public ItemStack func_77572_b(@NotNull IInventory inv) {
        return this.getAppliedSnapshot(inv).toItemStack().toPatternStack();
    }

    @NotNull
    public ItemStack getCraftingBlockResult(IInventory inv) {
        return this.getAppliedSnapshot(inv).toItemStack().toBlockStack();
    }

    @NotNull
    public IMultiStateSnapshot getAppliedSnapshot(IInventory inv) {
        ItemStack multiStateStack = inv.func_70301_a(0);
        if (multiStateStack.func_190926_b()) {
            return EmptySnapshot.INSTANCE;
        }
        if (!(multiStateStack.func_77973_b() instanceof IMultiStateItem)) {
            return EmptySnapshot.INSTANCE;
        }
        IMultiStateItem item = (IMultiStateItem)multiStateStack.func_77973_b();
        IMultiStateItemStack multiStateItemStack = item.createItemStack(multiStateStack);
        IMultiStateSnapshot snapshot = multiStateItemStack.createSnapshot().clone();
        this.getOperation().apply(snapshot);
        return snapshot;
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent(Objects.requireNonNull(this.getOperation().getRegistryName()).func_110624_b() + ".recipes.chisel.pattern.modification." + this.getOperation().getRegistryName().func_110623_a());
    }

    public boolean func_194133_a(int width, int height) {
        return width * height > 0;
    }

    @NotNull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @NotNull
    public ResourceLocation func_199560_c() {
        return Objects.requireNonNull(this.getOperation().getRegistryName());
    }

    @NotNull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.MODIFICATION_TABLE.get();
    }

    @NotNull
    public IRecipeType<?> func_222127_g() {
        return ModRecipeTypes.MODIFICATION_TABLE;
    }
}

