/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.UpgradeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityElectricPump
extends TileEntityMekanism
implements IConfigurable {
    private static final int BASE_TICKS_REQUIRED = 19;
    public static final int HEAVY_WATER_AMOUNT = 10;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getFluid", "getFluidCapacity", "getFluidNeeded", "getFluidFilledPercentage"})
    public BasicFluidTank fluidTank;
    @Nonnull
    private FluidStack activeType = FluidStack.EMPTY;
    public int ticksRequired = 19;
    public int operatingTicks;
    private final Set<BlockPos> recurringNodes = new ObjectOpenHashSet();
    private MachineEnergyContainer<TileEntityElectricPump> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"})
    private FluidInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"})
    private OutputInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityElectricPump() {
        super(MekanismBlocks.ELECTRIC_PUMP);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIGURABLE_CAPABILITY, this));
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSide(this::getDirection);
        this.fluidTank = BasicFluidTank.output(10000, this);
        builder.addTank(this.fluidTank, RelativeSide.TOP);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer, RelativeSide.BACK);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.inputSlot = FluidInventorySlot.drain(this.fluidTank, this, 28, 20);
        builder.addSlot(this.inputSlot, RelativeSide.TOP);
        this.outputSlot = OutputInventorySlot.at(this, 28, 51);
        builder.addSlot(this.outputSlot, RelativeSide.BOTTOM);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityElectricPump)this).func_145831_w(), this, 143, 35);
        builder.addSlot(this.energySlot, RelativeSide.BACK);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        FloatingLong energyPerTick;
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.inputSlot.drainTank(this.outputSlot);
        if (MekanismUtils.canFunction(this) && (this.fluidTank.isEmpty() || 1000 <= this.fluidTank.getNeeded()) && this.energyContainer.extract(energyPerTick = this.energyContainer.getEnergyPerTick(), Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
            ++this.operatingTicks;
            if (this.operatingTicks >= this.ticksRequired) {
                this.operatingTicks = 0;
                if (this.suck()) {
                    this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                } else {
                    this.reset();
                }
            }
        }
        if (!this.fluidTank.isEmpty()) {
            FluidUtils.emit(Collections.singleton(Direction.UP), this.fluidTank, this, 256 * (1 + this.upgradeComponent.getUpgrades(Upgrade.SPEED)));
        }
    }

    private boolean suck() {
        boolean hasFilter = this.upgradeComponent.isUpgradeInstalled(Upgrade.FILTER);
        for (Direction orientation : EnumUtils.DIRECTIONS) {
            if (!this.suck(this.field_174879_c.func_177972_a(orientation), hasFilter, true)) continue;
            return true;
        }
        ArrayList<BlockPos> tempPumpList = new ArrayList<BlockPos>(this.recurringNodes);
        Collections.shuffle(tempPumpList);
        for (BlockPos tempPumpPos : tempPumpList) {
            if (this.suck(tempPumpPos, hasFilter, false)) {
                return true;
            }
            for (Direction orientation : EnumUtils.DIRECTIONS) {
                BlockPos side = tempPumpPos.func_177972_a(orientation);
                if (!(WorldUtils.distanceBetween(this.field_174879_c, side) <= (double)MekanismConfig.general.maxPumpRange.get()) || !this.suck(side, hasFilter, true)) continue;
                return true;
            }
            this.recurringNodes.remove(tempPumpPos);
        }
        return false;
    }

    private boolean suck(BlockPos pos, boolean hasFilter, boolean addRecurring) {
        BlockState blockState;
        FluidState fluidState;
        Optional<BlockState> state = WorldUtils.getBlockState((IBlockReader)this.field_145850_b, pos);
        if (state.isPresent() && !(fluidState = (blockState = state.get()).func_204520_s()).func_206888_e() && fluidState.func_206889_d()) {
            Fluid sourceFluid;
            FluidStack fluidStack;
            Block block = blockState.func_177230_c();
            if (block instanceof IFluidBlock) {
                IFluidBlock fluidBlock = (IFluidBlock)block;
                if (this.validFluid(fluidBlock.drain(this.field_145850_b, pos, IFluidHandler.FluidAction.SIMULATE), true)) {
                    this.suck(fluidBlock.drain(this.field_145850_b, pos, IFluidHandler.FluidAction.EXECUTE), pos, addRecurring);
                    return true;
                }
            } else if (block instanceof IBucketPickupHandler && this.validFluid(fluidStack = this.getOutput(sourceFluid = fluidState.func_206886_c(), hasFilter), false)) {
                if ((sourceFluid != Fluids.field_204546_a || MekanismConfig.general.pumpWaterSources.get()) && !this.validFluid(fluidStack = this.getOutput(sourceFluid = ((IBucketPickupHandler)block).func_204508_a((IWorld)this.field_145850_b, pos, blockState), hasFilter), false)) {
                    Mekanism.logger.warn("Fluid removed without successfully picking up. Fluid {} at {} in {} was valid, but after picking up was {}.", (Object)fluidState.func_206886_c(), (Object)pos, (Object)this.field_145850_b, (Object)sourceFluid);
                    return false;
                }
                this.suck(fluidStack, pos, addRecurring);
                return true;
            }
        }
        return false;
    }

    private FluidStack getOutput(Fluid sourceFluid, boolean hasFilter) {
        if (hasFilter && sourceFluid == Fluids.field_204546_a) {
            return MekanismFluids.HEAVY_WATER.getFluidStack(10);
        }
        return new FluidStack(sourceFluid, 1000);
    }

    private void suck(@Nonnull FluidStack fluidStack, BlockPos pos, boolean addRecurring) {
        this.activeType = new FluidStack(fluidStack, 1);
        if (addRecurring) {
            this.recurringNodes.add(pos);
        }
        this.fluidTank.insert(fluidStack, Action.EXECUTE, AutomationType.INTERNAL);
    }

    private boolean validFluid(@Nonnull FluidStack fluidStack, boolean recheckSize) {
        if (!fluidStack.isEmpty() && (this.activeType.isEmpty() || this.activeType.isFluidEqual(fluidStack))) {
            if (this.fluidTank.isEmpty()) {
                return true;
            }
            if (this.fluidTank.isFluidEqual(fluidStack)) {
                return !recheckSize || fluidStack.getAmount() <= this.fluidTank.getNeeded();
            }
        }
        return false;
    }

    public void reset() {
        this.activeType = FluidStack.EMPTY;
        this.recurringNodes.clear();
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("progress", this.operatingTicks);
        if (!this.activeType.isEmpty()) {
            nbtTags.func_218657_a("fluid", (INBT)this.activeType.writeToNBT(new CompoundNBT()));
        }
        if (!this.recurringNodes.isEmpty()) {
            ListNBT recurringList = new ListNBT();
            for (BlockPos nodePos : this.recurringNodes) {
                recurringList.add((Object)NBTUtil.func_186859_a((BlockPos)nodePos));
            }
            nbtTags.func_218657_a("recurringNodes", (INBT)recurringList);
        }
        return nbtTags;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        this.operatingTicks = nbtTags.func_74762_e("progress");
        if (nbtTags.func_74767_n("suckedLastOperation")) {
            this.energyContainer.extract(this.energyContainer.getEnergyPerTick(), Action.EXECUTE, AutomationType.INTERNAL);
        }
        NBTUtils.setFluidStackIfPresent(nbtTags, "fluid", fluid -> {
            this.activeType = fluid;
        });
        if (nbtTags.func_150297_b("recurringNodes", 9)) {
            ListNBT tagList = nbtTags.func_150295_c("recurringNodes", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                this.recurringNodes.add(NBTUtil.func_186861_c((CompoundNBT)tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public ActionResultType onSneakRightClick(PlayerEntity player, Direction side) {
        this.reset();
        player.func_145747_a(MekanismUtils.logFormat(MekanismLang.PUMP_RESET), Util.field_240973_b_);
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResultType onRightClick(PlayerEntity player, Direction side) {
        return ActionResultType.PASS;
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks(this, 19);
        }
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }

    @Override
    public List<ITextComponent> getInfo(Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo(this, upgrade);
    }

    public MachineEnergyContainer<TileEntityElectricPump> getEnergyContainer() {
        return this.energyContainer;
    }

    @ComputerMethod(nameOverride="reset")
    private void resetPump() throws ComputerException {
        this.validateSecurityIsPublic();
        this.reset();
    }
}

