/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.ILangEntry;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerProvider;
import mekanism.common.inventory.container.type.MekanismContainerType;
import mekanism.common.inventory.container.type.MekanismItemContainerType;
import mekanism.common.registration.WrappedRegistryObject;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.network.NetworkHooks;

public class ContainerTypeRegistryObject<CONTAINER extends Container>
extends WrappedRegistryObject<ContainerType<CONTAINER>> {
    public ContainerTypeRegistryObject(RegistryObject<ContainerType<CONTAINER>> registryObject) {
        super(registryObject);
    }

    @Nonnull
    public ContainerType<CONTAINER> getContainerType() {
        return (ContainerType)this.get();
    }

    ContainerTypeRegistryObject<CONTAINER> setRegistryObject(RegistryObject<ContainerType<CONTAINER>> registryObject) {
        this.registryObject = registryObject;
        return this;
    }

    @Nullable
    public INamedContainerProvider getProvider(ILangEntry name, Object object) {
        return this.getProvider((ITextComponent)name.translate(new Object[0]), object);
    }

    @Nullable
    public INamedContainerProvider getProvider(ITextComponent name, Object object) {
        IContainerProvider provider = null;
        ContainerType containerType = (ContainerType)this.get();
        if (containerType instanceof MekanismContainerType) {
            provider = ((MekanismContainerType)containerType).create(object);
        }
        if (provider == null) {
            Mekanism.logger.info("Unable to create container for type: {}", (Object)containerType.getRegistryName());
        }
        return provider == null ? null : new ContainerProvider(name, provider);
    }

    @Nullable
    public INamedContainerProvider getProvider(ILangEntry name, Hand hand, ItemStack stack) {
        return this.getProvider((ITextComponent)name.translate(new Object[0]), hand, stack);
    }

    @Nullable
    public INamedContainerProvider getProvider(ITextComponent name, Hand hand, ItemStack stack) {
        IContainerProvider provider = null;
        ContainerType containerType = (ContainerType)this.get();
        if (containerType instanceof MekanismItemContainerType) {
            provider = ((MekanismItemContainerType)containerType).create(hand, stack);
        }
        if (provider == null) {
            Mekanism.logger.info("Unable to create container for type: {}", (Object)containerType.getRegistryName());
        }
        return provider == null ? null : new ContainerProvider(name, provider);
    }

    public void tryOpenGui(ServerPlayerEntity player, Hand hand, ItemStack stack) {
        INamedContainerProvider provider = this.getProvider(stack.func_200301_q(), hand, stack);
        if (provider != null) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)provider, buf -> {
                buf.func_179249_a((Enum)hand);
                buf.func_150788_a(stack);
            });
        }
    }
}

