/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.common.Mekanism;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ChemicalDissolutionRecipeSerializer<RECIPE extends ChemicalDissolutionRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public ChemicalDissolutionRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray itemInput = JSONUtils.func_151202_d((JsonObject)json, (String)"itemInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"itemInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"itemInput");
        ItemStackIngredient itemIngredient = ItemStackIngredient.deserialize((JsonElement)itemInput);
        JsonArray gasInput = JSONUtils.func_151202_d((JsonObject)json, (String)"gasInput") ? JSONUtils.func_151214_t((JsonObject)json, (String)"gasInput") : JSONUtils.func_152754_s((JsonObject)json, (String)"gasInput");
        GasStackIngredient gasIngredient = GasStackIngredient.deserialize((JsonElement)gasInput);
        ChemicalStack<?> output = SerializerHelper.getBoxedChemicalStack(json, "output");
        if (output.isEmpty()) {
            throw new JsonSyntaxException("Recipe output must not be empty.");
        }
        return this.factory.create(recipeId, itemIngredient, gasIngredient, output);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        try {
            ChemicalStack output;
            ItemStackIngredient itemInput = ItemStackIngredient.read(buffer);
            GasStackIngredient gasInput = GasStackIngredient.read(buffer);
            ChemicalType chemicalType = (ChemicalType)buffer.func_179257_a(ChemicalType.class);
            if (chemicalType == ChemicalType.GAS) {
                output = GasStack.readFromPacket(buffer);
            } else if (chemicalType == ChemicalType.INFUSION) {
                output = InfusionStack.readFromPacket(buffer);
            } else if (chemicalType == ChemicalType.PIGMENT) {
                output = PigmentStack.readFromPacket(buffer);
            } else if (chemicalType == ChemicalType.SLURRY) {
                output = SlurryStack.readFromPacket(buffer);
            } else {
                throw new IllegalStateException("Unknown chemical type");
            }
            return this.factory.create(recipeId, itemInput, gasInput, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading itemstack gas to gas recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        try {
            ((ChemicalDissolutionRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing itemstack gas to gas recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends ChemicalDissolutionRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, GasStackIngredient var3, ChemicalStack<?> var4);
    }
}

