/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.Upgrade;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.MekanismLang;
import mekanism.common.item.interfaces.IUpgradeItem;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.WorldUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemUpgrade
extends Item
implements IUpgradeItem {
    private final Upgrade upgrade;

    public ItemUpgrade(Upgrade type, Item.Properties properties) {
        super(properties.func_200917_a(type.getMax()).func_208103_a(Rarity.UNCOMMON));
        this.upgrade = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed(MekanismKeyHandler.detailsKey)) {
            tooltip.add(this.getUpgradeType(stack).getDescription());
        } else {
            tooltip.add((ITextComponent)MekanismLang.HOLD_FOR_DETAILS.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.func_238171_j_()));
        }
    }

    @Override
    public Upgrade getUpgradeType(ItemStack stack) {
        return this.upgrade;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack;
        Upgrade type;
        TileComponentUpgrade component;
        IUpgradeTile upgradeTile;
        World world;
        TileEntity tile;
        PlayerEntity player = context.func_195999_j();
        if (player != null && player.func_225608_bj_() && (tile = WorldUtils.getTileEntity((IBlockReader)(world = context.func_195991_k()), context.func_195995_a())) instanceof IUpgradeTile && (upgradeTile = (IUpgradeTile)tile).supportsUpgrades() && (component = upgradeTile.getComponent()).supports(type = this.getUpgradeType(stack = context.func_195996_i()))) {
            int added;
            if (!world.field_72995_K && (added = component.addUpgrades(type, stack.func_190916_E())) > 0) {
                stack.func_190918_g(added);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

