/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.value.CachedIntValue;

public class SelectedWindowData {
    public static final SelectedWindowData UNSPECIFIED = new SelectedWindowData(WindowType.UNSPECIFIED);
    @Nonnull
    public final WindowType type;
    public final byte extraData;

    public SelectedWindowData(@Nonnull WindowType type) {
        this(type, 0);
    }

    public SelectedWindowData(@Nonnull WindowType type, byte extraData) {
        this.type = Objects.requireNonNull(type);
        this.extraData = this.type.isValid(extraData) ? extraData : (byte)0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectedWindowData other = (SelectedWindowData)o;
        return this.extraData == other.extraData && this.type == other.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.extraData});
    }

    public void updateLastPosition(int x, int y) {
        Pair<CachedIntValue, CachedIntValue> cachedPosition;
        String saveName = this.type.getSaveName(this.extraData);
        if (saveName != null && (cachedPosition = MekanismConfig.client.lastWindowPositions.get(saveName)) != null) {
            CachedIntValue cachedY;
            boolean changed = false;
            CachedIntValue cachedX = (CachedIntValue)cachedPosition.getFirst();
            if (cachedX.get() != x) {
                cachedX.set(x);
                changed = true;
            }
            if ((cachedY = (CachedIntValue)cachedPosition.getSecond()).get() != y) {
                cachedY.set(y);
                changed = true;
            }
            if (changed) {
                MekanismConfig.client.getConfigSpec().save();
            }
        }
    }

    public Pair<Integer, Integer> getLastPosition() {
        Pair<CachedIntValue, CachedIntValue> cachedPosition;
        String saveName = this.type.getSaveName(this.extraData);
        if (saveName != null && (cachedPosition = MekanismConfig.client.lastWindowPositions.get(saveName)) != null) {
            return Pair.of((Object)((CachedIntValue)cachedPosition.getFirst()).get(), (Object)((CachedIntValue)cachedPosition.getSecond()).get());
        }
        return Pair.of((Object)Integer.MAX_VALUE, (Object)Integer.MAX_VALUE);
    }

    public static enum WindowType {
        COLOR("color"),
        CONFIRMATION("confirmation"),
        CRAFTING("crafting", 3),
        MEKA_SUIT_HELMET("mekaSuitHelmet"),
        RENAME("rename"),
        SKIN_SELECT("skinSelect"),
        SIDE_CONFIG("sideConfig"),
        TRANSPORTER_CONFIG("transporterConfig"),
        UPGRADE("upgrade"),
        UNSPECIFIED(null);

        @Nullable
        private final String saveName;
        private final byte maxData;

        private WindowType(String saveName) {
            this(saveName, 1);
        }

        private WindowType(String saveName, byte maxData) {
            this.saveName = saveName;
            this.maxData = maxData;
        }

        @Nullable
        String getSaveName(byte extraData) {
            return this.maxData == 1 ? this.saveName : this.saveName + extraData;
        }

        public List<String> getSavePaths() {
            if (this.saveName == null) {
                return Collections.emptyList();
            }
            if (this.maxData == 1) {
                return Collections.singletonList(this.saveName);
            }
            ArrayList<String> savePaths = new ArrayList<String>();
            for (int i = 0; i < this.maxData; ++i) {
                savePaths.add(this.saveName + i);
            }
            return savePaths;
        }

        public boolean isValid(byte extraData) {
            return extraData >= 0 && extraData < this.maxData;
        }
    }
}

