/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.DataHandlerUtils;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NonNull;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IRobitSkinProvider;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackToItemStackCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.api.robit.IRobit;
import mekanism.api.robit.RobitSkin;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.entity.ai.RobitAIFollow;
import mekanism.common.entity.ai.RobitAIPickup;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemRobit;
import mekanism.common.lib.security.ISecurityObject;
import mekanism.common.lib.security.SecurityMode;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.recipe.lookup.monitor.RecipeCacheLookupMonitor;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.registries.MekanismDamageSource;
import mekanism.common.registries.MekanismDataSerializers;
import mekanism.common.registries.MekanismEntityTypes;
import mekanism.common.registries.MekanismItems;
import mekanism.common.registries.MekanismRobitSkins;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.tile.interfaces.ISustainedInventory;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.ItemHandlerHelper;

public class EntityRobit
extends CreatureEntity
implements IRobit,
IMekanismInventory,
ISustainedInventory,
ISecurityObject,
IMekanismStrictEnergyHandler,
ISingleRecipeLookupHandler.ItemRecipeLookupHandler<ItemStackToItemStackRecipe> {
    public static final ModelProperty<ResourceLocation> SKIN_TEXTURE_PROPERTY = new ModelProperty();
    private static final TicketType<Integer> ROBIT_CHUNK_UNLOAD = TicketType.func_223183_a((String)"robit_chunk_unload", Integer::compareTo, (int)20);
    private static final DataParameter<UUID> OWNER_UUID = EntityRobit.define(MekanismDataSerializers.UUID.getSerializer());
    private static final DataParameter<String> OWNER_NAME = EntityRobit.define(DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> FOLLOW = EntityRobit.define(DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DROP_PICKUP = EntityRobit.define(DataSerializers.field_187198_h);
    private static final DataParameter<RobitSkin> SKIN = EntityRobit.define(MekanismDataSerializers.getRegistryEntrySerializer());
    public static final FloatingLong MAX_ENERGY = FloatingLong.createConst(100000L);
    private static final FloatingLong DISTANCE_MULTIPLIER = FloatingLong.createConst(1.5);
    private static final int ticksRequired = 100;
    private SecurityMode securityMode = SecurityMode.PUBLIC;
    public Coord4D homeLocation;
    private int lastTextureUpdate;
    private int textureIndex;
    private int progress;
    private final Set<PlayerEntity> playersUsing = new ObjectOpenHashSet();
    private final RecipeCacheLookupMonitor<ItemStackToItemStackRecipe> recipeCacheLookupMonitor;
    private final IInputHandler<@NonNull ItemStack> inputHandler;
    private final IOutputHandler<@NonNull ItemStack> outputHandler;
    @Nonnull
    private final List<IInventorySlot> inventorySlots;
    @Nonnull
    private final List<IInventorySlot> mainContainerSlots;
    @Nonnull
    private final List<IInventorySlot> smeltingContainerSlots;
    @Nonnull
    private final List<IInventorySlot> inventoryContainerSlots;
    private final EnergyInventorySlot energySlot;
    private final InputInventorySlot smeltingInputSlot;
    private final OutputInventorySlot smeltingOutputSlot;
    private final List<IEnergyContainer> energyContainers;
    private final BasicEnergyContainer energyContainer;

    private static <T> DataParameter<T> define(IDataSerializer<T> dataSerializer) {
        return EntityDataManager.func_187226_a(EntityRobit.class, dataSerializer);
    }

    public EntityRobit(EntityType<EntityRobit> type, World world) {
        super(type, world);
        this.func_70661_as().func_212239_d(false);
        this.func_174805_g(true);
        this.recipeCacheLookupMonitor = new RecipeCacheLookupMonitor<ItemStackToItemStackRecipe>(this);
        this.energyContainer = BasicEnergyContainer.input(MAX_ENERGY, this);
        this.energyContainers = Collections.singletonList(this.energyContainer);
        this.inventorySlots = new ArrayList<IInventorySlot>();
        this.inventoryContainerSlots = new ArrayList<IInventorySlot>();
        for (int slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                BasicInventorySlot slot = BasicInventorySlot.at(this, 8 + slotX * 18, 18 + slotY * 18);
                this.inventorySlots.add(slot);
                this.inventoryContainerSlots.add(slot);
            }
        }
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((EntityRobit)this).func_130014_f_(), this, 153, 17);
        this.inventorySlots.add(this.energySlot);
        this.smeltingInputSlot = InputInventorySlot.at(this::containsRecipe, this.recipeCacheLookupMonitor, 51, 35);
        this.inventorySlots.add(this.smeltingInputSlot);
        this.smeltingOutputSlot = OutputInventorySlot.at(this, 116, 35);
        this.inventorySlots.add(this.smeltingOutputSlot);
        this.mainContainerSlots = Collections.singletonList(this.energySlot);
        this.smeltingContainerSlots = Arrays.asList(this.smeltingInputSlot, this.smeltingOutputSlot);
        this.inputHandler = InputHelper.getInputHandler(this.smeltingInputSlot);
        this.outputHandler = OutputHelper.getOutputHandler(this.smeltingOutputSlot);
    }

    @Nullable
    public static EntityRobit create(World world, double x, double y, double z) {
        EntityRobit robit = (EntityRobit)((EntityType)MekanismEntityTypes.ROBIT.get()).func_200721_a(world);
        if (robit == null) {
            return null;
        }
        robit.func_70107_b(x, y, z);
        robit.field_70169_q = x;
        robit.field_70167_r = y;
        robit.field_70166_s = z;
        return robit;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new RobitAIPickup(this, 1.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new RobitAIFollow(this, 1.0f, 4.0f, 2.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new SwimGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute getDefaultAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 1.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UUID, (Object)Mekanism.gameProfile.getId());
        this.field_70180_af.func_187214_a(OWNER_NAME, (Object)"");
        this.field_70180_af.func_187214_a(FOLLOW, (Object)false);
        this.field_70180_af.func_187214_a(DROP_PICKUP, (Object)false);
        this.field_70180_af.func_187214_a(SKIN, MekanismRobitSkins.BASE.get());
    }

    private FloatingLong getRoundedTravelEnergy() {
        return DISTANCE_MULTIPLIER.multiply(Math.sqrt(this.func_70092_e(this.field_70169_q, this.field_70167_r, this.field_70166_s)));
    }

    public void onRemovedFromWorld() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K && this.getFollowing() && this.getOwner() != null) {
            ((ServerWorld)this.field_70170_p).func_72863_F().func_217228_a(ROBIT_CHUNK_UNLOAD, new ChunkPos(this.func_233580_cy_()), 2, (Object)this.func_145782_y());
        }
        super.onRemovedFromWorld();
    }

    public void func_70030_z() {
        PlayerEntity owner;
        if (!this.field_70170_p.field_72995_K && this.getFollowing() && (owner = this.getOwner()) != null && this.func_70068_e((Entity)owner) > 4.0 && !this.func_70661_as().func_75500_f() && !this.energyContainer.isEmpty()) {
            this.energyContainer.extract(this.getRoundedTravelEnergy(), Action.EXECUTE, AutomationType.INTERNAL);
        }
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            BlockPos homePos;
            ServerWorld serverWorld;
            if (this.getDropPickup()) {
                this.collectItems();
            }
            if (this.homeLocation == null) {
                this.func_70106_y();
                return;
            }
            if (this.field_70173_aa % 20 == 0 && WorldUtils.isBlockLoaded((IBlockReader)(serverWorld = ServerLifecycleHooks.getCurrentServer().func_71218_a(this.homeLocation.dimension)), homePos = this.homeLocation.getPos()) && WorldUtils.getTileEntity(TileEntityChargepad.class, (IBlockReader)serverWorld, homePos) == null) {
                this.drop();
                this.func_70106_y();
            }
            if (this.energyContainer.isEmpty() && !this.isOnChargepad()) {
                this.goHome();
            }
            this.energySlot.fillContainerOrConvert();
            this.recipeCacheLookupMonitor.updateAndProcess();
        }
    }

    public boolean isItemValid(ItemEntity item) {
        return item.func_70089_S() && !item.func_174874_s() && !(item.func_92059_d().func_77973_b() instanceof ItemRobit);
    }

    private void collectItems() {
        List items = this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(1.5, 1.5, 1.5));
        if (!items.isEmpty()) {
            block0: for (ItemEntity item : items) {
                if (!this.isItemValid(item)) continue;
                for (IInventorySlot slot : this.inventoryContainerSlots) {
                    if (slot.isEmpty()) {
                        slot.setStack(item.func_92059_d());
                        this.func_71001_a((Entity)item, item.func_92059_d().func_190916_E());
                        item.func_70106_y();
                        this.func_184185_a(SoundEvents.field_187638_cR, 1.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                        continue block0;
                    }
                    ItemStack itemStack = slot.getStack();
                    int maxSize = slot.getLimit(itemStack);
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)itemStack, (ItemStack)item.func_92059_d()) || itemStack.func_190916_E() >= maxSize) continue;
                    int needed = maxSize - itemStack.func_190916_E();
                    int toAdd = Math.min(needed, item.func_92059_d().func_190916_E());
                    MekanismUtils.logMismatchedStackSize(slot.growStack(toAdd, Action.EXECUTE), toAdd);
                    item.func_92059_d().func_190918_g(toAdd);
                    this.func_71001_a((Entity)item, toAdd);
                    if (item.func_92059_d().func_190926_b()) {
                        item.func_70106_y();
                    }
                    this.func_184185_a(SoundEvents.field_187638_cR, 1.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    continue block0;
                }
            }
        }
    }

    public void goHome() {
        if (this.field_70170_p.func_201670_d()) {
            return;
        }
        this.setFollowing(false);
        if (this.field_70170_p.func_234923_W_() == this.homeLocation.dimension) {
            this.func_213293_j(0.0, 0.0, 0.0);
            this.func_70634_a((double)this.homeLocation.getX() + 0.5, (double)this.homeLocation.getY() + 0.3, (double)this.homeLocation.getZ() + 0.5);
        } else {
            ServerWorld newWorld = ((ServerWorld)this.field_70170_p).func_73046_m().func_71218_a(this.homeLocation.dimension);
            if (newWorld != null) {
                final Vector3d destination = new Vector3d((double)this.homeLocation.getX() + 0.5, (double)this.homeLocation.getY() + 0.3, (double)this.homeLocation.getZ() + 0.5);
                this.changeDimension(newWorld, new ITeleporter(){

                    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                        return repositionEntity.apply(false);
                    }

                    public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
                        return new PortalInfo(destination, Vector3d.field_186680_a, entity.field_70177_z, entity.field_70125_A);
                    }

                    public boolean playTeleportSound(ServerPlayerEntity player, ServerWorld sourceWorld, ServerWorld destWorld) {
                        return false;
                    }
                });
            }
        }
    }

    private boolean isOnChargepad() {
        return WorldUtils.getTileEntity(TileEntityChargepad.class, (IBlockReader)this.field_70170_p, this.func_233580_cy_()) != null;
    }

    @Nonnull
    public ActionResultType func_184199_a(PlayerEntity player, @Nonnull Vector3d vec, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator) {
                if (!this.field_70170_p.field_72995_K) {
                    this.drop();
                }
                this.func_70106_y();
                player.func_184609_a(hand);
                return ActionResultType.SUCCESS;
            }
        } else {
            INamedContainerProvider provider;
            if (!SecurityUtils.canAccess(player, this)) {
                if (!this.field_70170_p.field_72995_K) {
                    SecurityUtils.displayNoAccess(player);
                }
                return ActionResultType.FAIL;
            }
            if (!this.field_70170_p.field_72995_K && (provider = MekanismContainerTypes.MAIN_ROBIT.getProvider(MekanismLang.ROBIT, (Object)this)) != null) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, buf -> buf.func_150787_b(this.func_145782_y()));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private ItemStack getItemVariant() {
        IStrictEnergyHandler energyHandlerItem;
        ItemStack stack = MekanismItems.ROBIT.getItemStack();
        Optional capability = stack.getCapability(Capabilities.STRICT_ENERGY_CAPABILITY).resolve();
        if (capability.isPresent() && (energyHandlerItem = (IStrictEnergyHandler)capability.get()).getEnergyContainerCount() > 0) {
            energyHandlerItem.setEnergy(0, this.energyContainer.getEnergy());
        }
        ItemRobit item = (ItemRobit)stack.func_77973_b();
        item.setInventory(this.getInventory(new Object[0]), new Object[]{stack});
        item.setName(stack, this.func_200200_C_());
        item.setOwnerUUID(stack, this.getOwnerUUID());
        item.setSecurity(stack, this.getSecurityMode());
        item.setSkin(stack, this.getSkin());
        return stack;
    }

    public void drop() {
        ItemEntity entityItem = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.3, this.func_226281_cx_(), this.getItemVariant());
        entityItem.func_213293_j(0.0, this.field_70146_Z.nextGaussian() * (double)0.05f + (double)0.2f, 0.0);
        this.field_70170_p.func_217376_c((Entity)entityItem);
    }

    public double getScaledProgress() {
        return (double)this.getOperatingTicks() / 100.0;
    }

    public int getOperatingTicks() {
        return this.progress;
    }

    @Override
    public int getSavedOperatingTicks(int cacheIndex) {
        return this.getOperatingTicks();
    }

    public void func_213281_b(@Nonnull CompoundNBT nbtTags) {
        super.func_213281_b(nbtTags);
        nbtTags.func_186854_a("owner", this.getOwnerUUID());
        nbtTags.func_74768_a("securityMode", this.securityMode.ordinal());
        nbtTags.func_74757_a("follow", this.getFollowing());
        nbtTags.func_74757_a("dropPickup", this.getDropPickup());
        if (this.homeLocation != null) {
            this.homeLocation.write(nbtTags);
        }
        nbtTags.func_218657_a("Items", (INBT)DataHandlerUtils.writeContainers(this.getInventorySlots(null)));
        nbtTags.func_218657_a("EnergyContainers", (INBT)DataHandlerUtils.writeContainers(this.getEnergyContainers(null)));
        nbtTags.func_74768_a("progress", this.getOperatingTicks());
        nbtTags.func_74778_a("skin", this.getSkin().getRegistryName().toString());
    }

    public void func_70037_a(@Nonnull CompoundNBT nbtTags) {
        super.func_70037_a(nbtTags);
        NBTUtils.setUUIDIfPresent(nbtTags, "owner", this::setOwnerUUID);
        NBTUtils.setEnumIfPresent(nbtTags, "securityMode", SecurityMode::byIndexStatic, mode -> {
            this.securityMode = mode;
        });
        this.setFollowing(nbtTags.func_74767_n("follow"));
        this.setDropPickup(nbtTags.func_74767_n("dropPickup"));
        this.homeLocation = Coord4D.read(nbtTags);
        DataHandlerUtils.readContainers(this.getInventorySlots(null), nbtTags.func_150295_c("Items", 10));
        DataHandlerUtils.readContainers(this.getEnergyContainers(null), nbtTags.func_150295_c("EnergyContainers", 10));
        this.progress = nbtTags.func_74762_e("progress");
        NBTUtils.setRegistryEntryIfPresentElse(nbtTags, "skin", MekanismAPI.robitSkinRegistry(), skin -> this.setSkin((IRobitSkinProvider)skin, null), () -> this.setSkin(MekanismRobitSkins.BASE, null));
    }

    public boolean func_180431_b(@Nonnull DamageSource source) {
        return source == MekanismDamageSource.RADIATION || super.func_180431_b(source);
    }

    protected void func_70665_d(@Nonnull DamageSource damageSource, float amount) {
        if ((amount = ForgeHooks.onLivingHurt((LivingEntity)this, (DamageSource)damageSource, (float)amount)) <= 0.0f) {
            return;
        }
        amount = this.func_70655_b(damageSource, amount);
        amount = this.func_70672_c(damageSource, amount);
        if (damageSource == DamageSource.field_76379_h) {
            amount /= 2.0f;
        }
        this.energyContainer.extract(FloatingLong.create(1000.0f * amount), Action.EXECUTE, AutomationType.INTERNAL);
        this.func_110142_aN().func_94547_a(damageSource, this.func_110143_aJ(), amount);
    }

    protected void func_70609_aI() {
    }

    public void setHome(Coord4D home) {
        this.homeLocation = home;
    }

    public boolean func_70104_M() {
        return !this.energyContainer.isEmpty();
    }

    public PlayerEntity getOwner() {
        return this.field_70170_p.func_217371_b(this.getOwnerUUID());
    }

    @Override
    @Nonnull
    public String getOwnerName() {
        return (String)this.field_70180_af.func_187225_a(OWNER_NAME);
    }

    @Override
    @Nonnull
    public UUID getOwnerUUID() {
        return (UUID)this.field_70180_af.func_187225_a(OWNER_UUID);
    }

    @Override
    public SecurityMode getSecurityMode() {
        return this.securityMode;
    }

    @Override
    public void setSecurityMode(SecurityMode mode) {
        if (this.securityMode != mode) {
            SecurityMode old = this.securityMode;
            this.securityMode = mode;
            this.onSecurityChanged(old, this.securityMode);
        }
    }

    @Override
    public void onSecurityChanged(SecurityMode old, SecurityMode mode) {
        if (old != mode && (old == SecurityMode.PUBLIC || old == SecurityMode.TRUSTED && mode == SecurityMode.PRIVATE) && !this.playersUsing.isEmpty()) {
            for (PlayerEntity player : new ObjectOpenHashSet(this.playersUsing)) {
                if (SecurityUtils.canAccess(player, this)) continue;
                player.func_71053_j();
            }
        }
    }

    public void open(PlayerEntity player) {
        this.playersUsing.add(player);
    }

    public void close(PlayerEntity player) {
        this.playersUsing.remove(player);
    }

    public void setOwnerUUID(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UUID, (Object)uuid);
        this.field_70180_af.func_187227_b(OWNER_NAME, (Object)MekanismUtils.getLastKnownUsername(uuid));
    }

    public boolean getFollowing() {
        return (Boolean)this.field_70180_af.func_187225_a(FOLLOW);
    }

    public void setFollowing(boolean follow) {
        this.field_70180_af.func_187227_b(FOLLOW, (Object)follow);
    }

    public boolean getDropPickup() {
        return (Boolean)this.field_70180_af.func_187225_a(DROP_PICKUP);
    }

    public void setDropPickup(boolean pickup) {
        this.field_70180_af.func_187227_b(DROP_PICKUP, (Object)pickup);
    }

    @Override
    public void setInventory(ListNBT nbtTags, Object ... data) {
        if (nbtTags != null && !nbtTags.isEmpty()) {
            DataHandlerUtils.readContainers(this.getInventorySlots(null), nbtTags);
        }
    }

    @Override
    public ListNBT getInventory(Object ... data) {
        return DataHandlerUtils.writeContainers(this.getInventorySlots(null));
    }

    @Override
    @Nonnull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return this.hasInventory() ? this.inventorySlots : Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.canHandleEnergy() ? this.energyContainers : Collections.emptyList();
    }

    @Override
    public void onContentsChanged() {
    }

    @Nonnull
    public List<IInventorySlot> getContainerInventorySlots(@Nonnull ContainerType<?> containerType) {
        if (!this.hasInventory()) {
            return Collections.emptyList();
        }
        if (containerType == MekanismContainerTypes.INVENTORY_ROBIT.getContainerType()) {
            return this.inventoryContainerSlots;
        }
        if (containerType == MekanismContainerTypes.MAIN_ROBIT.getContainerType()) {
            return this.mainContainerSlots;
        }
        if (containerType == MekanismContainerTypes.SMELTING_ROBIT.getContainerType()) {
            return this.smeltingContainerSlots;
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public MekanismRecipeType<ItemStackToItemStackRecipe, InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>> getRecipeType() {
        return MekanismRecipeType.SMELTING;
    }

    @Override
    @Nullable
    public ItemStackToItemStackRecipe getRecipe(int cacheIndex) {
        return (ItemStackToItemStackRecipe)this.findFirstRecipe(this.inputHandler);
    }

    public IEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.getItemVariant();
    }

    @Override
    @Nonnull
    public CachedRecipe<ItemStackToItemStackRecipe> createNewCachedRecipe(@Nonnull ItemStackToItemStackRecipe recipe, int cacheIndex) {
        return new ItemStackToItemStackCachedRecipe(recipe, this.inputHandler, this.outputHandler).setEnergyRequirements(MekanismConfig.usage.energizedSmelter, this.energyContainer).setRequiredTicks(() -> 100).setOnFinish(this::onContentsChanged).setOperatingTicksChanged(operatingTicks -> {
            this.progress = operatingTicks;
        });
    }

    public void addContainerTrackers(MekanismContainer container) {
        ContainerType containerType = container.func_216957_a();
        container.track(SyncableEnum.create(SecurityMode::byIndexStatic, SecurityMode.PUBLIC, this::getSecurityMode, this::setSecurityMode));
        if (containerType == MekanismContainerTypes.MAIN_ROBIT.getContainerType()) {
            container.track(SyncableFloatingLong.create(this.energyContainer::getEnergy, this.energyContainer::setEnergy));
        } else if (containerType == MekanismContainerTypes.SMELTING_ROBIT.getContainerType()) {
            container.track(SyncableInt.create(() -> this.progress, value -> {
                this.progress = value;
            }));
        }
    }

    public IWorldPosCallable getWorldPosCallable() {
        return new IWorldPosCallable(){

            @Nonnull
            public <T> Optional<T> func_221484_a(@Nonnull BiFunction<World, BlockPos, T> worldBlockPosTBiFunction) {
                return Optional.ofNullable(worldBlockPosTBiFunction.apply(EntityRobit.this.func_130014_f_(), EntityRobit.this.func_233580_cy_()));
            }
        };
    }

    @Override
    @Nonnull
    public RobitSkin getSkin() {
        return (RobitSkin)this.field_70180_af.func_187225_a(SKIN);
    }

    @Override
    public boolean setSkin(@Nonnull IRobitSkinProvider skinProvider, @Nullable PlayerEntity player) {
        Objects.requireNonNull(skinProvider, "Robit skin cannot be null.");
        RobitSkin skin = skinProvider.getSkin();
        if (!(player == null || SecurityUtils.canAccess(player, this) && skin.isUnlocked(player))) {
            return false;
        }
        this.field_70180_af.func_187227_b(SKIN, (Object)skin);
        return true;
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(SKIN_TEXTURE_PROPERTY, (Object)this.getModelTexture()).build();
    }

    private ResourceLocation getModelTexture() {
        RobitSkin skin = this.getSkin();
        List<ResourceLocation> textures = skin.getTextures();
        if (textures.isEmpty()) {
            this.textureIndex = 0;
            Mekanism.logger.error("Robit Skin: {}, has no textures; resetting skin to base.", (Object)skin.getRegistryName());
            this.setSkin(MekanismRobitSkins.BASE, null);
            if (this.getSkin().getTextures().isEmpty()) {
                throw new IllegalStateException("Base robit skin has no textures defined.");
            }
            return this.getModelTexture();
        }
        int textureCount = textures.size();
        if (textureCount == 1) {
            this.textureIndex = 0;
        } else {
            if (this.lastTextureUpdate < this.field_70173_aa) {
                this.lastTextureUpdate = this.field_70173_aa;
                if (Math.abs(this.func_226277_ct_() - this.field_70169_q) + Math.abs(this.func_226281_cx_() - this.field_70166_s) > 0.001 && this.field_70173_aa % 3 == 0) {
                    ++this.textureIndex;
                }
            }
            if (this.textureIndex >= textureCount) {
                this.textureIndex %= textureCount;
            }
        }
        return textures.get(this.textureIndex);
    }
}

