/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class TransporterManager {
    private static final Map<Coord4D, Set<TransporterStack>> flowingStacks = new Object2ObjectOpenHashMap();

    private TransporterManager() {
    }

    public static void reset() {
        flowingStacks.clear();
    }

    public static void add(World world, TransporterStack stack) {
        flowingStacks.computeIfAbsent(new Coord4D(stack.getDest(), world), k -> new ObjectOpenHashSet()).add(stack);
    }

    public static void remove(World world, TransporterStack stack) {
        if (stack.hasPath() && stack.getPathType() != TransporterStack.Path.NONE) {
            flowingStacks.get(new Coord4D(stack.getDest(), world)).remove(stack);
        }
    }

    public static boolean didEmit(ItemStack stack, ItemStack returned) {
        return returned.func_190926_b() || returned.func_190916_E() < stack.func_190916_E();
    }

    public static ItemStack getToUse(ItemStack stack, ItemStack returned) {
        return returned.func_190926_b() ? stack : StackUtils.size(stack, stack.func_190916_E() - returned.func_190916_E());
    }

    private static int simulateInsert(IItemHandler handler, InventoryInfo inventoryInfo, ItemStack stack, int count, boolean inFlight) {
        int maxStackSize = stack.func_77976_d();
        for (int slot = 0; slot < inventoryInfo.slots && count != 0; ++slot) {
            int max = inventoryInfo.getSlotLimit(handler, slot);
            if (max == 0 || !handler.isItemValid(slot, stack)) continue;
            int destCount = inventoryInfo.stackSizes[slot];
            int mergedCount = count + destCount;
            int toAccept = count;
            boolean needsSimulation = false;
            if (destCount > 0) {
                if (!InventoryUtils.areItemsStackable(inventoryInfo.inventory[slot], stack) || destCount >= max) continue;
                if (max > maxStackSize && mergedCount > maxStackSize) {
                    needsSimulation = true;
                    if (count <= maxStackSize) {
                        if (stack.func_190916_E() <= maxStackSize) {
                            stack = StackUtils.size(stack, maxStackSize + 1);
                        }
                        toAccept = stack.func_190916_E();
                    } else if (stack.func_190916_E() <= maxStackSize) {
                        stack = StackUtils.size(stack, count);
                    }
                } else if (!inFlight) {
                    needsSimulation = true;
                }
            } else {
                needsSimulation = true;
            }
            if (needsSimulation) {
                ItemStack simulatedRemainder = handler.insertItem(slot, stack, true);
                int accepted = stack.func_190916_E() - simulatedRemainder.func_190916_E();
                if (accepted == 0) continue;
                if (accepted < toAccept) {
                    max = inventoryInfo.actualStackSizes[slot] + accepted;
                }
                if (destCount == 0) {
                    ((InventoryInfo)inventoryInfo).inventory[slot] = stack;
                }
            }
            if (mergedCount > max) {
                ((InventoryInfo)inventoryInfo).stackSizes[slot] = max;
                count = mergedCount - max;
                continue;
            }
            ((InventoryInfo)inventoryInfo).stackSizes[slot] = mergedCount;
            return 0;
        }
        return count;
    }

    public static TransitRequest.TransitResponse getPredictedInsert(Coord4D position, Direction side, IItemHandler handler, TransitRequest request) {
        InventoryInfo inventoryInfo = new InventoryInfo(handler);
        Set<TransporterStack> transporterStacks = flowingStacks.get(position);
        if (transporterStacks != null) {
            for (TransporterStack stack : transporterStacks) {
                int numLeftOver;
                if (stack == null || stack.getPathType() == TransporterStack.Path.NONE || (numLeftOver = TransporterManager.simulateInsert(handler, inventoryInfo, stack.itemStack, stack.itemStack.func_190916_E(), true)) <= 0 || numLeftOver == stack.itemStack.func_190916_E() && side != stack.getSideOfDest()) continue;
                return request.getEmptyResponse();
            }
        }
        return TransporterManager.getPredictedInsert(inventoryInfo, handler, request);
    }

    private static TransitRequest.TransitResponse getPredictedInsert(InventoryInfo inventoryInfo, IItemHandler handler, TransitRequest request) {
        for (TransitRequest.ItemData itemData : request.getItemData()) {
            int numToSend;
            ItemStack stack = itemData.getStack();
            int numLeftOver = TransporterManager.simulateInsert(handler, inventoryInfo, stack, numToSend = itemData.getTotalCount(), false);
            if (numLeftOver == numToSend) continue;
            return request.createResponse(StackUtils.size(stack, numToSend - numLeftOver), itemData);
        }
        return request.getEmptyResponse();
    }

    public static TransitRequest.TransitResponse getPredictedInsert(IItemHandler handler, TransitRequest request) {
        return TransporterManager.getPredictedInsert(new InventoryInfo(handler), handler, request);
    }

    private static class InventoryInfo {
        private final ItemStack[] inventory;
        private final int[] stackSizes;
        private final int[] actualStackSizes;
        private final int[] slotLimits;
        private final int slots;

        public InventoryInfo(IItemHandler handler) {
            this.slots = handler.getSlots();
            this.inventory = new ItemStack[this.slots];
            this.stackSizes = new int[this.slots];
            this.actualStackSizes = new int[this.slots];
            this.slotLimits = new int[this.slots];
            Arrays.fill(this.slotLimits, -1);
            for (int i = 0; i < this.slots; ++i) {
                ItemStack stack;
                this.inventory[i] = stack = handler.getStackInSlot(i);
                this.actualStackSizes[i] = this.stackSizes[i] = stack.func_190916_E();
            }
        }

        public int getSlotLimit(IItemHandler handler, int slot) {
            int limit = this.slotLimits[slot];
            if (limit == -1) {
                this.slotLimits[slot] = handler.getSlotLimit(slot);
                return this.slotLimits[slot];
            }
            return limit;
        }
    }
}

