/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.armor;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.client.model.BaseModelCache;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.armor.CustomArmor;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import mekanism.client.render.lib.effect.BoltRenderer;
import mekanism.client.render.obj.TransmitterBakedModel;
import mekanism.common.Mekanism;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.gear.ItemMekaTool;
import mekanism.common.lib.effect.BoltEffect;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import org.apache.commons.lang3.tuple.Pair;

public class MekaSuitArmor
extends CustomArmor {
    private static final String LED_TAG = "led";
    private static final String INACTIVE_TAG = "inactive_";
    private static final String OVERRIDDEN_TAG = "override_";
    private static final String EXCLUSIVE_TAG = "excl_";
    private static final String SHARED_TAG = "shared_";
    private static final String GLASS_TAG = "glass";
    public static final MekaSuitArmor HELMET = new MekaSuitArmor(0.5f, EquipmentSlotType.HEAD, EquipmentSlotType.CHEST);
    public static final MekaSuitArmor BODYARMOR = new MekaSuitArmor(0.5f, EquipmentSlotType.CHEST, EquipmentSlotType.HEAD);
    public static final MekaSuitArmor PANTS = new MekaSuitArmor(0.5f, EquipmentSlotType.LEGS, EquipmentSlotType.FEET);
    public static final MekaSuitArmor BOOTS = new MekaSuitArmor(0.5f, EquipmentSlotType.FEET, EquipmentSlotType.LEGS);
    private static final Set<BaseModelCache.ModelData> specialModels = Sets.newHashSet((Object[])new BaseModelCache.ModelData[]{MekanismModelCache.INSTANCE.MEKASUIT_MODULES});
    private static final Table<EquipmentSlotType, ModuleData<?>, ModuleModelSpec> moduleModelSpec = HashBasedTable.create();
    private static final Map<UUID, BoltRenderer> boltRenderMap = new Object2ObjectOpenHashMap();
    private static final QuadTransformation BASE_TRANSFORM;
    private final LoadingCache<TransmitterBakedModel.QuickHash, ArmorQuads> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<TransmitterBakedModel.QuickHash, ArmorQuads>(){

        public ArmorQuads load(@Nonnull TransmitterBakedModel.QuickHash key) {
            return MekaSuitArmor.this.createQuads((Object2BooleanMap<ModuleModelSpec>)((Object2BooleanMap)key.get()[0]), (Set)key.get()[1], (Boolean)key.get()[2], (Boolean)key.get()[3]);
        }
    });
    private final EquipmentSlotType type;
    private final EquipmentSlotType adjacentType;

    private MekaSuitArmor(float size, EquipmentSlotType type, EquipmentSlotType adjacentType) {
        super(size);
        this.type = type;
        this.adjacentType = adjacentType;
        MekanismModelCache.INSTANCE.reloadCallback(() -> this.cache.invalidateAll());
    }

    public void renderArm(@Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light, int overlayLight, boolean hasEffect, LivingEntity entity, boolean rightHand) {
        ModelPos armPos = rightHand ? ModelPos.RIGHT_ARM : ModelPos.LEFT_ARM;
        ArmorQuads armorQuads = (ArmorQuads)this.cache.getUnchecked((Object)this.key(entity));
        boolean hasOpaqueArm = armorQuads.getOpaqueMap().containsKey((Object)armPos);
        boolean hasTransparentArm = armorQuads.getTransparentMap().containsKey((Object)armPos);
        if (hasOpaqueArm || hasTransparentArm) {
            IVertexBuilder builder;
            matrix.func_227860_a_();
            armPos.translate(this, matrix, entity);
            MatrixStack.Entry last = matrix.func_227866_c_();
            if (hasOpaqueArm) {
                builder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)renderer, (RenderType)MekanismRenderType.getMekaSuit(), (boolean)false, (boolean)hasEffect);
                for (BakedQuad quad : armorQuads.getOpaqueMap().get((Object)armPos)) {
                    builder.addVertexData(last, quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlayLight);
                }
            }
            if (hasTransparentArm) {
                builder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)renderer, (RenderType)RenderType.func_228644_e_((ResourceLocation)AtlasTexture.field_110575_b), (boolean)false, (boolean)hasEffect);
                for (BakedQuad quad : armorQuads.getTransparentMap().get((Object)armPos)) {
                    builder.addVertexData(last, quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlayLight);
                }
            }
            matrix.func_227865_b_();
        }
    }

    @Override
    public void render(@Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light, int overlayLight, float partialTicks, boolean hasEffect, LivingEntity entity, ItemStack stack) {
        if (this.field_217114_e) {
            matrix.func_227860_a_();
            float f1 = 1.0f / this.field_228225_h_;
            matrix.func_227862_a_(f1, f1, f1);
            matrix.func_227861_a_(0.0, (double)(this.field_228226_i_ / 16.0f), 0.0);
            this.renderMekaSuit(matrix, renderer, light, overlayLight, partialTicks, hasEffect, entity);
            matrix.func_227865_b_();
        } else {
            this.renderMekaSuit(matrix, renderer, light, overlayLight, partialTicks, hasEffect, entity);
        }
    }

    private void renderMekaSuit(@Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light, int overlayLight, float partialTicks, boolean hasEffect, LivingEntity entity) {
        ArmorQuads armorQuads = (ArmorQuads)this.cache.getUnchecked((Object)this.key(entity));
        this.render(renderer, matrix, light, overlayLight, hasEffect, entity, armorQuads.getOpaqueMap(), false);
        if (this.type == EquipmentSlotType.CHEST) {
            BoltRenderer boltRenderer = boltRenderMap.computeIfAbsent(entity.func_110124_au(), id -> new BoltRenderer());
            if (MekanismAPI.getModuleHelper().isEnabled(entity.func_184582_a(EquipmentSlotType.CHEST), MekanismModules.GRAVITATIONAL_MODULATING_UNIT)) {
                BoltEffect leftBolt = new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, new Vector3d(-0.01, 0.35, 0.37), new Vector3d(-0.01, 0.15, 0.37), 10).size(0.012f).lifespan(6).spawn(BoltEffect.SpawnFunction.noise(3.0f, 1.0f));
                BoltEffect rightBolt = new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, new Vector3d(0.025, 0.35, 0.37), new Vector3d(0.025, 0.15, 0.37), 10).size(0.012f).lifespan(6).spawn(BoltEffect.SpawnFunction.noise(3.0f, 1.0f));
                boltRenderer.update(0, leftBolt, partialTicks);
                boltRenderer.update(1, rightBolt, partialTicks);
            }
            matrix.func_227860_a_();
            ModelPos.BODY.translate(this, matrix, entity);
            boltRenderer.render(partialTicks, matrix, renderer);
            matrix.func_227865_b_();
        }
        this.render(renderer, matrix, light, overlayLight, hasEffect, entity, armorQuads.getTransparentMap(), true);
    }

    private void render(IRenderTypeBuffer renderer, MatrixStack matrix, int light, int overlayLight, boolean hasEffect, LivingEntity entity, Map<ModelPos, List<BakedQuad>> quadMap, boolean transparent) {
        if (!quadMap.isEmpty()) {
            RenderType renderType = transparent ? RenderType.func_228644_e_((ResourceLocation)AtlasTexture.field_110575_b) : MekanismRenderType.getMekaSuit();
            IVertexBuilder builder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)renderer, (RenderType)renderType, (boolean)false, (boolean)hasEffect);
            for (Map.Entry<ModelPos, List<BakedQuad>> entry : quadMap.entrySet()) {
                matrix.func_227860_a_();
                entry.getKey().translate(this, matrix, entity);
                MatrixStack.Entry last = matrix.func_227866_c_();
                for (BakedQuad quad : entry.getValue()) {
                    builder.addVertexData(last, quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlayLight);
                }
                matrix.func_227865_b_();
            }
        }
    }

    private static List<BakedQuad> getQuads(BaseModelCache.ModelData data, Set<String> parts, Set<String> ledParts, @Nullable QuadTransformation transform) {
        Random random = Minecraft.func_71410_x().field_71441_e.func_201674_k();
        List<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (!parts.isEmpty()) {
            quads.addAll(data.bake(new MekaSuitModelConfiguration(parts)).getQuads(null, null, random, (IModelData)EmptyModelData.INSTANCE));
        }
        if (!ledParts.isEmpty()) {
            List ledQuads = data.bake(new MekaSuitModelConfiguration(ledParts)).getQuads(null, null, random, (IModelData)EmptyModelData.INSTANCE);
            quads.addAll(QuadUtils.transformBakedQuads(ledQuads, QuadTransformation.fullbright));
        }
        if (transform != null) {
            quads = QuadUtils.transformBakedQuads(quads, transform);
        }
        return quads;
    }

    private static void processMekaTool(BaseModelCache.OBJModelData mekaToolModel, Set<String> ignored) {
        for (IModelGeometryPart part : mekaToolModel.getModel().getParts()) {
            String name = part.name();
            if (!name.contains(OVERRIDDEN_TAG)) continue;
            ignored.add(MekaSuitArmor.processOverrideName(name, "mekatool"));
        }
    }

    private ArmorQuads createQuads(Object2BooleanMap<ModuleModelSpec> modules, Set<EquipmentSlotType> wornParts, boolean hasMekaToolLeft, boolean hasMekaToolRight) {
        Object2ObjectOpenHashMap specialQuadsToRender = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap specialLEDQuadsToRender = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap overrides = new Object2ObjectOpenHashMap();
        HashSet<String> ignored = new HashSet<String>();
        if (!modules.isEmpty()) {
            ModuleOBJModelData modelData = MekanismModelCache.INSTANCE.MEKASUIT_MODULES;
            Map quadsToRender = specialQuadsToRender.computeIfAbsent(modelData, d -> new EnumMap(ModelPos.class));
            Map ledQuadsToRender = specialLEDQuadsToRender.computeIfAbsent(modelData, d -> new EnumMap(ModelPos.class));
            HashSet<String> matchedParts = new HashSet<String>();
            for (Object2BooleanMap.Entry entry : modules.object2BooleanEntrySet()) {
                ModuleModelSpec spec = (ModuleModelSpec)entry.getKey();
                for (String name : modelData.getPartsForSpec(spec, entry.getBooleanValue())) {
                    if (name.contains(OVERRIDDEN_TAG)) {
                        overrides.put(spec.processOverrideName(name), Pair.of((Object)modelData, (Object)name));
                    }
                    if (this.type != spec.slotType) continue;
                    matchedParts.add(name);
                }
            }
            for (String name : matchedParts) {
                ModelPos pos = ModelPos.get(name);
                if (pos == null) {
                    Mekanism.logger.warn("MekaSuit part '{}' is invalid from modules model. Ignoring.", (Object)name);
                    continue;
                }
                MekaSuitArmor.addQuadsToRender(pos, name, (Map<String, Pair<BaseModelCache.ModelData, String>>)overrides, quadsToRender, ledQuadsToRender, (Map<BaseModelCache.ModelData, Map<ModelPos, Set<String>>>)specialQuadsToRender, (Map<BaseModelCache.ModelData, Map<ModelPos, Set<String>>>)specialLEDQuadsToRender);
            }
        }
        if (this.type == EquipmentSlotType.CHEST) {
            if (hasMekaToolLeft) {
                MekaSuitArmor.processMekaTool(MekanismModelCache.INSTANCE.MEKATOOL_LEFT_HAND, ignored);
            }
            if (hasMekaToolRight) {
                MekaSuitArmor.processMekaTool(MekanismModelCache.INSTANCE.MEKATOOL_RIGHT_HAND, ignored);
            }
        }
        EnumMap<ModelPos, Set<String>> armorQuadsToRender = new EnumMap<ModelPos, Set<String>>(ModelPos.class);
        EnumMap<ModelPos, Set<String>> armorLEDQuadsToRender = new EnumMap<ModelPos, Set<String>>(ModelPos.class);
        for (IModelGeometryPart part : MekanismModelCache.INSTANCE.MEKASUIT.getModel().getParts()) {
            String name = part.name();
            if (!MekaSuitArmor.checkEquipment(this.type, name) || (!name.startsWith(EXCLUSIVE_TAG) ? name.startsWith(SHARED_TAG) && wornParts.contains(this.adjacentType) && this.adjacentType.ordinal() > this.type.ordinal() : wornParts.contains(this.adjacentType))) continue;
            ModelPos pos = ModelPos.get(name);
            if (pos == null) {
                Mekanism.logger.warn("MekaSuit part '{}' is invalid. Ignoring.", (Object)name);
                continue;
            }
            if (ignored.contains(name)) continue;
            MekaSuitArmor.addQuadsToRender(pos, name, (Map<String, Pair<BaseModelCache.ModelData, String>>)overrides, armorQuadsToRender, armorLEDQuadsToRender, (Map<BaseModelCache.ModelData, Map<ModelPos, Set<String>>>)specialQuadsToRender, (Map<BaseModelCache.ModelData, Map<ModelPos, Set<String>>>)specialLEDQuadsToRender);
        }
        EnumMap<ModelPos, List<BakedQuad>> opaqueMap = new EnumMap<ModelPos, List<BakedQuad>>(ModelPos.class);
        EnumMap<ModelPos, List<BakedQuad>> transparentMap = new EnumMap<ModelPos, List<BakedQuad>>(ModelPos.class);
        for (ModelPos pos : ModelPos.VALUES) {
            for (BaseModelCache.ModelData modelData : specialModels) {
                MekaSuitArmor.parseTransparency(modelData, pos, opaqueMap, transparentMap, specialQuadsToRender.getOrDefault(modelData, Collections.emptyMap()), specialLEDQuadsToRender.getOrDefault(modelData, Collections.emptyMap()));
            }
            MekaSuitArmor.parseTransparency(MekanismModelCache.INSTANCE.MEKASUIT, pos, opaqueMap, transparentMap, armorQuadsToRender, armorLEDQuadsToRender);
        }
        return new ArmorQuads(opaqueMap, transparentMap);
    }

    private static void addQuadsToRender(ModelPos pos, String name, Map<String, Pair<BaseModelCache.ModelData, String>> overrides, Map<ModelPos, Set<String>> quadsToRender, Map<ModelPos, Set<String>> ledQuadsToRender, Map<BaseModelCache.ModelData, Map<ModelPos, Set<String>>> specialQuadsToRender, Map<BaseModelCache.ModelData, Map<ModelPos, Set<String>>> specialLEDQuadsToRender) {
        Pair<BaseModelCache.ModelData, String> override = overrides.get(name);
        if (override != null) {
            name = (String)override.getRight();
            BaseModelCache.ModelData overrideData = (BaseModelCache.ModelData)override.getLeft();
            quadsToRender = specialQuadsToRender.computeIfAbsent(overrideData, d -> new EnumMap(ModelPos.class));
            ledQuadsToRender = specialLEDQuadsToRender.computeIfAbsent(overrideData, d -> new EnumMap(ModelPos.class));
        }
        if (name.contains(LED_TAG)) {
            ledQuadsToRender.computeIfAbsent((ModelPos)pos, p -> new HashSet()).add(name);
        } else {
            quadsToRender.computeIfAbsent((ModelPos)pos, p -> new HashSet()).add(name);
        }
    }

    private static void parseTransparency(BaseModelCache.ModelData modelData, ModelPos pos, Map<ModelPos, List<BakedQuad>> opaqueMap, Map<ModelPos, List<BakedQuad>> transparentMap, Map<ModelPos, Set<String>> regularQuads, Map<ModelPos, Set<String>> ledQuads) {
        HashSet<String> opaqueRegularQuads = new HashSet<String>();
        HashSet<String> opaqueLEDQuads = new HashSet<String>();
        HashSet<String> transparentRegularQuads = new HashSet<String>();
        HashSet<String> transparentLEDQuads = new HashSet<String>();
        MekaSuitArmor.parseTransparency(pos, opaqueRegularQuads, transparentRegularQuads, regularQuads);
        MekaSuitArmor.parseTransparency(pos, opaqueLEDQuads, transparentLEDQuads, ledQuads);
        MekaSuitArmor.addParsedQuads(modelData, pos, opaqueMap, opaqueRegularQuads, opaqueLEDQuads);
        MekaSuitArmor.addParsedQuads(modelData, pos, transparentMap, transparentRegularQuads, transparentLEDQuads);
    }

    private static void addParsedQuads(BaseModelCache.ModelData modelData, ModelPos pos, Map<ModelPos, List<BakedQuad>> map, Set<String> quads, Set<String> ledQuads) {
        List<BakedQuad> bakedQuads = MekaSuitArmor.getQuads(modelData, quads, ledQuads, pos.getTransform());
        if (!bakedQuads.isEmpty()) {
            map.computeIfAbsent(pos, p -> new ArrayList()).addAll(bakedQuads);
        }
    }

    private static void parseTransparency(ModelPos pos, Set<String> opaqueQuads, Set<String> transparentQuads, Map<ModelPos, Set<String>> quads) {
        for (String quad : quads.getOrDefault((Object)pos, Collections.emptySet())) {
            if (quad.contains(GLASS_TAG)) {
                transparentQuads.add(quad);
                continue;
            }
            opaqueQuads.add(quad);
        }
    }

    private static boolean checkEquipment(EquipmentSlotType type, String text) {
        switch (type) {
            case HEAD: {
                return text.contains("helmet");
            }
            case CHEST: {
                return text.contains("chest");
            }
            case LEGS: {
                return text.contains("leggings");
            }
            case FEET: {
                return text.contains("boots");
            }
        }
        return false;
    }

    private static String processOverrideName(String part, String name) {
        return part.replaceFirst(OVERRIDDEN_TAG, "").replaceFirst(name + "_", "");
    }

    private static void registerModule(String name, IModuleDataProvider<?> moduleDataProvider, EquipmentSlotType slotType) {
        MekaSuitArmor.registerModule(name, moduleDataProvider, slotType, entity -> true);
    }

    private static void registerModule(String name, IModuleDataProvider<?> moduleDataProvider, EquipmentSlotType slotType, Predicate<LivingEntity> isActive) {
        ModuleData<?> module = moduleDataProvider.getModuleData();
        moduleModelSpec.put((Object)slotType, module, (Object)new ModuleModelSpec(module, slotType, name, isActive));
    }

    public TransmitterBakedModel.QuickHash key(LivingEntity player) {
        Object2BooleanOpenHashMap modules = new Object2BooleanOpenHashMap();
        EnumSet<EquipmentSlotType> wornParts = EnumSet.noneOf(EquipmentSlotType.class);
        IModuleHelper moduleHelper = MekanismAPI.getModuleHelper();
        for (EquipmentSlotType slotType : EnumUtils.ARMOR_SLOTS) {
            ItemStack wornItem = player.func_184582_a(slotType);
            if (wornItem.func_190926_b() || !(wornItem.func_77973_b() instanceof ItemMekaSuitArmor)) continue;
            wornParts.add(slotType);
            for (Map.Entry entry : moduleModelSpec.row((Object)slotType).entrySet()) {
                if (!moduleHelper.isEnabled(wornItem, (IModuleDataProvider)entry.getKey())) continue;
                ModuleModelSpec spec = (ModuleModelSpec)entry.getValue();
                modules.put((Object)spec, spec.isActive(player));
            }
        }
        return new TransmitterBakedModel.QuickHash(modules.isEmpty() ? Object2BooleanMaps.emptyMap() : modules, wornParts.isEmpty() ? Collections.emptySet() : wornParts, MekanismUtils.getItemInHand(player, HandSide.LEFT).func_77973_b() instanceof ItemMekaTool, MekanismUtils.getItemInHand(player, HandSide.RIGHT).func_77973_b() instanceof ItemMekaTool);
    }

    static /* synthetic */ QuadTransformation access$100() {
        return BASE_TRANSFORM;
    }

    static {
        MekaSuitArmor.registerModule("solar_helmet", MekanismModules.SOLAR_RECHARGING_UNIT, EquipmentSlotType.HEAD);
        MekaSuitArmor.registerModule("jetpack", MekanismModules.JETPACK_UNIT, EquipmentSlotType.CHEST);
        MekaSuitArmor.registerModule("modulator", MekanismModules.GRAVITATIONAL_MODULATING_UNIT, EquipmentSlotType.CHEST);
        MekaSuitArmor.registerModule("elytra", MekanismModules.ELYTRA_UNIT, EquipmentSlotType.CHEST, LivingEntity::func_184613_cA);
        BASE_TRANSFORM = QuadTransformation.list(QuadTransformation.rotate(0.0, 0.0, 180.0), QuadTransformation.translate(new Vector3d(-1.0, 0.5, 0.0)));
    }

    private static class MekaSuitModelConfiguration
    implements IModelConfiguration {
        private final Set<String> parts;

        public MekaSuitModelConfiguration(Set<String> parts) {
            this.parts = parts.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(parts);
        }

        @Nullable
        public IUnbakedModel getOwnerModel() {
            return null;
        }

        @Nonnull
        public String getModelName() {
            return "mekasuit";
        }

        public boolean isTexturePresent(@Nonnull String name) {
            return false;
        }

        @Nonnull
        public RenderMaterial resolveTexture(@Nonnull String name) {
            return ModelLoaderRegistry.blockMaterial((String)name);
        }

        public boolean isShadedInGui() {
            return false;
        }

        public boolean isSideLit() {
            return false;
        }

        public boolean useSmoothLighting() {
            return true;
        }

        @Nonnull
        @Deprecated
        public ItemCameraTransforms getCameraTransforms() {
            return ItemCameraTransforms.field_178357_a;
        }

        @Nonnull
        public IModelTransform getCombinedTransform() {
            return ModelRotation.X0_Y0;
        }

        public boolean getPartVisibility(@Nonnull IModelGeometryPart part, boolean fallback) {
            return this.getPartVisibility(part);
        }

        public boolean getPartVisibility(@Nonnull IModelGeometryPart part) {
            return this.parts.contains(part.name());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.parts.equals(((MekaSuitModelConfiguration)o).parts);
        }

        public int hashCode() {
            return this.parts.hashCode();
        }
    }

    public static class ModuleOBJModelData
    extends BaseModelCache.OBJModelData {
        private final Map<ModuleModelSpec, Pair<Set<String>, Set<String>>> specParts = new Object2ObjectOpenHashMap();

        public ModuleOBJModelData(ResourceLocation rl) {
            super(rl);
        }

        public Set<String> getPartsForSpec(ModuleModelSpec spec, boolean active) {
            Pair<Set<String>, Set<String>> pair = this.specParts.get(spec);
            if (pair == null) {
                return Collections.emptySet();
            }
            return active ? (Set)pair.getLeft() : (Set)pair.getRight();
        }

        @Override
        protected void reload(ModelBakeEvent evt) {
            super.reload(evt);
            Collection modules = moduleModelSpec.values();
            for (IModelGeometryPart iModelGeometryPart : this.getModel().getParts()) {
                String name = iModelGeometryPart.name();
                ModuleModelSpec matchingSpec = null;
                int bestScore = -1;
                for (ModuleModelSpec spec2 : modules) {
                    int score = spec2.score(name);
                    if (score == -1 || bestScore != -1 && score >= bestScore) continue;
                    bestScore = score;
                    matchingSpec = spec2;
                }
                if (matchingSpec == null) continue;
                Pair pair = this.specParts.computeIfAbsent(matchingSpec, spec -> Pair.of(new HashSet(), new HashSet()));
                if (name.contains(MekaSuitArmor.INACTIVE_TAG + matchingSpec.name + "_")) {
                    ((Set)pair.getRight()).add(name);
                    continue;
                }
                ((Set)pair.getLeft()).add(name);
            }
            for (Map.Entry entry : this.specParts.entrySet()) {
                Pair pair = (Pair)entry.getValue();
                if (((Set)pair.getLeft()).isEmpty()) {
                    entry.setValue(Pair.of(Collections.emptySet(), (Object)pair.getRight()));
                    continue;
                }
                if (!((Set)pair.getRight()).isEmpty()) continue;
                entry.setValue(Pair.of((Object)pair.getLeft(), Collections.emptySet()));
            }
        }
    }

    public static class ModuleModelSpec {
        private final ModuleData<?> module;
        private final EquipmentSlotType slotType;
        private final String name;
        private final Predicate<LivingEntity> isActive;

        public ModuleModelSpec(ModuleData<?> module, EquipmentSlotType slotType, String name, Predicate<LivingEntity> isActive) {
            this.module = module;
            this.slotType = slotType;
            this.name = name;
            this.isActive = isActive;
        }

        public int score(String name) {
            return name.indexOf(this.name + "_");
        }

        public boolean isActive(LivingEntity entity) {
            return this.isActive.test(entity);
        }

        public String processOverrideName(String part) {
            return MekaSuitArmor.processOverrideName(part, this.name);
        }

        public ModuleData<?> getModule() {
            return this.module;
        }
    }

    public static class ArmorQuads {
        private final Map<ModelPos, List<BakedQuad>> opaqueQuads;
        private final Map<ModelPos, List<BakedQuad>> transparentQuads;

        public ArmorQuads(Map<ModelPos, List<BakedQuad>> opaqueQuads, Map<ModelPos, List<BakedQuad>> transparentQuads) {
            this.opaqueQuads = opaqueQuads.isEmpty() ? Collections.emptyMap() : opaqueQuads;
            this.transparentQuads = transparentQuads.isEmpty() ? Collections.emptyMap() : transparentQuads;
        }

        public Map<ModelPos, List<BakedQuad>> getOpaqueMap() {
            return this.opaqueQuads;
        }

        public Map<ModelPos, List<BakedQuad>> getTransparentMap() {
            return this.transparentQuads;
        }
    }

    public static enum ModelPos {
        HEAD(MekaSuitArmor.access$100(), s -> s.contains("head")),
        BODY(MekaSuitArmor.access$100(), s -> s.contains("body")),
        LEFT_ARM(MekaSuitArmor.access$100().and(QuadTransformation.translate(new Vector3d(-0.3125, -0.125, 0.0))), s -> s.contains("left_arm")),
        RIGHT_ARM(MekaSuitArmor.access$100().and(QuadTransformation.translate(new Vector3d(0.3125, -0.125, 0.0))), s -> s.contains("right_arm")),
        LEFT_LEG(MekaSuitArmor.access$100().and(QuadTransformation.translate(new Vector3d(-0.125, -0.75, 0.0))), s -> s.contains("left_leg")),
        RIGHT_LEG(MekaSuitArmor.access$100().and(QuadTransformation.translate(new Vector3d(0.125, -0.75, 0.0))), s -> s.contains("right_leg")),
        LEFT_WING(MekaSuitArmor.access$100(), s -> s.contains("left_wing")),
        RIGHT_WING(MekaSuitArmor.access$100(), s -> s.contains("right_wing"));

        private static final float EXPANDED_WING_X = 1.0f;
        private static final float EXPANDED_WING_Y = -2.5f;
        private static final float EXPANDED_WING_Z = 5.0f;
        private static final float EXPANDED_WING_Y_ROT = 45.0f;
        private static final float EXPANDED_WING_Z_ROT = 25.0f;
        public static final ModelPos[] VALUES;
        private final QuadTransformation transform;
        private final Predicate<String> modelSpec;

        private ModelPos(QuadTransformation transform, Predicate<String> modelSpec) {
            this.transform = transform;
            this.modelSpec = modelSpec;
        }

        public QuadTransformation getTransform() {
            return this.transform;
        }

        public boolean contains(String s) {
            return this.modelSpec.test(s);
        }

        public static ModelPos get(String name) {
            name = name.toLowerCase(Locale.ROOT);
            for (ModelPos pos : VALUES) {
                if (!pos.contains(name)) continue;
                return pos;
            }
            return null;
        }

        public void translate(MekaSuitArmor armor, MatrixStack matrix, LivingEntity entity) {
            switch (this) {
                case HEAD: {
                    armor.field_78116_c.func_228307_a_(matrix);
                    break;
                }
                case BODY: {
                    armor.field_78115_e.func_228307_a_(matrix);
                    break;
                }
                case LEFT_ARM: {
                    armor.field_178724_i.func_228307_a_(matrix);
                    break;
                }
                case RIGHT_ARM: {
                    armor.field_178723_h.func_228307_a_(matrix);
                    break;
                }
                case LEFT_LEG: {
                    armor.field_178722_k.func_228307_a_(matrix);
                    break;
                }
                case RIGHT_LEG: {
                    armor.field_178721_j.func_228307_a_(matrix);
                    break;
                }
                case LEFT_WING: 
                case RIGHT_WING: {
                    this.translateWings(armor, matrix, entity);
                }
            }
        }

        private void translateWings(MekaSuitArmor armor, MatrixStack matrix, LivingEntity entity) {
            armor.field_78115_e.func_228307_a_(matrix);
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            float yRot = 0.0f;
            float zRot = 0.0f;
            if (entity.func_184613_cA() && entity.field_70125_A < 45.0f) {
                float scale = 0.0f;
                if (entity.field_70125_A > -45.0f || entity.func_213322_ci().field_72448_b > 1.0) {
                    scale = 1.0f;
                } else if (entity.func_213322_ci().field_72448_b > 0.0) {
                    scale = (float)entity.func_213322_ci().field_72448_b;
                }
                x = 1.0f * scale;
                y = -2.5f * scale;
                z = 5.0f * scale;
                yRot = 45.0f * scale;
                zRot = 25.0f * scale;
            }
            if (entity instanceof AbstractClientPlayerEntity) {
                AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)entity;
                player.field_184835_a = 0.0f;
                player.field_184836_b += (yRot - player.field_184836_b) * 0.01f;
                yRot = player.field_184836_b;
                float scale = player.field_184836_b / 45.0f;
                x = 1.0f * scale;
                y = -2.5f * scale;
                z = 5.0f * scale;
                zRot = player.field_184837_c = 25.0f * scale;
            }
            if (this == RIGHT_WING) {
                x = -x;
                yRot = -yRot;
                zRot = -zRot;
            }
            matrix.func_227861_a_((double)(x / 16.0f), (double)(y / 16.0f), (double)(z / 16.0f));
            if (yRot != 0.0f) {
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yRot));
            }
            if (zRot != 0.0f) {
                matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(zRot));
            }
        }

        static {
            VALUES = ModelPos.values();
        }
    }
}

