/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.providers.IItemProvider;
import mekanism.api.recipes.ItemStackToPigmentRecipe;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiPigmentGauge;
import mekanism.client.jei.JEIColorDetails;
import mekanism.client.jei.MekanismJEI;
import mekanism.client.jei.machine.ItemStackToChemicalRecipeCategory;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;

public class ItemStackToPigmentRecipeCategory
extends ItemStackToChemicalRecipeCategory<Pigment, PigmentStack, ItemStackToPigmentRecipe> {
    private final Map<ItemStackToPigmentRecipe, IGuiIngredientGroup<PigmentStack>> ingredients = new WeakHashMap<ItemStackToPigmentRecipe, IGuiIngredientGroup<PigmentStack>>();
    private final PigmentColorDetails currentDetails = new PigmentColorDetails();

    public ItemStackToPigmentRecipeCategory(IGuiHelper helper, IItemProvider mekanismBlock) {
        super(helper, mekanismBlock, MekanismJEI.TYPE_PIGMENT, false);
        this.progressBar.colored(this.currentDetails);
    }

    protected GuiPigmentGauge getGauge(GaugeType type, int x, int y) {
        return GuiPigmentGauge.getDummy(type, this, x, y);
    }

    public Class<? extends ItemStackToPigmentRecipe> getRecipeClass() {
        return ItemStackToPigmentRecipe.class;
    }

    @Override
    public void draw(ItemStackToPigmentRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        IGuiIngredientGroup<PigmentStack> group = this.ingredients.get(recipe);
        if (group != null) {
            this.currentDetails.outputIngredient = (IGuiIngredient)group.getGuiIngredients().get(0);
        }
        super.draw(recipe, matrixStack, mouseX, mouseY);
        this.currentDetails.outputIngredient = null;
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, ItemStackToPigmentRecipe recipe, IIngredients ingredients) {
        super.setRecipe(recipeLayout, recipe, ingredients);
        this.ingredients.put(recipe, (IGuiIngredientGroup<PigmentStack>)recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_PIGMENT));
    }

    private static class PigmentColorDetails
    extends JEIColorDetails<Pigment, PigmentStack> {
        @Nullable
        private IGuiIngredient<PigmentStack> outputIngredient;

        private PigmentColorDetails() {
            super(PigmentStack.EMPTY);
        }

        @Override
        public int getColorFrom() {
            return -1;
        }

        @Override
        public int getColorTo() {
            return this.getColor(this.outputIngredient);
        }
    }
}

