/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.teleport;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import xaero.map.WorldMap;
import xaero.map.world.MapConnectionNode;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class MapTeleporter {
    public void teleport(Screen screen, MapWorld mapWorld, int x, int y, int z, RegistryKey<World> d) {
        String tpCommand;
        Minecraft.func_71410_x().func_147108_a(null);
        if (Minecraft.func_71410_x().field_71442_b.func_78755_b()) {
            MapConnectionNode destinationMapKey;
            MapDimension destinationDim = mapWorld.getDimension(d != null ? d : Minecraft.func_71410_x().field_71441_e.func_234923_W_());
            MapConnectionNode playerMapKey = mapWorld.getPlayerMapKey();
            if (playerMapKey == null) {
                StringTextComponent messageComponent = new StringTextComponent(I18n.func_135052_a((String)"gui.xaero_wm_teleport_never_confirmed", (Object[])new Object[0]));
                messageComponent.func_230530_a_(messageComponent.func_150256_b().func_240712_a_(TextFormatting.RED));
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)messageComponent);
                return;
            }
            MapConnectionNode mapConnectionNode = destinationMapKey = destinationDim == null ? null : destinationDim.getSelectedMapKeyUnsynced();
            if (!mapWorld.getMapConnections().isConnected(playerMapKey, destinationMapKey)) {
                StringTextComponent messageComponent = new StringTextComponent(I18n.func_135052_a((String)"gui.xaero_wm_teleport_not_connected", (Object[])new Object[0]));
                messageComponent.func_230530_a_(messageComponent.func_150256_b().func_240712_a_(TextFormatting.RED));
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)messageComponent);
                return;
            }
        }
        String string = tpCommand = d == null ? mapWorld.getTeleportCommandFormat() : mapWorld.getDimensionTeleportCommandFormat();
        String yString = y == -1 ? "~" : (WorldMap.settings.partialYTeleportation ? (double)y + 0.5 + "" : y + "");
        tpCommand = tpCommand.replace("{x}", "" + x).replace("{y}", yString).replace("{z}", "" + z);
        if (d != null) {
            tpCommand = tpCommand.replace("{d}", d.func_240901_a_().toString());
        }
        screen.func_231159_b_(tpCommand, false);
        mapWorld.setCustomDimensionId(null);
        mapWorld.getMapProcessor().checkForWorldUpdate();
    }
}

