/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.registries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.biggerreactors.BiggerReactors;
import net.roguelogix.phosphophyllite.data.DataLoader;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidTransitionRegistry {
    private static final Map<Fluid, FluidTransition> liquidTransitions = new HashMap<Fluid, FluidTransition>();
    private static final Map<Fluid, FluidTransition> gasTransitions = new HashMap<Fluid, FluidTransition>();
    private static final DataLoader<FluidTransitionJsonData> loader = new DataLoader(FluidTransitionJsonData.class);

    @Nullable
    public static FluidTransition liquidTransition(Fluid liquid) {
        return liquidTransitions.get(liquid);
    }

    @Nullable
    public static FluidTransition gasTransition(Fluid gas) {
        return gasTransitions.get(gas);
    }

    public static void loadRegistry(ITagCollection<Fluid> fluidTags) {
        BiggerReactors.LOGGER.info("Loading fluid transitions");
        liquidTransitions.clear();
        gasTransitions.clear();
        List data = loader.loadAll(new ResourceLocation("biggerreactors:transitions"));
        BiggerReactors.LOGGER.info("Loaded " + data.size() + " transitions data entries");
        for (FluidTransitionJsonData transitionData : data) {
            ArrayList<Fluid> liquids = new ArrayList<Fluid>();
            if (transitionData.liquidType.equals("tag")) {
                ITag tag = fluidTags.func_199910_a(transitionData.liquid);
                if (tag == null) continue;
                for (Fluid fluid : tag.func_230236_b_()) {
                    if (!fluid.func_207193_c(fluid.func_207188_f())) continue;
                    liquids.add(fluid);
                }
            } else if (ForgeRegistries.FLUIDS.containsKey(transitionData.liquid)) {
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(transitionData.liquid);
                liquids.add(fluid);
            }
            if (liquids.isEmpty()) continue;
            ArrayList<Fluid> gases = new ArrayList<Fluid>();
            if (transitionData.gasType.equals("tag")) {
                ITag tag = fluidTags.func_199910_a(transitionData.gas);
                if (tag == null) continue;
                for (Fluid fluid : tag.func_230236_b_()) {
                    if (!fluid.func_207193_c(fluid.func_207188_f())) continue;
                    gases.add(fluid);
                }
            } else if (ForgeRegistries.FLUIDS.containsKey(transitionData.gas)) {
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(transitionData.gas);
                gases.add(fluid);
            }
            if (gases.isEmpty()) continue;
            FluidTransition transition = new FluidTransition(liquids, gases, transitionData.latentHeat, transitionData.boilingPoint, transitionData.liquidThermalConductivity, transitionData.gasThermalConductivity, transitionData.turbineMultiplier);
            for (Fluid liquid : transition.liquids) {
                if (liquidTransitions.put(liquid, transition) == null) continue;
                BiggerReactors.LOGGER.error("Duplicate transitions given for liquid fluid " + liquid.getRegistryName().toString());
            }
            for (Fluid gas : transition.gases) {
                if (gasTransitions.put(gas, transition) == null) continue;
                BiggerReactors.LOGGER.error("Duplicate transitions given for gas fluid " + gas.getRegistryName().toString());
            }
        }
        BiggerReactors.LOGGER.info("Loaded " + liquidTransitions.size() + " liquid transition entries");
        BiggerReactors.LOGGER.info("Loaded " + gasTransitions.size() + " gas transition entries");
    }

    private static class FluidTransitionJsonData {
        @DataLoader.Values(value={"tag", "registry"})
        public String liquidType;
        public ResourceLocation liquid;
        @DataLoader.Values(value={"tag", "registry"})
        public String gasType;
        public ResourceLocation gas;
        @DataLoader.Range(value="(0,)")
        public double latentHeat;
        @DataLoader.Range(value="(20,)")
        public double boilingPoint;
        @DataLoader.Range(value="(0,)")
        public double liquidThermalConductivity;
        @DataLoader.Range(value="(0,)")
        public double gasThermalConductivity;
        @DataLoader.Range(value="[0,)")
        public double turbineMultiplier;

        private FluidTransitionJsonData() {
        }
    }

    public static class FluidTransition {
        public final List<Fluid> liquids;
        public final List<Fluid> gases;
        public final double latentHeat;
        public final double boilingPoint;
        public final double liquidRFMKT;
        public final double gasRFMKT;
        public final double turbineMultiplier;

        public FluidTransition(List<Fluid> liquids, List<Fluid> gases, double latentHeat, double boilingPoint, double liquidRFMKT, double gasRFMKT, double turbineMultiplier) {
            this.liquids = Collections.unmodifiableList(liquids);
            this.gases = Collections.unmodifiableList(gases);
            this.latentHeat = latentHeat;
            this.boilingPoint = boilingPoint;
            this.liquidRFMKT = liquidRFMKT;
            this.gasRFMKT = gasRFMKT;
            this.turbineMultiplier = turbineMultiplier;
        }
    }
}

