/*
 * Decompiled with CFR 0.152.
 */
package com.kotakotik.createautomated.register;

import com.kotakotik.createautomated.CreateAutomated;
import com.kotakotik.createautomated.content.base.IOreExtractorBlock;
import com.kotakotik.createautomated.content.conditions.ConfigEnabledCondition;
import com.kotakotik.createautomated.content.processing.oreExtractor.recipe.ExtractingRecipeGen;
import com.kotakotik.createautomated.content.processing.picker.recipe.PickingRecipe;
import com.kotakotik.createautomated.content.processing.picker.recipe.PickingRecipeGen;
import com.kotakotik.createautomated.content.simple.drillHead.DrillHeadItem;
import com.kotakotik.createautomated.content.simple.node.NodeBlock;
import com.kotakotik.createautomated.content.worldgen.DimensionalConfigDrivenFeatureEntry;
import com.kotakotik.createautomated.content.worldgen.WorldGen;
import com.kotakotik.createautomated.register.ModBlocks;
import com.kotakotik.createautomated.register.ModConditions;
import com.kotakotik.createautomated.register.ModFluids;
import com.kotakotik.createautomated.register.ModTags;
import com.kotakotik.createautomated.register.ModTooltips;
import com.kotakotik.createautomated.register.config.ModServerConfig;
import com.kotakotik.createautomated.register.recipes.ModCrushingRecipes;
import com.kotakotik.createautomated.register.recipes.ModDeployingRecipes;
import com.kotakotik.createautomated.register.recipes.ModMixingRecipes;
import com.kotakotik.createautomated.register.recipes.ModSplashingRecipes;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.AllSections;
import com.simibubi.create.content.contraptions.processing.HeatCondition;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.builders.FluidBuilder;
import com.simibubi.create.repack.registrate.builders.ItemBuilder;
import com.simibubi.create.repack.registrate.providers.DataGenContext;
import com.simibubi.create.repack.registrate.providers.RegistrateLangProvider;
import com.simibubi.create.repack.registrate.providers.RegistrateRecipeProvider;
import com.simibubi.create.repack.registrate.util.entry.BlockEntry;
import com.simibubi.create.repack.registrate.util.entry.FluidEntry;
import com.simibubi.create.repack.registrate.util.entry.ItemEntry;
import com.simibubi.create.repack.registrate.util.nullness.NonNullBiConsumer;
import com.simibubi.create.repack.registrate.util.nullness.NonNullConsumer;
import com.simibubi.create.repack.registrate.util.nullness.NonNullFunction;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

public class RecipeItems
extends ModFluids {
    public static List<ExtractableResource> EXTRACTABLES = new ArrayList<ExtractableResource>();
    public static ExtractableResource LAPIS_EXTRACTABLE;
    public static ExtractableResource IRON_EXTRACTABLE;
    public static ExtractableResource ZINC_EXTRACTABLE;
    public static ExtractableResource GOLD_EXTRACTABLE;
    public static ExtractableResource COPPER_EXTRACTABLE;
    public static ExtractableResource CINDER_FLOUR_EXTRACTABLE;
    public static RecipeItem<DrillHeadItem> DRILL_HEAD;
    public static RecipeItem<Item> CRUSHED_PRISMARINE;
    public static RenewableGem DIAMOND_RENEWABLE;
    public static RenewableGem EMERALD_RENEWABLE;
    public static ItemGroup itemGroup;
    public static ModMixingRecipes MIXING;
    public static ModCrushingRecipes CRUSHING;
    public static ExtractingRecipeGen EXTRACTING;
    public static PickingRecipeGen PICKING;
    public static ModDeployingRecipes DEPLOYING;
    public static ModSplashingRecipes SPLASHING;

    public static void register(CreateRegistrate registrate) {
        registrate.itemGroup(() -> itemGroup, "Create Automated resources");
        registrate.startSection(AllSections.MATERIALS);
        LAPIS_EXTRACTABLE = new GlueableExtractableResource("lapis", registrate, true, (NonNullSupplier<Item>)((NonNullSupplier)() -> Items.field_196128_bn), c -> c).node(1, 4, b -> b.atSpeedOf(128).takesSeconds(10).build(), c -> c, 1, 5).oreGen(10, 4, false);
        IRON_EXTRACTABLE = new IngotExtractableResource("iron", registrate, true, (NonNullSupplier<Item>)((NonNullSupplier)() -> Items.field_151042_j), c -> c, c -> c).node(1, 2, b -> b.atSpeedOf(128).takesSeconds(40).build(), c -> c, 3, 4).oreGen(4, 1, false);
        ZINC_EXTRACTABLE = new IngotExtractableResource("zinc", registrate, true, (NonNullSupplier<Item>)AllItems.ZINC_INGOT, c -> c, c -> c).node(1, 2, b -> b.atSpeedOf(128).takesSeconds(20).build(), c -> c, 3, 3).oreGen(9, 2, false);
        GOLD_EXTRACTABLE = new IngotExtractableResource("gold", registrate, true, (NonNullSupplier<Item>)((NonNullSupplier)() -> Items.field_151043_k), c -> c, c -> c).node(0, 2, b -> b.atSpeedOf(128).takesSeconds(35).build(), c -> c, 4, 2).oreGen(6, 1, false);
        COPPER_EXTRACTABLE = new IngotExtractableResource("copper", registrate, true, (NonNullSupplier<Item>)AllItems.COPPER_INGOT, c -> c, c -> c).node(1, 4, b -> b.atSpeedOf(128).takesSeconds(10).build(), c -> c, 3, 1).oreGen(16, 2, false);
        CINDER_FLOUR_EXTRACTABLE = new ExtractableResource("cinder_flour", registrate, c -> c.lang("Cinder Dust")).node(1, 3, b -> b.atSpeedOf(128).takesSeconds(5).build(), c -> c, 2, 6).oreGen(16, 0, 256, 10, true).recipe((prov, r) -> {
            MIXING.add("cinder_flour_from_ore_pieces", b -> {
                for (int i = 0; i < 9; ++i) {
                    b.require(r.ORE_PIECE_TAG);
                }
                b.require((Fluid)Fluids.field_204546_a, 10);
                return b.requiresHeat(HeatCondition.NONE).output((IItemProvider)AllItems.CINDER_FLOUR.get());
            });
            MIXING.add("netherrack_from_cinder_flour", b -> {
                for (int i = 0; i < 5; ++i) {
                    b.require((IItemProvider)AllItems.CINDER_FLOUR.get());
                }
                b.require((Fluid)Fluids.field_204546_a, 100);
                return b.requiresHeat(HeatCondition.NONE).output((IItemProvider)Blocks.field_150424_aL);
            });
        });
        DRILL_HEAD = new RecipeItem("drill_head", registrate, DrillHeadItem::new).quickTag(ModTags.Items.DRILL_HEADS, "iron").nonStackable().recipe((ctx, prov) -> ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ctx.get())).func_200472_a("bbb").func_200472_a("rbr").func_200472_a(" r ").func_200462_a(Character.valueOf('b'), (IItemProvider)Blocks.field_150339_S).func_200462_a(Character.valueOf('r'), (IItemProvider)Items.field_151042_j).func_200465_a("has_extractor", (ICriterionInstance)RegistrateRecipeProvider.hasItem((IItemProvider)((IItemProvider)ModBlocks.ORE_EXTRACTOR_BOTTOM.get()))).func_200464_a((Consumer)prov)).register();
        CRUSHED_PRISMARINE = RecipeItem.createBasic("crushed_prismarine", registrate).quickTag("crushed_prismarine", "vanilla").recipe((NonNullBiConsumer<DataGenContext<Item, Item>, RegistrateRecipeProvider>)((NonNullBiConsumer)(ctx, prov) -> CRUSHING.add("crushed_prismarine", b -> b.duration(150).require((ITag.INamedTag)Tags.Items.DUSTS_PRISMARINE).output(0.3f, (IItemProvider)ctx.get(), 1).output(0.1f, (IItemProvider)ctx.get(), 2)))).register();
        DIAMOND_RENEWABLE = new RenewableGem("diamond", registrate, () -> Items.field_151045_i, () -> Ingredient.func_199805_a((ITag)RecipeItems.CRUSHED_PRISMARINE.generalTag), 0.2f).register();
        EMERALD_RENEWABLE = new RenewableGem("emerald", registrate, () -> Items.field_151166_bC, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151079_bi}), 0.4f).register();
        CreateAutomated.modEventBus.addListener(RecipeItems::gatherData);
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        MIXING = new ModMixingRecipes(gen);
        EXTRACTING = new ExtractingRecipeGen(gen);
        CRUSHING = new ModCrushingRecipes(gen);
        DEPLOYING = new ModDeployingRecipes(gen);
        PICKING = new PickingRecipeGen(gen);
        SPLASHING = new ModSplashingRecipes(gen);
        gen.func_200390_a((IDataProvider)MIXING);
        gen.func_200390_a((IDataProvider)CRUSHING);
        gen.func_200390_a((IDataProvider)EXTRACTING);
        gen.func_200390_a((IDataProvider)PICKING);
        gen.func_200390_a((IDataProvider)DEPLOYING);
        gen.func_200390_a((IDataProvider)SPLASHING);
    }

    static {
        itemGroup = new ItemGroup("createautomated_resources"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)RecipeItems.IRON_EXTRACTABLE.ORE_PIECE.get());
            }
        };
    }

    public static class RenewableGem {
        public final String name;
        protected final CreateRegistrate registrate;
        protected Supplier<Ingredient> start;
        public Supplier<Item> gem;
        protected FluidBuilder<ForgeFlowingFluid.Flowing, CreateRegistrate> FLUID_BUILDER;
        public FluidEntry<ForgeFlowingFluid.Flowing> FLUID;
        public RecipeItem<Item> BIT;
        public Consumer<ItemBuilder<BucketItem, FluidBuilder<ForgeFlowingFluid.Flowing, CreateRegistrate>>> bucketTransform = b2 -> b2.recipe((ctx, prov) -> {
            MIXING.add(this.fluidName(), b -> {
                for (int i = 0; i < 3; ++i) {
                    b.require((ITag.INamedTag)this.BIT.itemTag);
                }
                return b.requiresHeat(HeatCondition.SUPERHEATED).output((Fluid)this.FLUID.get(), 150);
            });
            MIXING.add(this.fluidName() + "_from_ingot", b -> b.require((IItemProvider)this.gem.get()).requiresHeat(HeatCondition.SUPERHEATED).output((Fluid)this.FLUID.get(), 1000));
        }).properties(p -> p.func_200917_a(1));

        protected String bitName() {
            return this.name + "_bit";
        }

        protected String fluidName() {
            return "molten_" + this.name;
        }

        public RenewableGem(String name, CreateRegistrate registrate, Supplier<Item> gem, Supplier<Ingredient> start, float pickingChance) {
            this.name = name;
            this.gem = gem;
            this.registrate = registrate;
            this.start = start;
            this.BIT = RecipeItem.createBasic(this.bitName(), registrate).quickTag("bits", name).recipe((NonNullBiConsumer<DataGenContext<Item, Item>, RegistrateRecipeProvider>)((NonNullBiConsumer)(ctx, prov) -> {
                PICKING.add(this.bitName(), arg_0 -> RenewableGem.lambda$new$0((Supplier)start, pickingChance, ctx, arg_0));
                MIXING.add(name + "_from_bits", b -> b.require((ITag.INamedTag)this.BIT.itemTag).require((Fluid)this.FLUID.get(), 800).output((IItemProvider)this.gem.get()));
                CRUSHING.add(this.bitName(), arg_0 -> RenewableGem.lambda$new$2((Supplier)gem, ctx, arg_0));
            })).register();
            this.FLUID_BUILDER = registrate.fluid(this.fluidName(), ModFluids.still(this.fluidName()), ModFluids.flow(this.fluidName()), ModFluids.NoColorFluidAttributes::new).attributes(b -> b.viscosity(500).density(1400)).properties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).removeTag(new ITag.INamedTag[]{FluidTags.field_206959_a}).tag(new ITag.INamedTag[]{FluidTags.field_206960_b, AllTags.AllFluidTags.NO_INFINITE_DRAINING.tag});
        }

        public RenewableGem bit(Consumer<RecipeItem<Item>> cons) {
            cons.accept(this.BIT);
            return this;
        }

        public RenewableGem fluid(Consumer<FluidBuilder<ForgeFlowingFluid.Flowing, CreateRegistrate>> cons) {
            cons.accept(this.FLUID_BUILDER);
            return this;
        }

        public RenewableGem bucket(Consumer<ItemBuilder<BucketItem, FluidBuilder<ForgeFlowingFluid.Flowing, CreateRegistrate>>> cons) {
            this.bucketTransform = this.bucketTransform.andThen(cons);
            return this;
        }

        public RenewableGem register() {
            this.BIT.register();
            ItemBuilder bucket = this.FLUID_BUILDER.bucket();
            this.bucketTransform.accept((ItemBuilder<BucketItem, FluidBuilder<ForgeFlowingFluid.Flowing, CreateRegistrate>>)bucket);
            bucket.build();
            this.FLUID = this.FLUID_BUILDER.register();
            return this;
        }

        public RenewableGem noModel() {
            CreateAutomated.LOGGER.warn("Renewable " + this.name + " using no models");
            return this.fluid(b -> b.block().blockstate(($, $$) -> {}).build()).bit(RecipeItem::noModel).bucket(b -> b.model(($, $$) -> {}));
        }

        private static /* synthetic */ ProcessingRecipeBuilder lambda$new$2(Supplier gem, DataGenContext ctx, ProcessingRecipeBuilder b) {
            return b.require((IItemProvider)gem.get()).output((IItemProvider)ctx.get());
        }

        private static /* synthetic */ void lambda$new$0(Supplier start, float pickingChance, DataGenContext ctx, PickingRecipe b) {
            b.require((Ingredient)start.get()).output(pickingChance, (IItemProvider)ctx.get());
        }
    }

    public static class RecipeItem<T extends Item> {
        public final String name;
        public final CreateRegistrate reg;
        public ItemEntry<T> item;
        ItemBuilder<T, CreateRegistrate> builder;
        @Nullable
        public Tags.IOptionalNamedTag itemTag;
        @Nullable
        public Tags.IOptionalNamedTag generalTag;
        protected List<UnaryOperator<Item.Properties>> propertiesConfig = new ArrayList<UnaryOperator<Item.Properties>>();

        RecipeItem(String name, CreateRegistrate reg, NonNullFunction<Item.Properties, T> factory) {
            this.name = name;
            this.reg = reg;
            this.builder = reg.item(name, factory);
        }

        public static RecipeItem<Item> createBasic(String name, CreateRegistrate reg) {
            return new RecipeItem<Item>(name, reg, Item::new);
        }

        RecipeItem<T> recipe(NonNullBiConsumer<DataGenContext<Item, T>, RegistrateRecipeProvider> cons) {
            this.builder.recipe(cons);
            return this;
        }

        RecipeItem<T> quickTag(Tags.IOptionalNamedTag<Item> tag, String s) {
            this.itemTag = ItemTags.createOptional((ResourceLocation)new ResourceLocation(tag.func_230234_a_().func_110624_b(), tag.func_230234_a_().func_110623_a() + "/" + s));
            this.builder.tag(new ITag.INamedTag[]{tag, this.itemTag});
            this.generalTag = tag;
            return this;
        }

        RecipeItem<T> quickTag(String tag, String s) {
            this.generalTag = ModTags.Items.tag(tag, new Supplier[0]);
            this.builder.tag(new ITag.INamedTag[]{this.generalTag});
            return this.quickTag((Tags.IOptionalNamedTag<Item>)this.generalTag, s);
        }

        RecipeItem<T> quickTag(String tag) {
            this.generalTag = ModTags.Items.tag(tag, new Supplier[0]);
            this.builder.tag(new ITag.INamedTag[]{this.generalTag});
            return this;
        }

        RecipeItem<T> configureBuilder(NonNullConsumer<ItemBuilder<T, CreateRegistrate>> consumer) {
            consumer.accept(this.builder);
            return this;
        }

        RecipeItem<T> nonStackable() {
            return this.configureProperties(p -> p.func_200917_a(1));
        }

        RecipeItem<T> configureProperties(UnaryOperator<Item.Properties> f) {
            this.propertiesConfig.add(f);
            return this;
        }

        RecipeItem<T> noModel() {
            CreateAutomated.LOGGER.warn("Recipe item " + this.name + " has no model");
            return this.configureBuilder(b -> b.model(($, $$) -> {}));
        }

        RecipeItem<T> register() {
            this.item = this.builder.properties(p -> {
                for (UnaryOperator<Item.Properties> c : this.propertiesConfig) {
                    p = (Item.Properties)c.apply((Item.Properties)p);
                }
                return p;
            }).register();
            return this;
        }
    }

    public static class GlueableExtractableResource
    extends ExtractableResource {
        public GlueableExtractableResource(String name, CreateRegistrate reg, boolean autoCreateRecipes, NonNullSupplier<Item> output, Function<ItemBuilder<Item, CreateRegistrate>, ItemBuilder<Item, CreateRegistrate>> orePieceConf) {
            super(name, reg, orePieceConf);
            if (autoCreateRecipes) {
                this.recipe((provider, $) -> MIXING.add(name + "_gluing", b -> {
                    for (int i = 0; i < 8; ++i) {
                        b.require((ITag.INamedTag)this.ORE_PIECE_TAG);
                    }
                    return b.require((IItemProvider)Items.field_151123_aH).output((IItemProvider)output.get()).requiresHeat(HeatCondition.SUPERHEATED);
                }));
            }
        }
    }

    public static class IngotExtractableResource
    extends ExtractableResource {
        public final boolean autoCreateRecipes;

        public IngotExtractableResource(String name, CreateRegistrate reg, boolean autoCreateRecipes, @Nullable NonNullSupplier<Item> ingot, Function<ItemBuilder<Item, CreateRegistrate>, ItemBuilder<Item, CreateRegistrate>> orePieceConf, Function<ItemBuilder<Item, CreateRegistrate>, ItemBuilder<Item, CreateRegistrate>> ingotPieceConf) {
            super(name, reg, orePieceConf);
            this.autoCreateRecipes = autoCreateRecipes;
            if (autoCreateRecipes) {
                this.recipe((provider, $) -> MIXING.add(name + "_ingot_from_pieces", b -> {
                    for (int i = 0; i < 9; ++i) {
                        b.require((ITag.INamedTag)this.ORE_PIECE_TAG);
                    }
                    return b.output((IItemProvider)ingot.get()).requiresHeat(HeatCondition.SUPERHEATED);
                }));
            }
        }
    }

    public static class ExtractableResource {
        public final String name;
        public CreateRegistrate reg;
        public BlockEntry<NodeBlock> NODE;
        public ItemEntry<Item> ORE_PIECE;
        public final Tags.IOptionalNamedTag<Block> NODE_TAG;
        public final Tags.IOptionalNamedTag<Item> ORE_PIECE_TAG;
        List<BiConsumer<RegistrateRecipeProvider, ExtractableResource>> recipeGen = new ArrayList<BiConsumer<RegistrateRecipeProvider, ExtractableResource>>();
        public Function<BlockBuilder<Block, CreateRegistrate>, BlockBuilder<Block, CreateRegistrate>> nodeConf = c -> c;

        public ExtractableResource(String name, CreateRegistrate reg, Function<ItemBuilder<Item, CreateRegistrate>, ItemBuilder<Item, CreateRegistrate>> orePieceConf) {
            EXTRACTABLES.add(this);
            this.name = name;
            this.reg = reg;
            this.NODE_TAG = ModTags.Blocks.tag("nodes/" + name, new Supplier[0]);
            this.ORE_PIECE_TAG = ModTags.Items.tag("ore_pieces/" + name, new Supplier[0]);
            this.ORE_PIECE = orePieceConf.apply((ItemBuilder<Item, CreateRegistrate>)reg.item(name + "_ore_piece", Item::new).recipe((ctx, prov) -> this.recipeGen.forEach(r -> r.accept(prov, this))).tag(new ITag.INamedTag[]{ModTags.Items.ORE_PIECES, this.ORE_PIECE_TAG}).model((ctx, prov) -> prov.singleTexture(ctx.getName(), prov.mcLoc("item/generated"), "layer0", prov.modLoc("item/ore_pieces/" + name)))).register();
        }

        public ExtractableResource oreGen(int veinSize, int minHeight, int maxHeight, int frequency, boolean nether) {
            DimensionalConfigDrivenFeatureEntry entry = nether ? DimensionalConfigDrivenFeatureEntry.nether(this.name + "_node", this.NODE, veinSize, frequency) : DimensionalConfigDrivenFeatureEntry.overworld(this.name + "_node", this.NODE, veinSize, frequency);
            WorldGen.register(entry.between(minHeight, maxHeight));
            return this;
        }

        public ExtractableResource oreGen(int veinSize, int frequency, boolean nether) {
            return this.oreGen(veinSize, 40, 256, frequency, nether);
        }

        public ExtractableResource node(int minOre, int maxOre, Function<IOreExtractorBlock.ExtractorProgressBuilder, Integer> progress, Function<BlockBuilder<NodeBlock, CreateRegistrate>, BlockBuilder<NodeBlock, CreateRegistrate>> conf, int drillDamage, boolean tooltip, int count) {
            String nodeName = this.name + "_node";
            this.NODE = conf.apply((BlockBuilder<NodeBlock, CreateRegistrate>)this.reg.block(nodeName, NodeBlock::new).properties(p -> p.func_200943_b(0.5f)).recipe((ctx, prov) -> EXTRACTING.add(this.name, e -> e.output((NonNullSupplier<Item>)this.ORE_PIECE).node((IItemProvider)ctx.get()).ore(minOre, maxOre).requiredProgress((Integer)progress.apply(new IOreExtractorBlock.ExtractorProgressBuilder())).drillDamage(drillDamage))).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), prov.modLoc("block/nodes/" + this.name)))).tag(new ITag.INamedTag[]{ModTags.Blocks.NODES, this.NODE_TAG}).loot((p, b) -> p.func_218507_a((Block)b, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)((ConfigEnabledCondition.Serializer)ModConditions.CONFIG_NODES_DROP.func_237408_a_()).get()).func_212840_b_(SurvivesExplosion.func_215968_b()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)b))))).simpleItem()).register();
            if (tooltip) {
                ModTooltips.onRegister(reg -> ModTooltips.register((Block)this.NODE.get(), "Some dirt with ore in it, but _how much?_", "When mined by an extractor", minOre == maxOre ? "Gives _" + minOre + " " + this.getOrePieceName() + "_" : "Gives _" + minOre + "_ to _" + maxOre + " " + this.getOrePieceName() + "_"));
            }
            if (count > 0) {
                ModServerConfig.Extractor.Nodes.reg(() -> new ModServerConfig.Extractor.Nodes.Node(new ResourceLocation("createautomated", nodeName), true, count, false));
            }
            return this;
        }

        public String getOrePieceName() {
            return RegistrateLangProvider.toEnglishName((String)this.ORE_PIECE.getId().func_110623_a());
        }

        public ExtractableResource node(int minOre, int maxOre, Function<IOreExtractorBlock.ExtractorProgressBuilder, Integer> progress, Function<BlockBuilder<NodeBlock, CreateRegistrate>, BlockBuilder<NodeBlock, CreateRegistrate>> conf, int drillDamage, int count) {
            return this.node(minOre, maxOre, progress, conf, drillDamage, false, count);
        }

        public ExtractableResource node(int ore, Function<IOreExtractorBlock.ExtractorProgressBuilder, Integer> progress, Function<BlockBuilder<NodeBlock, CreateRegistrate>, BlockBuilder<NodeBlock, CreateRegistrate>> conf, int drillDamage, int count) {
            return this.node(ore, ore, progress, conf, drillDamage, count);
        }

        public ExtractableResource recipe(BiConsumer<RegistrateRecipeProvider, ExtractableResource> consumer) {
            this.recipeGen.add(consumer);
            return this;
        }
    }
}

