/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.network;

import com.ldtteam.storageracks.inv.CombinedItemHandler;
import com.ldtteam.storageracks.network.IMessage;
import com.ldtteam.storageracks.tileentities.AbstractTileEntityRack;
import com.ldtteam.storageracks.tileentities.TileEntityController;
import com.ldtteam.storageracks.utils.SortingUtils;
import com.ldtteam.storageracks.utils.SoundUtils;
import com.ldtteam.storageracks.utils.WorldUtil;
import java.util.LinkedHashSet;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class SortControllerMessage
implements IMessage {
    private BlockPos controllerPos;

    public SortControllerMessage() {
    }

    public SortControllerMessage(BlockPos pos) {
        this.controllerPos = pos;
    }

    @Override
    public void toBytes(PacketBuffer packetBuffer) {
        packetBuffer.func_179255_a(this.controllerPos);
    }

    @Override
    public void fromBytes(PacketBuffer buf) {
        this.controllerPos = buf.func_179259_c();
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context context, boolean b) {
        World world = context.getSender().func_130014_f_();
        TileEntity tileEntity = world.func_175625_s(this.controllerPos);
        if (tileEntity instanceof TileEntityController && ((TileEntityController)tileEntity).isSortUnlocked()) {
            LinkedHashSet<IItemHandlerModifiable> handlers = new LinkedHashSet<IItemHandlerModifiable>();
            for (BlockPos pos : ((TileEntityController)tileEntity).racks) {
                TileEntity te;
                if (!WorldUtil.isBlockLoaded((IWorld)world, pos) || !((te = world.func_175625_s(pos)) instanceof AbstractTileEntityRack)) continue;
                handlers.add((IItemHandlerModifiable)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).resolve().get());
            }
            SortingUtils.sort(new CombinedItemHandler("controller", handlers.toArray(new IItemHandlerModifiable[0])));
            SoundUtils.playSuccessSound((PlayerEntity)context.getSender(), this.controllerPos);
        }
    }
}

