/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.watut.WatutMod;
import com.corosus.watut.math.Lerpables;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.particle.Particle;
import net.minecraft.nbt.CompoundNBT;

public class PlayerStatus {
    private PlayerGuiState playerGuiState;
    private float typingAmplifier = 1.0f;
    private float screenPosPercentX = 0.0f;
    private float screenPosPercentY = 0.0f;
    private boolean isPressing = false;
    private int ticksSinceLastAction = 0;
    private int ticksToMarkPlayerIdleSyncedForClient = 6000;
    private Particle particle;
    private Particle particleIdle;
    private long lastTypeTime;
    private String lastTypeString = "";
    private boolean flagForRemoval = false;
    private long lastTypeTimeForAmp;
    private String lastTypeStringForAmp = "";
    private int lastTypeDiff;
    private Lerpables lerpTarget = new Lerpables();
    private Lerpables lerpPrev = new Lerpables();
    public float lerpTicks = 0.0f;
    public float lerpTicksPrev = 0.0f;
    public float lerpTicksMax = 5.0f;
    public float lastPartialTick = 0.0f;
    public float yRotHeadWhileOverriding = 0.0f;
    public float xRotHeadWhileOverriding = 0.0f;
    public float yRotHeadBeforeOverriding = 0.0f;
    public float xRotHeadBeforeOverriding = 0.0f;
    private float typingAmplifierSmooth = 0.5f;
    private CompoundNBT nbtCache = new CompoundNBT();

    public PlayerStatus(PlayerGuiState playerGuiState) {
        this.playerGuiState = playerGuiState;
    }

    public void tick() {
        this.lerpTicksPrev = this.lerpTicks;
        if (this.isLerping()) {
            this.lerpTicks += 1.0f;
        }
    }

    public void setNewLerp(float ticks) {
        this.lerpTicksMax = ticks;
        this.lerpTicks = 0.0f;
        this.lerpTicksPrev = 0.0f;
    }

    public float getPartialLerp(float partialTick) {
        float lerpPrev = this.lerpTicksPrev / this.lerpTicksMax;
        float lerp = this.lerpTicks / this.lerpTicksMax;
        return Math.min(lerpPrev + (lerp - lerpPrev) * partialTick, this.lerpTicksMax);
    }

    public void resetParticles() {
        if (this.particle != null) {
            this.particle.func_187112_i();
        }
        if (this.particleIdle != null) {
            this.particleIdle.func_187112_i();
        }
        this.particle = null;
        this.particleIdle = null;
    }

    public void reset() {
        this.resetParticles();
        WatutMod.dbg("remove trigger for " + this);
        this.ticksSinceLastAction = 0;
    }

    public boolean isLerping() {
        return this.lerpTicks < this.lerpTicksMax;
    }

    public PlayerGuiState getPlayerGuiState() {
        return this.playerGuiState;
    }

    public void setPlayerGuiState(PlayerGuiState playerGuiState) {
        this.playerGuiState = playerGuiState;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public void setParticle(Particle particle) {
        this.particle = particle;
    }

    public long getLastTypeTime() {
        return this.lastTypeTime;
    }

    public void setLastTypeTime(long lastTypeTime) {
        this.lastTypeTime = lastTypeTime;
    }

    public String getLastTypeString() {
        return this.lastTypeString;
    }

    public void setLastTypeString(String lastTypeString) {
        this.lastTypeString = lastTypeString;
    }

    public float getScreenPosPercentX() {
        return this.screenPosPercentX;
    }

    public void setScreenPosPercentX(float screenPosPercentX) {
        this.screenPosPercentX = screenPosPercentX;
    }

    public float getScreenPosPercentY() {
        return this.screenPosPercentY;
    }

    public void setScreenPosPercentY(float screenPosPercentY) {
        this.screenPosPercentY = screenPosPercentY;
    }

    public Lerpables getLerpTarget() {
        return this.lerpTarget;
    }

    public void setLerpTarget(Lerpables lerpTarget) {
        this.lerpTarget = lerpTarget;
    }

    public Lerpables getLerpPrev() {
        return this.lerpPrev;
    }

    public void setLerpPrev(Lerpables lerpPrev) {
        this.lerpPrev = lerpPrev;
    }

    public boolean isPressing() {
        return this.isPressing;
    }

    public void setPressing(boolean pressing) {
        this.isPressing = pressing;
    }

    public float getTypingAmplifier() {
        return this.typingAmplifier;
    }

    public void setTypingAmplifier(float typingAmplifier) {
        this.typingAmplifier = typingAmplifier;
    }

    public int getLastTypeDiff() {
        return this.lastTypeDiff;
    }

    public void setLastTypeDiff(int lastTypeDiff) {
        this.lastTypeDiff = lastTypeDiff;
    }

    public long getLastTypeTimeForAmp() {
        return this.lastTypeTimeForAmp;
    }

    public void setLastTypeTimeForAmp(long lastTypeTimeForAmp) {
        this.lastTypeTimeForAmp = lastTypeTimeForAmp;
    }

    public String getLastTypeStringForAmp() {
        return this.lastTypeStringForAmp;
    }

    public void setLastTypeStringForAmp(String lastTypeStringForAmp) {
        this.lastTypeStringForAmp = lastTypeStringForAmp;
    }

    public int getTicksSinceLastAction() {
        return this.ticksSinceLastAction;
    }

    public void setTicksSinceLastAction(int ticksSinceLastAction) {
        this.ticksSinceLastAction = ticksSinceLastAction;
    }

    public float getTypingAmplifierSmooth() {
        return this.typingAmplifierSmooth;
    }

    public void setTypingAmplifierSmooth(float typingAmplifierSmooth) {
        this.typingAmplifierSmooth = typingAmplifierSmooth;
    }

    public boolean isFlagForRemoval() {
        return this.flagForRemoval;
    }

    public void setFlagForRemoval(boolean flagForRemoval) {
        this.flagForRemoval = flagForRemoval;
    }

    public Particle getParticleIdle() {
        return this.particleIdle;
    }

    public void setParticleIdle(Particle particleIdle) {
        this.particleIdle = particleIdle;
    }

    public boolean isIdle() {
        return this.ticksSinceLastAction > this.ticksToMarkPlayerIdleSyncedForClient;
    }

    public CompoundNBT getNbtCache() {
        return this.nbtCache;
    }

    public void setNbtCache(CompoundNBT nbtCache) {
        this.nbtCache = nbtCache;
    }

    public int getTicksToMarkPlayerIdleSyncedForClient() {
        return this.ticksToMarkPlayerIdleSyncedForClient;
    }

    public void setTicksToMarkPlayerIdleSyncedForClient(int ticksToMarkPlayerIdleSyncedForClient) {
        this.ticksToMarkPlayerIdleSyncedForClient = ticksToMarkPlayerIdleSyncedForClient;
    }

    public static enum PlayerGuiState {
        NONE,
        CHAT_OPEN,
        CHAT_TYPING,
        INVENTORY,
        CRAFTING,
        ESCAPE,
        MISC;

        private static final Map<Integer, PlayerGuiState> lookup;

        public static PlayerGuiState get(int intValue) {
            return lookup.get(intValue);
        }

        static {
            lookup = new HashMap<Integer, PlayerGuiState>();
            for (PlayerGuiState e : EnumSet.allOf(PlayerGuiState.class)) {
                lookup.put(e.ordinal(), e);
            }
        }
    }
}

