/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.quark;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class TransferMessage {
    private final boolean isRestock;

    public TransferMessage(boolean isRestock) {
        this.isRestock = isRestock;
    }

    public static void encode(TransferMessage msg, PacketBuffer packetBuffer) {
        packetBuffer.writeBoolean(msg.isRestock);
    }

    public static TransferMessage decode(PacketBuffer packetBuffer) {
        return new TransferMessage(packetBuffer.readBoolean());
    }

    static void onMessage(TransferMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> TransferMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayerEntity player, TransferMessage msg) {
        if (player == null || !(player.field_71070_bA instanceof BackpackContainer)) {
            return;
        }
        BackpackContainer backpackContainer = (BackpackContainer)player.field_71070_bA;
        BackpackInventoryHandler backpackInventory = backpackContainer.getBackpackWrapper().getInventoryHandler();
        if (msg.isRestock) {
            player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(playerInv -> InventoryHelper.transfer((IItemHandler)backpackInventory, playerInv, s -> {}));
        } else {
            PlayerInventory inv = player.field_71071_by;
            for (int i = PlayerInventory.func_70451_h(); i < inv.field_70462_a.size(); ++i) {
                ItemStack stackAt = inv.func_70301_a(i);
                if (stackAt.func_190926_b()) continue;
                inv.func_70299_a(i, backpackInventory.insertItem(stackAt, false));
            }
        }
    }
}

