/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.tileentities;

import com.ldtteam.storageracks.blocks.ControllerBlock;
import com.ldtteam.storageracks.inv.InsertContainer;
import com.ldtteam.storageracks.tileentities.AbstractTileEntityRack;
import com.ldtteam.storageracks.tileentities.ModTileEntities;
import com.ldtteam.storageracks.tileentities.TileEntityRack;
import com.ldtteam.storageracks.utils.InventoryUtils;
import com.ldtteam.storageracks.utils.WorldUtil;
import com.ldtteam.structurize.api.util.BlockPosUtil;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityController
extends TileEntity
implements INamedContainerProvider {
    public Set<BlockPos> racks = new HashSet<BlockPos>();
    private int tier;
    private boolean unlockedSort;
    private boolean unlockedInsert;

    public TileEntityRack getRackForStack(ItemStack stack) {
        TileEntityRack rack = this.getPositionOfChestWithItemStack(stack);
        if (rack == null && (rack = this.getPositionOfChestWithSimilarItemStack(stack)) == null) {
            rack = this.searchMostEmptyRack();
        }
        return rack;
    }

    public boolean insertItemStack(ItemStack stack) {
        TileEntityRack rack = this.getRackForStack(stack);
        if (rack == null) {
            return false;
        }
        return InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(stack, (IItemHandler)rack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse((Object)new ItemStackHandler(0)));
    }

    public TileEntityController() {
        super(ModTileEntities.CONTROLLER);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.racks.clear();
        this.setTier(((ControllerBlock)state.func_177230_c()).getTier());
        ListNBT racksNBT = compound.func_150295_c("inventory", 10);
        for (int i = 0; i < racksNBT.size(); ++i) {
            CompoundNBT posCompound = racksNBT.func_150305_b(i);
            this.racks.add(BlockPosUtil.readFromNBT((CompoundNBT)posCompound, (String)"pos"));
        }
        this.unlockedSort = compound.func_74767_n("sort");
        this.unlockedInsert = compound.func_74767_n("insert");
    }

    @NotNull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ListNBT racksNBT = new ListNBT();
        for (BlockPos pos : this.racks) {
            CompoundNBT newCompound = new CompoundNBT();
            BlockPosUtil.writeToNBT((CompoundNBT)newCompound, (String)"pos", (BlockPos)pos);
            racksNBT.add((Object)newCompound);
        }
        compound.func_218657_a("inventory", (INBT)racksNBT);
        compound.func_74757_a("sort", this.unlockedSort);
        compound.func_74757_a("insert", this.unlockedInsert);
        return compound;
    }

    public void func_70296_d() {
        WorldUtil.markChunkDirty(this.field_145850_b, this.func_174877_v());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT compound = new CompoundNBT();
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189515_b(compound));
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public void unlockSort() {
        this.unlockedSort = true;
        this.func_70296_d();
    }

    public void unlockInsert() {
        this.unlockedInsert = true;
        this.func_70296_d();
    }

    public boolean isSortUnlocked() {
        return this.unlockedSort;
    }

    public boolean isInsertUnlocked() {
        return this.unlockedInsert;
    }

    @Nullable
    public TileEntityRack getPositionOfChestWithItemStack(@NotNull ItemStack stack) {
        for (BlockPos pos : this.racks) {
            TileEntity entity;
            if (!WorldUtil.isBlockLoaded((IWorld)this.field_145850_b, pos) || !((entity = this.func_145831_w().func_175625_s(pos)) instanceof AbstractTileEntityRack) || ((AbstractTileEntityRack)entity).getFreeSlots() <= 0 || !((AbstractTileEntityRack)entity).hasItemStack(stack, 1)) continue;
            return (TileEntityRack)entity;
        }
        return null;
    }

    @Nullable
    public TileEntityRack getPositionOfChestWithSimilarItemStack(@NotNull ItemStack stack) {
        for (BlockPos pos : this.racks) {
            TileEntity entity;
            if (!WorldUtil.isBlockLoaded((IWorld)this.field_145850_b, pos) || !((entity = this.func_145831_w().func_175625_s(pos)) instanceof AbstractTileEntityRack) || ((AbstractTileEntityRack)entity).getFreeSlots() <= 0 || !((AbstractTileEntityRack)entity).hasSimilarStack(stack)) continue;
            return (TileEntityRack)entity;
        }
        return null;
    }

    @Nullable
    private TileEntityRack searchMostEmptyRack() {
        int freeSlots = 0;
        TileEntityRack emptiestChest = null;
        for (BlockPos pos : this.racks) {
            TileEntity entity = this.func_145831_w().func_175625_s(pos);
            if (!(entity instanceof TileEntityRack)) continue;
            if (((AbstractTileEntityRack)entity).isEmpty()) {
                return (TileEntityRack)entity;
            }
            int tempFreeSlots = ((AbstractTileEntityRack)entity).getFreeSlots();
            if (tempFreeSlots <= freeSlots) continue;
            freeSlots = tempFreeSlots;
            emptiestChest = (TileEntityRack)entity;
        }
        return emptiestChest;
    }

    public void addAll(Set<BlockPos> visitedPositions) {
        if (visitedPositions.size() > this.tier * 20) {
            return;
        }
        this.racks.clear();
        this.racks.addAll(visitedPositions);
        this.func_70296_d();
    }

    public void removeAll(Set<BlockPos> visitedPositions) {
        this.racks.removeAll(visitedPositions);
        this.func_70296_d();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction dir) {
        if (!this.field_145846_f && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> new ControllerInventory());
        }
        return super.getCapability(capability, dir);
    }

    @NotNull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.title.insertion");
    }

    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
        return new InsertContainer(id, inv, (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse((Object)new ItemStackHandler(0)));
    }

    public class ControllerInventory
    extends ItemStackHandler {
        public ControllerInventory() {
            super(5);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            if (((TileEntityController)TileEntityController.this).field_145850_b.field_72995_K) {
                return;
            }
            TileEntityController.this.insertItemStack(stack);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return TileEntityController.this.getRackForStack(stack) != null;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (((TileEntityController)TileEntityController.this).field_145850_b.field_72995_K) {
                return ItemStack.field_190927_a;
            }
            if (simulate) {
                if (TileEntityController.this.getRackForStack(stack) == null) {
                    return stack;
                }
                return ItemStack.field_190927_a;
            }
            if (!TileEntityController.this.insertItemStack(stack)) {
                return stack;
            }
            return ItemStack.field_190927_a;
        }
    }
}

