/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks.gui;

import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneBuilders;
import com.ldtteam.blockout.controls.AbstractTextBuilder;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.storageracks.AbstractWindowSkeleton;
import com.ldtteam.storageracks.HighlightManager;
import com.ldtteam.storageracks.ItemStorage;
import com.ldtteam.storageracks.network.Network;
import com.ldtteam.storageracks.network.OpenInventoryMessage;
import com.ldtteam.storageracks.network.SortControllerMessage;
import com.ldtteam.storageracks.network.UnlockInsertMessage;
import com.ldtteam.storageracks.network.UnlockSortMessage;
import com.ldtteam.storageracks.tileentities.TileEntityController;
import com.ldtteam.storageracks.tileentities.TileEntityRack;
import com.ldtteam.storageracks.utils.InventoryUtils;
import com.ldtteam.structurize.util.LanguageHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowHutAllInventory
extends AbstractWindowSkeleton {
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();
    public static final int RED;
    public static final int GREEN;
    List<ItemStorage> allItems = new ArrayList<ItemStorage>();
    private final ScrollingList stackList;
    private String filter = "";
    private int sortDescriptor = 0;
    private final TileEntityController controller;

    public WindowHutAllInventory(TileEntityController controller) {
        super("storageracks:gui/windowallinventory.xml");
        ItemIcon icon;
        this.controller = controller;
        this.registerButton("sortStorageFilter", this::setSortFlag);
        this.stackList = (ScrollingList)this.findPaneOfTypeByID("allinventorylist", ScrollingList.class);
        this.updateResources();
        this.registerButton("locate", this::locate);
        this.registerButton("sort", this::sort);
        this.registerButton("insert", this::insert);
        if (controller.isSortUnlocked()) {
            ((ButtonImage)this.findPaneOfTypeByID("sort", ButtonImage.class)).setText((IFormattableTextComponent)new TranslationTextComponent("gui.storageracks.sort"));
        } else {
            ((ButtonImage)this.findPaneOfTypeByID("sort", ButtonImage.class)).setText((IFormattableTextComponent)new TranslationTextComponent("gui.storageracks.sort.unlock"));
            icon = (ItemIcon)this.findPaneOfTypeByID("sortcost", ItemIcon.class);
            this.setupIcon(icon, Items.field_221858_em);
        }
        if (controller.isInsertUnlocked()) {
            ((ButtonImage)this.findPaneOfTypeByID("insert", ButtonImage.class)).setText((IFormattableTextComponent)new TranslationTextComponent("gui.storageracks.insert"));
        } else {
            ((ButtonImage)this.findPaneOfTypeByID("insert", ButtonImage.class)).setText((IFormattableTextComponent)new TranslationTextComponent("gui.storageracks.insert.unlock"));
            icon = (ItemIcon)this.findPaneOfTypeByID("insertcost", ItemIcon.class);
            this.setupIcon(icon, Items.field_221862_eo);
        }
    }

    private void setupIcon(ItemIcon icon, Item item) {
        icon.setVisible(true);
        icon.setItem(new ItemStack((IItemProvider)item, 1));
        if (InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by), item) >= 0) {
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)icon).paragraphBreak()).append((IFormattableTextComponent)new TranslationTextComponent("gui.storage.racks.available"))).color(GREEN)).build();
        } else {
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)icon).paragraphBreak()).append((IFormattableTextComponent)new TranslationTextComponent("gui.storage.racks.missing"))).color(RED)).build();
        }
    }

    private void insert() {
        if (this.controller.isInsertUnlocked()) {
            Network.getNetwork().sendToServer(new OpenInventoryMessage(this.controller.func_174877_v()));
        } else {
            Network.getNetwork().sendToServer(new UnlockInsertMessage(this.controller.func_174877_v()));
            this.close();
        }
    }

    private void sort() {
        if (this.controller.isSortUnlocked()) {
            Network.getNetwork().sendToServer(new SortControllerMessage(this.controller.func_174877_v()));
        } else {
            Network.getNetwork().sendToServer(new UnlockSortMessage(this.controller.func_174877_v()));
        }
        this.close();
    }

    private void locate(Button button) {
        int row = this.stackList.getListElementIndexByPane((Pane)button);
        ItemStorage storage = this.allItems.get(row);
        HashSet<BlockPos> containerList = new HashSet<BlockPos>(this.controller.racks);
        for (BlockPos blockPos : containerList) {
            TileEntity rack = Minecraft.func_71410_x().field_71441_e.func_175625_s(blockPos);
            if (!(rack instanceof TileEntityRack) || !((TileEntityRack)rack).hasItemStack(storage.getItemStack(), 1)) continue;
            HighlightManager.HIGHLIGHT_MAP.put("inventoryHighlight", (Tuple<BlockPos, Long>)new Tuple((Object)blockPos, (Object)(Minecraft.func_71410_x().field_71441_e.func_82737_E() + 2400L)));
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("gui.storageracks.locating"), Minecraft.func_71410_x().field_71439_g.func_110124_au());
            this.close();
            return;
        }
    }

    private void setSortFlag() {
        ++this.sortDescriptor;
        if (this.sortDescriptor > 4) {
            this.sortDescriptor = 0;
        }
        switch (this.sortDescriptor) {
            case 0: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText((IFormattableTextComponent)new StringTextComponent("v^"));
                break;
            }
            case 1: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText((IFormattableTextComponent)new StringTextComponent("A^"));
                break;
            }
            case 2: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText((IFormattableTextComponent)new StringTextComponent("Av"));
                break;
            }
            case 3: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText((IFormattableTextComponent)new StringTextComponent("1^"));
                break;
            }
            case 4: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText((IFormattableTextComponent)new StringTextComponent("1v"));
                break;
            }
        }
        this.updateResources();
    }

    private void updateResources() {
        HashSet<BlockPos> containerList = new HashSet<BlockPos>(this.controller.racks);
        HashMap<ItemStorage, Integer> storedItems = new HashMap<ItemStorage, Integer>();
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        for (BlockPos blockPos : containerList) {
            TileEntity rack = level.func_175625_s(blockPos);
            if (!(rack instanceof TileEntityRack)) continue;
            Map<ItemStorage, Integer> rackStorage = ((TileEntityRack)rack).getAllContent();
            for (Map.Entry<ItemStorage, Integer> entry : rackStorage.entrySet()) {
                if (storedItems.containsKey(entry.getKey())) {
                    storedItems.put(entry.getKey(), (Integer)storedItems.get(entry.getKey()) + entry.getValue());
                    continue;
                }
                storedItems.put(entry.getKey(), entry.getValue());
            }
        }
        ArrayList filterItems = new ArrayList();
        storedItems.forEach((storage, amount) -> {
            storage.setAmount((int)amount);
            filterItems.add(storage);
        });
        Predicate<ItemStorage> filterPredicate = stack -> this.filter.isEmpty() || stack.getItemStack().func_77977_a().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.getItemStack().func_151000_E().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US));
        this.allItems.clear();
        if (this.filter.isEmpty()) {
            this.allItems.addAll(filterItems);
        } else {
            this.allItems.addAll(filterItems.stream().filter(filterPredicate).collect(Collectors.toList()));
        }
        Comparator<ItemStorage> compareByName = Comparator.comparing(o -> o.getItemStack().func_151000_E().getString());
        Comparator<ItemStorage> compareByCount = Comparator.comparingInt(ItemStorage::getAmount);
        switch (this.sortDescriptor) {
            case 0: {
                break;
            }
            case 1: {
                this.allItems.sort(compareByName);
                break;
            }
            case 2: {
                this.allItems.sort(compareByName.reversed());
                break;
            }
            case 3: {
                this.allItems.sort(compareByCount);
                break;
            }
            case 4: {
                this.allItems.sort(compareByCount.reversed());
                break;
            }
        }
        this.updateResourceList();
    }

    private void updateResourceList() {
        this.stackList.enable();
        this.stackList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHutAllInventory.this.allItems.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStorage resource = WindowHutAllInventory.this.allItems.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("ressourceStackName", Text.class);
                String name = LanguageHandler.format((String)resource.getItemStack().func_77977_a(), (Object[])new Object[0]);
                resourceLabel.setText(name.substring(0, Math.min(17, name.length())));
                Text qtys = (Text)rowPane.findPaneOfTypeByID("quantities", Text.class);
                if (!Screen.func_231173_s_()) {
                    qtys.setText(WindowHutAllInventory.format(resource.getAmount()));
                } else {
                    qtys.setText(Integer.toString(resource.getAmount()));
                }
                Item imagesrc = resource.getItemStack().func_77973_b();
                ItemStack image = new ItemStack((IItemProvider)imagesrc, 1);
                image.func_77982_d(resource.getItemStack().func_77978_p());
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(image);
            }
        });
    }

    public static String format(long value) {
        if (value == Long.MIN_VALUE) {
            return WindowHutAllInventory.format(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + WindowHutAllInventory.format(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)truncated / 10.0;
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        if (result) {
            this.filter = ((TextField)this.findPaneOfTypeByID("names", TextField.class)).getText();
            this.updateResources();
        }
        return result;
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
        RED = Color.rgbaToInt((int)240, (int)150, (int)135, (int)255);
        GREEN = Color.rgbaToInt((int)85, (int)255, (int)255, (int)255);
    }
}

