/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.storageracks;

import com.ldtteam.storageracks.utils.ItemStackUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStorage {
    private final ItemStack stack;
    private final List<Integer> creativeTabIndex;
    private int amount;

    public ItemStorage(@NotNull ItemStack stack) {
        this.stack = stack;
        this.amount = ItemStackUtils.getSize(stack);
        this.creativeTabIndex = stack.func_77973_b().getCreativeTabs().stream().filter(Objects::nonNull).map(g -> g.field_78033_n).collect(Collectors.toList());
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getPrimaryCreativeTabIndex() {
        return this.creativeTabIndex.isEmpty() ? 0 : this.creativeTabIndex.get(0);
    }

    public int hashCode() {
        return Objects.hash(this.stack.func_77973_b());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemStorage)) {
            return false;
        }
        ItemStorage that = (ItemStorage)o;
        return this.stack.func_77969_a(that.getItemStack()) && that.getDamageValueValue() == this.getDamageValueValue() && (that.getItemStack().func_77978_p() == null && this.getItemStack().func_77978_p() == null || that.getItemStack().func_77978_p() != null && that.getItemStack().func_77978_p().equals((Object)this.getItemStack().func_77978_p()));
    }

    @NotNull
    public Item getItem() {
        return this.stack.func_77973_b();
    }

    public int getDamageValueValue() {
        return this.stack.func_77952_i();
    }

    public boolean isEmpty() {
        return ItemStackUtils.isEmpty(this.stack) != false || this.amount <= 0;
    }
}

