/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;

public class MessageFunctions {
    public static void sendMessage(CommandSource source, StringTextComponent message) {
        MessageFunctions.sendMessage(source, message, false);
    }

    public static void sendMessage(PlayerEntity player, StringTextComponent message) {
        MessageFunctions.sendMessage(player, message, false);
    }

    public static void sendMessage(CommandSource source, String m, TextFormatting colour) {
        MessageFunctions.sendMessage(source, m, colour, false);
    }

    public static void sendMessage(PlayerEntity player, String m, TextFormatting colour) {
        MessageFunctions.sendMessage(player, m, colour, false);
    }

    public static void sendMessage(CommandSource source, String m, TextFormatting colour, boolean emptyline) {
        MessageFunctions.sendMessage(source, m, colour, emptyline, "");
    }

    public static void sendMessage(PlayerEntity player, String m, TextFormatting colour, boolean emptyline) {
        MessageFunctions.sendMessage(player, m, colour, emptyline, "");
    }

    public static void sendMessage(CommandSource source, String m, TextFormatting colour, String url) {
        MessageFunctions.sendMessage(source, m, colour, false, url);
    }

    public static void sendMessage(PlayerEntity player, String m, TextFormatting colour, String url) {
        MessageFunctions.sendMessage(player, m, colour, false, url);
    }

    public static void sendMessage(CommandSource source, String m, TextFormatting colour, boolean emptyline, String url) {
        if (m.isEmpty()) {
            return;
        }
        StringTextComponent message = new StringTextComponent(m);
        message.func_240699_a_(colour);
        if (m.contains("http") || !url.isEmpty()) {
            if (url.isEmpty()) {
                for (String word : m.split(" ")) {
                    if (!word.contains("http")) continue;
                    url = word;
                    break;
                }
            }
            if (!url.isEmpty()) {
                Style clickstyle = message.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
                message.func_240703_c_(clickstyle);
            }
        }
        MessageFunctions.sendMessage(source, message, emptyline);
    }

    public static void sendMessage(CommandSource source, StringTextComponent message, boolean emptyline) {
        if (emptyline) {
            source.func_197030_a((ITextComponent)new StringTextComponent(""), false);
        }
        source.func_197030_a((ITextComponent)message, false);
    }

    public static void sendMessage(PlayerEntity player, String m, TextFormatting colour, boolean emptyline, String url) {
        if (m.isEmpty()) {
            return;
        }
        StringTextComponent message = new StringTextComponent(m);
        message.func_240699_a_(colour);
        if (m.contains("http") || !url.isEmpty()) {
            if (url.isEmpty()) {
                for (String word : m.split(" ")) {
                    if (!word.contains("http")) continue;
                    url = word;
                    break;
                }
            }
            if (!url.isEmpty()) {
                Style clickstyle = message.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
                message.func_240703_c_(clickstyle);
            }
        }
        MessageFunctions.sendMessage(player, message, emptyline);
    }

    public static void sendMessage(PlayerEntity player, StringTextComponent message, boolean emptyline) {
        if (emptyline) {
            player.func_145747_a((ITextComponent)new StringTextComponent(""), player.func_110124_au());
        }
        player.func_145747_a((ITextComponent)message, player.func_110124_au());
    }

    public static void broadcastMessage(World world, String m, TextFormatting colour) {
        if (m.isEmpty()) {
            return;
        }
        StringTextComponent message = new StringTextComponent(m);
        message.func_240699_a_(colour);
        MessageFunctions.broadcastMessage(world, message);
    }

    public static void broadcastMessage(World world, StringTextComponent message) {
        MinecraftServer server = world.func_73046_m();
        if (server == null) {
            return;
        }
        for (PlayerEntity player : server.func_184103_al().func_181057_v()) {
            MessageFunctions.sendMessage(player, message);
        }
    }

    public static void sendMessageToPlayersAround(World world, BlockPos p, int radius, String message, TextFormatting colour) {
        if (message.isEmpty()) {
            return;
        }
        for (Entity around : world.func_72839_b(null, new AxisAlignedBB((double)(p.func_177958_n() - radius), (double)(p.func_177956_o() - radius), (double)(p.func_177952_p() - radius), (double)(p.func_177958_n() + radius), (double)(p.func_177956_o() + radius), (double)(p.func_177952_p() + radius)))) {
            if (!(around instanceof PlayerEntity)) continue;
            MessageFunctions.sendMessage((PlayerEntity)around, message, colour);
        }
    }

    public static void sendMessageToPlayersAround(World world, BlockPos p, int radius, StringTextComponent message) {
        for (Entity around : world.func_72839_b(null, new AxisAlignedBB((double)(p.func_177958_n() - radius), (double)(p.func_177956_o() - radius), (double)(p.func_177952_p() - radius), (double)(p.func_177958_n() + radius), (double)(p.func_177956_o() + radius), (double)(p.func_177952_p() + radius)))) {
            if (!(around instanceof PlayerEntity)) continue;
            MessageFunctions.sendMessage((PlayerEntity)around, message);
        }
    }
}

