/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.util.TickedWorldOperation;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceBlockMessage
implements IMessage {
    private final BlockPos from;
    private final BlockPos to;
    private final ItemStack blockFrom;
    private final ItemStack blockTo;
    private final int pct;

    public ReplaceBlockMessage(PacketBuffer buf) {
        this.from = buf.func_179259_c();
        this.to = buf.func_179259_c();
        this.blockTo = buf.func_150791_c();
        this.blockFrom = buf.func_150791_c();
        this.pct = buf.readInt();
    }

    public ReplaceBlockMessage(BlockPos pos1, BlockPos pos2, ItemStack blockFrom, ItemStack blockTo, int pct) {
        this.from = pos1;
        this.to = pos2;
        this.blockFrom = blockFrom;
        this.blockTo = blockTo;
        this.pct = pct;
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.func_179255_a(this.from);
        buf.func_179255_a(this.to);
        buf.func_150788_a(this.blockTo);
        buf.func_150788_a(this.blockFrom);
        buf.writeInt(this.pct);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (!ctxIn.getSender().func_184812_l_()) {
            return;
        }
        Manager.addToQueue(new TickedWorldOperation(TickedWorldOperation.OperationType.REPLACE_BLOCK, this.from, this.to, (PlayerEntity)ctxIn.getSender(), this.blockFrom, this.blockTo, this.pct));
    }
}

