/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easy_villagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easy_villagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentityBase;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class AutoTraderTileentity
extends TraderTileentityBase {
    protected IInventory tradeGuiInv = new Inventory(3);
    private final NonNullList<ItemStack> inputInventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> outputInventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    protected int tradeIndex;
    private IItemHandlerModifiable foodInventoryHandler;
    private IItemHandlerModifiable outputInventoryHandler;

    public AutoTraderTileentity() {
        super((TileEntityType)ModTileEntities.AUTO_TRADER, ModBlocks.AUTO_TRADER.func_176223_P());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.hasVillager()) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % (long)((Integer)Main.SERVER_CONFIG.autoTraderCooldown.get()).intValue() != 0L) {
            return;
        }
        MerchantOffer offer = this.getOffer();
        if (offer == null || offer.func_222217_o() || this.inputInventory.isEmpty()) {
            return;
        }
        EasyVillagerEntity villager = this.getVillagerEntity();
        if (!(this.hasEnoughItems(offer.func_222205_b(), false) && this.hasEnoughItems(offer.func_222202_c(), false) && this.canFitItems(offer.func_222200_d(), false))) {
            return;
        }
        this.hasEnoughItems(offer.func_222205_b(), true);
        this.hasEnoughItems(offer.func_222202_c(), true);
        this.canFitItems(offer.func_222200_d(), true);
        offer.func_222219_j();
        villager.func_213761_t(villager.func_213708_dV() + offer.func_222210_n());
        if (villager.func_213741_eu()) {
            villager.field_213777_bF = true;
        }
        this.func_70296_d();
    }

    protected boolean hasEnoughItems(ItemStack buying, boolean remove) {
        if (buying.func_190926_b()) {
            return true;
        }
        int amount = buying.func_190916_E();
        for (ItemStack stack : this.inputInventory) {
            if (!ItemUtils.isStackable(stack, buying)) continue;
            int am = Math.min(amount, stack.func_190916_E());
            if (remove) {
                stack.func_190918_g(am);
            }
            if ((amount -= am) > 0) continue;
            return true;
        }
        return false;
    }

    protected boolean canFitItems(ItemStack insert, boolean doInsert) {
        if (insert.func_190926_b()) {
            return true;
        }
        ItemStack stack = insert.func_77946_l();
        IItemHandlerModifiable itemHandler = this.getOutputInventoryItemHandler();
        for (int i = 0; i < itemHandler.getSlots() && !(stack = itemHandler.insertItem(i, stack, !doInsert)).func_190926_b(); ++i) {
        }
        return stack.func_190926_b();
    }

    public IInventory getTradeGuiInv() {
        this.updateTradeInv();
        return this.tradeGuiInv;
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public void setTradeIndex(int tradeIndex) {
        this.tradeIndex = tradeIndex;
        this.updateTradeInv();
        this.func_70296_d();
    }

    @Override
    protected void onAddVillager(EasyVillagerEntity villager) {
        super.onAddVillager(villager);
        this.updateTradeInv();
    }

    @Override
    public void setWorkstation(Block workstation) {
        super.setWorkstation(workstation);
        this.updateTradeInv();
    }

    public void nextTrade() {
        int tradeCount = this.getTradeCount();
        if (tradeCount > 0) {
            this.setTradeIndex(Math.floorMod(this.tradeIndex + 1, tradeCount));
        }
    }

    public void prevTrade() {
        int tradeCount = this.getTradeCount();
        if (tradeCount > 0) {
            this.setTradeIndex(Math.floorMod(this.tradeIndex - 1, tradeCount));
        }
    }

    protected void updateTradeInv() {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            this.tradeGuiInv.func_174888_l();
            return;
        }
        villagerEntity.recalculateOffers();
        MerchantOffer offer = this.getOffer();
        if (offer == null) {
            this.tradeGuiInv.func_174888_l();
            return;
        }
        this.tradeGuiInv.func_70299_a(0, offer.func_222205_b());
        this.tradeGuiInv.func_70299_a(1, offer.func_222202_c());
        this.tradeGuiInv.func_70299_a(2, offer.func_222200_d());
    }

    @Nullable
    public MerchantOffer getOffer() {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return null;
        }
        MerchantOffers offers = villagerEntity.func_213706_dY();
        if (this.tradeIndex < 0 || this.tradeIndex >= offers.size()) {
            return null;
        }
        return (MerchantOffer)offers.get(this.tradeIndex);
    }

    protected int getTradeCount() {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return 0;
        }
        return villagerEntity.func_213706_dY().size();
    }

    @Override
    protected long calculateNextRestock() {
        return (Integer)Main.SERVER_CONFIG.autoTraderMinRestockTime.get() + this.field_145850_b.field_73012_v.nextInt(Math.max((Integer)Main.SERVER_CONFIG.autoTraderMaxRestockTime.get() - (Integer)Main.SERVER_CONFIG.autoTraderMinRestockTime.get(), 1));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("Trade", this.tradeIndex);
        compound.func_218657_a("InputInventory", (INBT)ItemStackHelper.func_191281_a((CompoundNBT)new CompoundNBT(), this.inputInventory, (boolean)true));
        compound.func_218657_a("OutputInventory", (INBT)ItemStackHelper.func_191281_a((CompoundNBT)new CompoundNBT(), this.outputInventory, (boolean)true));
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.tradeIndex = compound.func_74762_e("Trade");
        ItemStackHelper.func_191283_b((CompoundNBT)compound.func_74775_l("InputInventory"), this.inputInventory);
        ItemStackHelper.func_191283_b((CompoundNBT)compound.func_74775_l("OutputInventory"), this.outputInventory);
    }

    public IInventory getInputInventory() {
        return new ItemListInventory(this.inputInventory, () -> ((AutoTraderTileentity)this).func_70296_d());
    }

    public IInventory getOutputInventory() {
        return new ItemListInventory(this.outputInventory, () -> ((AutoTraderTileentity)this).func_70296_d());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side != null && side.equals((Object)Direction.DOWN)) {
                return LazyOptional.of(this::getOutputInventoryItemHandler).cast();
            }
            return LazyOptional.of(this::getInputInventoryItemHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public IItemHandlerModifiable getInputInventoryItemHandler() {
        if (this.foodInventoryHandler == null) {
            this.foodInventoryHandler = new ItemStackHandler(this.inputInventory);
        }
        return this.foodInventoryHandler;
    }

    public IItemHandlerModifiable getOutputInventoryItemHandler() {
        if (this.outputInventoryHandler == null) {
            this.outputInventoryHandler = new ItemStackHandler(this.outputInventory);
        }
        return this.outputInventoryHandler;
    }
}

